/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.state.consumer;

import java.io.Serializable;
import org.gatein.pc.portlet.state.InvalidStateIdException;
import org.gatein.pc.portlet.state.NoSuchStateException;
import org.gatein.pc.portlet.state.consumer.ConsumerPersistenceManager;
import org.gatein.pc.portlet.state.consumer.ConsumerState;
import org.gatein.pc.portlet.state.consumer.ConsumerStateContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConsumerPersistenceManagerService<S extends Serializable>
implements ConsumerPersistenceManager<S> {
    private int counter = 0;

    protected abstract ConsumerStateContext<S> get(String var1);

    protected abstract void put(String var1, ConsumerStateContext<S> var2);

    protected abstract void remove(String var1);

    protected abstract int size();

    @Override
    public synchronized ConsumerStateContext<S> loadState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        this.checkId(stateId);
        ConsumerStateContext<S> state = this.get(stateId);
        if (state == null) {
            throw new NoSuchStateException(stateId);
        }
        return state;
    }

    @Override
    public synchronized String createState(ConsumerState<S> state) throws IllegalArgumentException {
        if (state == null) {
            throw new IllegalArgumentException();
        }
        ConsumerStateContext<S> ctx = new ConsumerStateContext<S>(Integer.toString(this.counter++), state.getPortletId(), state.getStateType(), state.getState());
        this.put(ctx.getId(), ctx);
        return ctx.getId();
    }

    @Override
    public synchronized void updateState(String stateId, ConsumerState<S> state) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        this.checkId(stateId);
        if (state == null) {
            throw new IllegalArgumentException();
        }
        if (this.get(stateId) == null) {
            throw new NoSuchStateException(stateId);
        }
        this.put(stateId, new ConsumerStateContext<S>(stateId, state.getPortletId(), state.getStateType(), state.getState()));
    }

    @Override
    public synchronized void destroyState(String stateId) throws IllegalArgumentException, NoSuchStateException, InvalidStateIdException {
        this.checkId(stateId);
        if (this.get(stateId) != null) {
            throw new NoSuchStateException(stateId);
        }
        this.remove(stateId);
    }

    public synchronized int getSize() {
        return this.size();
    }

    private void checkId(String stateId) throws IllegalArgumentException, InvalidStateIdException {
        if (stateId == null) {
            throw new IllegalArgumentException("No null state id accepted");
        }
        try {
            Integer.parseInt(stateId);
        }
        catch (NumberFormatException e) {
            throw new InvalidStateIdException(e, stateId);
        }
    }
}

