/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.SingletonStoreDefaultConfig;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jgroups.Address;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonStoreCacheLoader
extends AbstractDelegatingCacheLoader {
    private static final Log log = LogFactory.getLog(SingletonStoreCacheLoader.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final String THREAD_NAME = "InMemoryToCacheLoaderPusher";
    private SingletonStoreDefaultConfig config;
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            return new Thread(r, SingletonStoreCacheLoader.THREAD_NAME);
        }
    });
    private Future<?> pushStateFuture;
    private Address localAddress;
    private boolean active;

    public SingletonStoreCacheLoader() {
        super(null);
    }

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        super.setConfig(config);
        CacheLoaderConfig.IndividualCacheLoaderConfig.SingletonStoreConfig ssc = config.getSingletonStoreConfig();
        this.config = ssc instanceof SingletonStoreDefaultConfig ? (SingletonStoreDefaultConfig)ssc : (ssc != null ? new SingletonStoreDefaultConfig(ssc) : new SingletonStoreDefaultConfig());
    }

    @Override
    public void create() throws Exception {
        super.create();
        this.cache.addCacheListener(new SingletonStoreListener());
    }

    protected SingletonStoreCacheLoader(SingletonStoreDefaultConfig config) {
        this();
        this.config = config;
    }

    protected SingletonStoreDefaultConfig getSingletonStoreDefaultConfig() {
        return this.config;
    }

    protected Future<?> getPushStateFuture() {
        return this.pushStateFuture;
    }

    protected void activeStatusChanged(boolean newActiveState) throws PushStateException {
        this.active = newActiveState;
        log.debug((Object)("changed mode: " + this));
        if (this.active && this.config.isPushStateWhenCoordinator()) {
            this.doPushState();
        }
    }

    protected Callable<?> createPushStateTask() {
        return new Callable(){

            public Object call() throws Exception {
                boolean debugEnabled = log.isDebugEnabled();
                if (debugEnabled) {
                    log.debug((Object)"start pushing in-memory state to cache cacheLoader");
                }
                SingletonStoreCacheLoader.this.pushState(SingletonStoreCacheLoader.this.cache.getRoot());
                if (debugEnabled) {
                    log.debug((Object)"in-memory state passed to cache cacheLoader successfully");
                }
                return null;
            }
        };
    }

    protected void pushState(NodeSPI node) throws Exception {
        Set children = node.getChildren();
        if (trace) {
            log.trace((Object)("Children for " + node.getFqn() + " are " + children));
        }
        if (!children.isEmpty()) {
            for (NodeSPI nodeSPI : children) {
                this.pushState(nodeSPI);
            }
        }
        Map data = node.getData();
        Fqn fqn = node.getFqn();
        if (!data.isEmpty()) {
            this.put(fqn, data);
        }
    }

    protected void awaitForPushToFinish(Future future, int timeout, TimeUnit unit) {
        block7: {
            boolean debugEnabled = log.isDebugEnabled();
            try {
                if (debugEnabled) {
                    log.debug((Object)"wait for state push to cache loader to finish");
                }
                future.get(timeout, unit);
            }
            catch (TimeoutException e) {
                if (debugEnabled) {
                    log.debug((Object)"timed out waiting for state push to cache loader to finish");
                }
            }
            catch (ExecutionException e) {
                if (debugEnabled) {
                    log.debug((Object)"exception reported waiting for state push to cache loader to finish");
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                if (!trace) break block7;
                log.trace((Object)"wait for state push to cache loader to finish was interrupted");
            }
        }
    }

    private void doPushState() throws PushStateException {
        if (this.pushStateFuture == null || this.pushStateFuture.isDone()) {
            Callable<?> task = this.createPushStateTask();
            this.pushStateFuture = this.executor.submit(task);
            try {
                this.waitForTaskToFinish(this.pushStateFuture, this.config.getPushStateWhenCoordinatorTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                throw new PushStateException("unable to complete in memory state push to cache loader", e);
            }
        } else {
            this.awaitForPushToFinish(this.pushStateFuture, this.config.getPushStateWhenCoordinatorTimeout(), TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForTaskToFinish(Future future, int timeout, TimeUnit unit) throws Exception {
        try {
            try {
                future.get(timeout, unit);
            }
            catch (TimeoutException e) {
                throw new Exception("task timed out", e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (trace) {
                    log.trace((Object)"task was interrupted");
                }
                Object var6_5 = null;
                future.cancel(true);
                return;
            }
            Object var6_4 = null;
            future.cancel(true);
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            future.cancel(true);
            throw throwable;
        }
    }

    private boolean isCoordinator(View newView) {
        if (newView != null && this.localAddress != null) {
            Vector mbrs = newView.getMembers();
            return mbrs != null && mbrs.size() > 0 && this.localAddress.equals(mbrs.firstElement());
        }
        return this.active;
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.active) {
            return super.put(name, key, value);
        }
        return null;
    }

    @Override
    public void put(Fqn name, Map attributes) throws Exception {
        if (this.active) {
            super.put(name, attributes);
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        if (this.active) {
            super.put(modifications);
        }
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        if (this.active) {
            return super.remove(fqn, key);
        }
        return null;
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        if (this.active) {
            super.remove(fqn);
        }
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        if (this.active) {
            super.removeData(fqn);
        }
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        if (this.active) {
            super.prepare(tx, modifications, one_phase);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        if (this.active) {
            super.commit(tx);
        }
    }

    @Override
    public void rollback(Object tx) {
        if (this.active) {
            super.rollback(tx);
        }
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        if (this.active) {
            super.storeEntireState(is);
        }
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        if (this.active) {
            super.storeState(subtree, is);
        }
    }

    public String toString() {
        return "loc_addr=" + this.localAddress + ", active=" + this.active;
    }

    public static class PushStateException
    extends Exception {
        private static final long serialVersionUID = 5542893943730200886L;

        public PushStateException(String message, Throwable cause) {
            super(message, cause);
        }

        public PushStateException(Throwable cause) {
            super(cause);
        }
    }

    @CacheListener
    public class SingletonStoreListener {
        @CacheStarted
        public void cacheStarted(Event e) {
            SingletonStoreCacheLoader.this.localAddress = SingletonStoreCacheLoader.this.cache.getLocalAddress();
            SingletonStoreCacheLoader.this.active = SingletonStoreCacheLoader.this.cache.getRPCManager().isCoordinator();
            if (log.isDebugEnabled()) {
                log.debug((Object)("cache started: " + this));
            }
        }

        @CacheStopped
        public void cacheStopped(Event e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cache stopped: " + this));
            }
        }

        @ViewChanged
        public void viewChange(ViewChangedEvent event) {
            boolean tmp = SingletonStoreCacheLoader.this.isCoordinator(event.getNewView());
            if (SingletonStoreCacheLoader.this.active != tmp) {
                try {
                    SingletonStoreCacheLoader.this.activeStatusChanged(tmp);
                }
                catch (PushStateException e) {
                    log.error((Object)"exception reported changing nodes active status", (Throwable)e);
                }
            }
        }
    }
}

