/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.gandiva.nameservice;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.gandiva.nameservice.NameServiceImple;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class PNS
extends NameServiceImple {
    private Properties _properties;
    private String _name;
    private boolean _initialized;
    private Uid _id;
    private static final char SIGNED_NUMBER = '#';
    private static final char UNSIGNED_NUMBER = '~';
    private static final char STRING = '^';
    private static final char OBJECTNAME = '%';
    private static final char CLASSNAME = '-';
    private static final char UID = '+';
    private static final char nameStart = '!';
    private static final String pnsName = "PNS:";

    public PNS() {
        this._properties = new Properties();
        this._name = null;
        this._initialized = false;
    }

    public PNS(PNS impl) {
        this._properties = new Properties(impl._properties);
        this._name = impl._name != null ? new String(impl._name) : null;
        this._initialized = impl._initialized;
    }

    public int attributeType(String objName, String attrName) throws IOException {
        String attr = this._properties.getProperty(attrName, null);
        if (attr == null) {
            throw new IOException("No such attribute.");
        }
        if (attr.charAt(0) == '#') {
            return 0;
        }
        if (attr.charAt(0) == '~') {
            return 1;
        }
        if (attr.charAt(0) == '^') {
            return 2;
        }
        if (attr.charAt(0) == '%') {
            return 3;
        }
        if (attr.charAt(0) == '-') {
            return 4;
        }
        if (attr.charAt(0) == '+') {
            return 5;
        }
        throw new IOException("Unknown attribute type.");
    }

    public synchronized String firstAttributeName(String objName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("No attributes.");
        }
        Enumeration<Object> keys = this._properties.keys();
        String firstAttr = (String)keys.nextElement();
        keys = null;
        return firstAttr;
    }

    public synchronized String nextAttributeName(String objName, String attrName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("No attributes.");
        }
        Enumeration<Object> keys = this._properties.keys();
        while (keys.hasMoreElements()) {
            String attr = (String)keys.nextElement();
            if (attr.compareTo(attrName) != 0 || !keys.hasMoreElements()) continue;
            attr = (String)keys.nextElement();
            keys = null;
            return attr;
        }
        throw new IOException("No more attributes.");
    }

    public long getLongAttribute(String objName, String attrName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("No attributes.");
        }
        String attr = this._properties.getProperty(attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '#') {
                try {
                    return Long.parseLong(new String(attr.substring(1)));
                }
                catch (NumberFormatException e) {
                    throw new IOException("Not a number.");
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("Not a number.");
                }
            }
            throw new IOException("Not a signed number.");
        }
        throw new IOException("No such attribute.");
    }

    public String getStringAttribute(String objName, String attrName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("No attributes.");
        }
        String attr = this._properties.getProperty(attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '^') {
                try {
                    return new String(attr.substring(1));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No string.");
                }
            }
            throw new IOException("Not a string.");
        }
        throw new IOException("No such attribute.");
    }

    public ObjectName getObjectNameAttribute(String objName, String attrName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("No attributes.");
        }
        String attr = this._properties.getProperty(attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '%') {
                try {
                    return new ObjectName(new String(attr.substring(1)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No ObjectName.");
                }
            }
            throw new IOException("Not an ObjectName.");
        }
        throw new IOException("No such attribute.");
    }

    public ClassName getClassNameAttribute(String objName, String attrName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("No attributes.");
        }
        String attr = this._properties.getProperty(attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '-') {
                try {
                    return new ClassName(new String(attr.substring(1)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No ClassName.");
                }
            }
            throw new IOException("Not a ClassName.");
        }
        throw new IOException("No such attribute.");
    }

    public Uid getUidAttribute(String objName, String attrName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("No attributes.");
        }
        String attr = this._properties.getProperty(attrName, null);
        if (attr != null) {
            if (attr.charAt(0) == '+') {
                try {
                    return new Uid(new String(attr.substring(1)));
                }
                catch (StringIndexOutOfBoundsException e) {
                    throw new IOException("No Uid.");
                }
            }
            throw new IOException("Not a Uid.");
        }
        throw new IOException("No such attribute.");
    }

    public String setLongAttribute(String objName, String attrName, long value) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (!this._properties.isEmpty() && this._properties.get(attrName) != null) {
            throw new IOException("Attribute " + attrName + " already present.");
        }
        Long l = new Long(value);
        String s = new String('#' + l.toString());
        this._properties.put(attrName, s);
        l = null;
        s = null;
        return this.saveState();
    }

    public String setStringAttribute(String objName, String attrName, String value) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (!this._properties.isEmpty() && this._properties.get(attrName) != null) {
            throw new IOException("Attribute " + attrName + " already present.");
        }
        String s = new String('^' + value);
        this._properties.put(attrName, s);
        s = null;
        return this.saveState();
    }

    public String setObjectNameAttribute(String objName, String attrName, ObjectName value) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (!this._properties.isEmpty() && this._properties.get(attrName) != null) {
            throw new IOException("Attribute " + attrName + " already present.");
        }
        String s = new String('%' + value.stringForm());
        this._properties.put(attrName, s);
        s = null;
        return this.saveState();
    }

    public String setClassNameAttribute(String objName, String attrName, ClassName value) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (!this._properties.isEmpty() && this._properties.get(attrName) != null) {
            throw new IOException("Attribute " + attrName + " already present.");
        }
        String s = new String('-' + value.stringForm());
        this._properties.put(attrName, s);
        s = null;
        return this.saveState();
    }

    public String setUidAttribute(String objName, String attrName, Uid value) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (!this._properties.isEmpty() && this._properties.get(attrName) != null) {
            throw new IOException("Attribute " + attrName + " already present.");
        }
        String s = new String('+' + value.stringForm());
        this._properties.put(attrName, s);
        s = null;
        return this.saveState();
    }

    public String removeAttribute(String objName, String attrName) throws IOException {
        if (!this._initialized) {
            this.loadState(objName);
        }
        if (this._properties.isEmpty()) {
            throw new IOException("Attribute " + attrName + " not present.");
        }
        this._properties.remove(attrName);
        return this.saveState();
    }

    public String uniqueAttributeName(String objName) throws IOException {
        Uid u = new Uid();
        return u.stringForm();
    }

    public ObjectName uniqueObjectName() throws IOException {
        Uid uid = new Uid();
        ObjectName uniqueName = new ObjectName(pnsName + uid.stringForm());
        return uniqueName;
    }

    public Object clone() {
        return new PNS(this);
    }

    public ClassName className() {
        return ArjunaNames.Implementation_NameService_PNS();
    }

    public static ClassName name() {
        return ArjunaNames.Implementation_NameService_PNS();
    }

    private void loadState(String objName) throws IOException {
        if (!this._initialized) {
            this._initialized = true;
            if (objName != null) {
                int namePoint = objName.indexOf(33);
                if (namePoint == -1) {
                    this._name = new String(objName);
                } else {
                    this._name = objName.substring(0, namePoint - 1);
                    String nameString = objName.substring(namePoint, objName.length());
                    DataInputStream input = new DataInputStream(new ByteArrayInputStream(nameString.getBytes()));
                    this._properties.load(input);
                    nameString = null;
                    input = null;
                }
            } else {
                this._name = "";
            }
        }
    }

    private String saveState() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(os);
        this._properties.store(output, null);
        output = null;
        return new String(this._name + '!' + os.toString());
    }
}

