/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.common.jcr;

import java.util.ArrayList;
import java.util.List;
import org.chromattic.common.jcr.Parser;
import org.chromattic.common.jcr.PathException;
import org.chromattic.common.jcr.PathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Path {
    private static final PathVisitor NAME_VALIDATOR = new PathVisitor(){

        public void onPathSegment(String s, int start, int end, Integer number) {
        }

        public void onPrefixPathSegment(String s, int prefixStart, int prefixEnd, int start, int end, Integer number) {
        }

        public void onURIPathSegment(String s, int uriStart, int uriEnd, int start, int end, Integer number) {
        }

        public void onSelf() throws PathException {
            throw new PathException();
        }

        public void onParent() throws PathException {
            throw new PathException();
        }
    };

    public static void parseAbsolutePath(String path, PathVisitor visitor) throws PathException {
        Parser.parseAbsolutePath(visitor, path, 0, path.length());
    }

    public static void parsePath(String path, PathVisitor visitor) throws PathException {
        Parser.parsePath(visitor, path, 0, path.length());
    }

    public static void parseRelativePath(PathVisitor visitor, String s) throws PathException {
        Parser.parseRelativePath(visitor, s, 0, s.length());
    }

    public static void parsePathSegment(String s, PathVisitor visitor) throws PathException {
        Parser.parsePathSegment(visitor, s, 0, s.length());
    }

    public static String normalizeAbsolutePath(String absolutePath) throws PathException {
        Normalizer normalizer = new Normalizer();
        Path.parseAbsolutePath(absolutePath, normalizer);
        return normalizer.builder.toString();
    }

    public static List<String> splitAbsolutePath(String absolutePath) throws PathException {
        Splitter splitter = new Splitter();
        Path.parseAbsolutePath(absolutePath, splitter);
        return splitter.pathSegments;
    }

    public static void validateName(String name) {
        try {
            Path.parsePathSegment(name, NAME_VALIDATOR);
        }
        catch (PathException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid name");
            iae.initCause(e);
            throw iae;
        }
    }

    private static class Splitter
    implements PathVisitor {
        private final List<String> pathSegments = new ArrayList<String>();

        private Splitter() {
        }

        public void onPathSegment(String s, int start, int end, Integer number) throws PathException {
            String pathSegment = s.substring(start, end);
            if (number != null) {
                pathSegment = pathSegment + "[" + number + "]";
            }
            this.pathSegments.add(pathSegment);
        }

        public void onPrefixPathSegment(String s, int prefixStart, int prefixEnd, int start, int end, Integer number) throws PathException {
            String pathSegment = s.substring(prefixStart, prefixEnd) + ":" + s.substring(start, end);
            if (number != null) {
                pathSegment = pathSegment + "[" + number + "]";
            }
            this.pathSegments.add(pathSegment);
        }

        public void onURIPathSegment(String s, int uriStart, int uriEnd, int start, int end, Integer number) throws PathException {
            String pathSegment = "{" + s.substring(uriStart, uriEnd) + "}" + s.substring(start, end);
            if (number != null) {
                pathSegment = pathSegment + "[" + number + "]";
            }
            this.pathSegments.add(pathSegment);
        }

        public void onSelf() throws PathException {
        }

        public void onParent() throws PathException {
            if (this.pathSegments.isEmpty()) {
                throw new PathException("Invalid absolute path");
            }
            this.pathSegments.remove(this.pathSegments.size() - 1);
        }
    }

    private static class Normalizer
    implements PathVisitor {
        private final StringBuilder builder = new StringBuilder("/");

        private Normalizer() {
        }

        public void onPathSegment(String s, int start, int end, Integer number) throws PathException {
            if (this.builder.length() > 1) {
                this.builder.append('/');
            }
            this.builder.append(s, start, end);
            if (number != null) {
                this.builder.append('[');
                this.builder.append(number);
                this.builder.append(']');
            }
        }

        public void onPrefixPathSegment(String s, int prefixStart, int prefixEnd, int start, int end, Integer number) throws PathException {
            if (this.builder.length() > 1) {
                this.builder.append('/');
            }
            this.builder.append(s, prefixStart, prefixEnd);
            this.builder.append(':');
            this.builder.append(s, start, end);
            if (number != null) {
                this.builder.append('[');
                this.builder.append(number);
                this.builder.append(']');
            }
            this.builder.append('/');
        }

        public void onURIPathSegment(String s, int uriStart, int uriEnd, int start, int end, Integer number) throws PathException {
            if (this.builder.length() > 1) {
                this.builder.append('/');
            }
            this.builder.append('{');
            this.builder.append(s, uriStart, uriEnd);
            this.builder.append('}');
            this.builder.append(s, start, end);
            if (number != null) {
                this.builder.append('[');
                this.builder.append(number);
                this.builder.append(']');
            }
            this.builder.append('/');
        }

        public void onSelf() throws PathException {
        }

        public void onParent() throws PathException {
            if (this.builder.length() == 1) {
                throw new PathException("Invalid absolute path");
            }
            int pos = this.builder.lastIndexOf("/");
            if (pos == 0) {
                this.builder.setLength(1);
            } else {
                this.builder.setLength(pos);
            }
        }
    }
}

