/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.authc.credential;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.authc.AuthenticationInfo;
import org.jsecurity.authc.AuthenticationToken;
import org.jsecurity.authc.credential.CredentialsMatcher;
import org.jsecurity.codec.CodecSupport;

public class SimpleCredentialsMatcher
extends CodecSupport
implements CredentialsMatcher {
    private static final Log log = LogFactory.getLog(SimpleCredentialsMatcher.class);

    protected Object getCredentials(AuthenticationToken token) {
        return token.getCredentials();
    }

    protected Object getCredentials(AuthenticationInfo info) {
        return info.getCredentials();
    }

    protected boolean equals(Object tokenCredentials, Object accountCredentials) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Performing credentials equality check for tokenCredentials of type [" + tokenCredentials.getClass().getName() + " and accountCredentials of type [" + accountCredentials.getClass().getName() + "]"));
        }
        if ((tokenCredentials instanceof byte[] || tokenCredentials instanceof char[] || tokenCredentials instanceof String) && (accountCredentials instanceof byte[] || accountCredentials instanceof char[] || accountCredentials instanceof String)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Both credentials arguments can be easily converted to byte arrays.  Performing array equals comparison");
            }
            byte[] tokenBytes = this.toBytes(tokenCredentials);
            byte[] accountBytes = this.toBytes(accountCredentials);
            return Arrays.equals(tokenBytes, accountBytes);
        }
        return accountCredentials.equals(tokenCredentials);
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        Object tokenCredentials = this.getCredentials(token);
        Object accountCredentials = this.getCredentials(info);
        return this.equals(tokenCredentials, accountCredentials);
    }
}

