/*
 * Decompiled with CFR 0.152.
 */
package org.jsecurity.web;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsecurity.codec.Base64;
import org.jsecurity.subject.AbstractRememberMeManager;
import org.jsecurity.web.WebUtils;
import org.jsecurity.web.attr.CookieAttribute;
import org.jsecurity.web.attr.WebAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebRememberMeManager
extends AbstractRememberMeManager {
    private static final transient Log log = LogFactory.getLog(WebRememberMeManager.class);
    public static final String DEFAULT_REMEMBER_ME_COOKIE_NAME = "rememberMe";
    protected WebAttribute<String> identityAttribute = null;

    public WebRememberMeManager() {
        CookieAttribute<String> attr = new CookieAttribute<String>(DEFAULT_REMEMBER_ME_COOKIE_NAME);
        attr.setCheckRequestParams(false);
        attr.setMaxAge(94608000);
        this.identityAttribute = attr;
    }

    public WebAttribute<String> getIdentityAttribute() {
        return this.identityAttribute;
    }

    public void setIdentityAttribute(WebAttribute<String> identityAttribute) {
        this.identityAttribute = identityAttribute;
    }

    protected void assertCookieAttribute() {
        if (!(this.identityAttribute instanceof CookieAttribute)) {
            String msg = "Attempting to access a Cookie property, but the underlying " + WebAttribute.class.getName() + " instance is not a " + CookieAttribute.class.getName() + " instance.  This is expected if you " + "are accessing or modifying a cookie property.";
            throw new IllegalStateException(msg);
        }
    }

    public String getCookieName() {
        this.assertCookieAttribute();
        return ((CookieAttribute)this.identityAttribute).getName();
    }

    public void setCookieName(String name) {
        this.assertCookieAttribute();
        ((CookieAttribute)this.identityAttribute).setName(name);
    }

    public String getCookiePath() {
        this.assertCookieAttribute();
        return ((CookieAttribute)this.identityAttribute).getPath();
    }

    public void setCookiePath(String path) {
        this.assertCookieAttribute();
        ((CookieAttribute)this.identityAttribute).setPath(path);
    }

    public int getCookieMaxAge() {
        this.assertCookieAttribute();
        return ((CookieAttribute)this.identityAttribute).getMaxAge();
    }

    public void setCookieMaxAge(int maxAge) {
        this.assertCookieAttribute();
        ((CookieAttribute)this.identityAttribute).setMaxAge(maxAge);
    }

    public boolean isCookieSecure() {
        this.assertCookieAttribute();
        return ((CookieAttribute)this.identityAttribute).isSecure();
    }

    public void setCookieSecure(boolean secure) {
        this.assertCookieAttribute();
        ((CookieAttribute)this.identityAttribute).setSecure(secure);
    }

    @Override
    protected void rememberSerializedIdentity(byte[] serialized) {
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        String base64 = Base64.encodeToString(serialized);
        this.getIdentityAttribute().storeValue(base64, request, response);
    }

    @Override
    protected byte[] getSerializedRememberedIdentity() {
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        String base64 = this.getIdentityAttribute().retrieveValue(request, response);
        if (base64 != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Acquired Base64 encoded identity [" + base64 + "]"));
            }
            byte[] decoded = Base64.decode(base64);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Base64 decoded byte array length: " + (decoded != null ? decoded.length : 0) + " bytes."));
            }
            return decoded;
        }
        return null;
    }

    @Override
    protected void forgetIdentity() {
        ServletRequest request = WebUtils.getRequiredServletRequest();
        ServletResponse response = WebUtils.getRequiredServletResponse();
        this.getIdentityAttribute().removeValue(request, response);
    }
}

