/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.InvalidationService;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.rewrite.image.ImageRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultRequestPipeline
implements RequestPipeline {
    private final HttpFetcher httpFetcher;
    private final HttpCache httpCache;
    private final Provider<OAuthRequest> oauthRequestProvider;
    private final ImageRewriter imageRewriter;
    private final InvalidationService invalidationService;

    @Inject
    public DefaultRequestPipeline(HttpFetcher httpFetcher, HttpCache httpCache, Provider<OAuthRequest> oauthRequestProvider, ImageRewriter imageRewriter, InvalidationService invalidationService) {
        this.httpFetcher = httpFetcher;
        this.httpCache = httpCache;
        this.oauthRequestProvider = oauthRequestProvider;
        this.imageRewriter = imageRewriter;
        this.invalidationService = invalidationService;
    }

    @Override
    public HttpResponse execute(HttpRequest request) throws GadgetException {
        HttpResponse cachedResponse;
        this.normalizeProtocol(request);
        HttpResponse invalidatedResponse = null;
        if (!request.getIgnoreCache() && (cachedResponse = this.httpCache.getResponse(request)) != null && !cachedResponse.isStale()) {
            if (this.invalidationService.isValid(request, cachedResponse)) {
                return cachedResponse;
            }
            invalidatedResponse = cachedResponse;
        }
        HttpResponse fetchedResponse = null;
        switch (request.getAuthType()) {
            case NONE: {
                fetchedResponse = this.httpFetcher.fetch(request);
                break;
            }
            case SIGNED: 
            case OAUTH: {
                fetchedResponse = ((OAuthRequest)this.oauthRequestProvider.get()).fetch(request);
                break;
            }
            default: {
                return HttpResponse.error();
            }
        }
        if (fetchedResponse.isError() && invalidatedResponse != null) {
            return invalidatedResponse;
        }
        if (!fetchedResponse.isError() && !request.getIgnoreCache() && request.getCacheTtl() != 0) {
            fetchedResponse = this.imageRewriter.rewrite(request, fetchedResponse);
        }
        if (!request.getIgnoreCache()) {
            if (fetchedResponse.getCacheTtl() > 0L) {
                fetchedResponse = this.invalidationService.markResponse(request, fetchedResponse);
            }
            this.httpCache.addResponse(request, fetchedResponse);
        }
        return fetchedResponse;
    }

    @Override
    public void normalizeProtocol(HttpRequest request) throws GadgetException {
        if (request.getUri().getScheme() == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Url " + request.getUri().toString() + " does not include scheme");
        }
        if (!"http".equals(request.getUri().getScheme()) && !"https".equals(request.getUri().getScheme())) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid request url scheme in url: " + Utf8UrlCoder.encode((String)request.getUri().toString()) + "; only \"http\" and \"https\" supported.");
        }
    }
}

