/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.web;

import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;

public abstract class AbstractFilter
implements Filter {
    protected FilterConfig config;
    protected String servletContextName;
    private volatile Boolean requirePortalEnvironment;

    public final void init(FilterConfig config) throws ServletException {
        this.config = config;
        this.servletContextName = config.getServletContext().getServletContextName();
        this.afterInit(config);
    }

    protected void afterInit(FilterConfig config) throws ServletException {
    }

    protected final ExoContainer getContainer() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer && (container = PortalContainer.getCurrentInstance(this.config.getServletContext())) == null) {
            container = ExoContainerContext.getTopContainer();
        }
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean requirePortalEnvironment() {
        if (this.requirePortalEnvironment == null) {
            AbstractFilter abstractFilter = this;
            synchronized (abstractFilter) {
                if (this.requirePortalEnvironment == null) {
                    this.requirePortalEnvironment = PortalContainer.isPortalContainerName(this.servletContextName);
                }
            }
        }
        return this.requirePortalEnvironment;
    }

    protected ServletContext getServletContext() {
        ExoContainer container;
        if (this.requirePortalEnvironment() && (container = this.getContainer()) instanceof PortalContainer) {
            return ((PortalContainer)container).getPortalContext();
        }
        return this.config.getServletContext();
    }
}

