/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.jmx.impl;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.impl.JMX;
import org.exoplatform.management.jmx.impl.MBeanScopingData;
import org.exoplatform.management.jmx.impl.PropertiesInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectNameBuilder<T> {
    private String domain;
    private Class<? extends T> clazz;

    public ObjectNameBuilder(String domain, Class<? extends T> clazz) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("Clazz cannot be null");
        }
        this.domain = domain;
        this.clazz = clazz;
    }

    public ObjectName build(T object) throws IllegalStateException {
        PropertiesInfo info = PropertiesInfo.resolve(this.clazz, NameTemplate.class);
        if (info != null) {
            try {
                MBeanScopingData props = info.resolve(object);
                return JMX.createObjectName(this.domain, props);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("ObjectName template is malformed", e);
            }
        }
        return null;
    }
}

