/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ComponentPersister;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.util.NodeDataReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDataPersister
implements ComponentPersister {
    public static Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.NamespaceDataPersister");
    private final DataManager dataManager;
    private NodeData nsRoot;
    private final RepositoryEntry repConfig;
    private boolean started = false;

    public NamespaceDataPersister(DataManager dataManager, RepositoryEntry repConfig) throws RepositoryException {
        this.dataManager = dataManager;
        this.repConfig = repConfig;
    }

    public void addNamespace(String prefix, String uri) throws RepositoryException {
        if (!this.started) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable save namespace " + uri + "=" + prefix + " in to the storage. Storage not initialized"));
            }
            return;
        }
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        this.internallAdd(changesLog, prefix, uri);
        this.dataManager.save(new TransactionChangesLog(changesLog));
    }

    private PlainChangesLog internallAdd(PlainChangesLog changesLog, String prefix, String uri) {
        TransientNodeData nsNode = TransientNodeData.createNodeData(this.nsRoot, new InternalQName("", prefix), Constants.EXO_NAMESPACE);
        TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)nsNode, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(nsNode.getPrimaryTypeName()));
        TransientPropertyData exoUri = TransientPropertyData.createPropertyData((NodeData)nsNode, Constants.EXO_URI_NAME, 1, false, new TransientValueData(uri));
        TransientPropertyData exoPrefix = TransientPropertyData.createPropertyData((NodeData)nsNode, Constants.EXO_PREFIX, 1, false, new TransientValueData(prefix));
        changesLog.add(ItemState.createAddedState(nsNode)).add(ItemState.createAddedState(primaryType)).add(ItemState.createAddedState(exoUri)).add(ItemState.createAddedState(exoPrefix));
        return changesLog;
    }

    public void addNamespaces(Map<String, String> namespaceMap) throws RepositoryException {
        if (!this.started) {
            log.warn((Object)"Unable save namespaces in to the storage. Storage not initialized");
            return;
        }
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        for (Map.Entry<String, String> entry : namespaceMap.entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            if (prefix == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Namespace " + uri + ":" + prefix));
            }
            this.internallAdd(changesLog, prefix, uri);
        }
        this.dataManager.save(new TransactionChangesLog(changesLog));
    }

    @Override
    public boolean isStorageFilled() {
        try {
            List<NodeData> storageContent = this.dataManager.getChildNodesData(this.nsRoot);
            return storageContent.size() > 0;
        }
        catch (RepositoryException e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void removeNamespace(String prefix) throws RepositoryException {
        if (!this.started) {
            log.warn((Object)("Unable remove namspace " + prefix + " from the storage. Storage not initialized"));
            return;
        }
        PlainChangesLogImpl plainChangesLogImpl = new PlainChangesLogImpl();
        ItemData prefData = this.dataManager.getItemData(this.nsRoot, new QPathEntry(new InternalQName("", prefix), 0));
        if (prefData != null && prefData.isNode()) {
            List<PropertyData> childs = this.dataManager.getChildPropertiesData((NodeData)prefData);
            for (PropertyData propertyData : childs) {
                plainChangesLogImpl.add(ItemState.createDeletedState(this.copyPropertyData(propertyData), true));
            }
            prefData = new TransientNodeData(prefData.getQPath(), prefData.getIdentifier(), prefData.getPersistedVersion(), ((NodeData)prefData).getPrimaryTypeName(), ((NodeData)prefData).getMixinTypeNames(), ((NodeData)prefData).getOrderNumber(), ((NodeData)prefData).getParentIdentifier(), ((NodeData)prefData).getACL());
            plainChangesLogImpl.add(ItemState.createDeletedState(prefData, true));
        }
        this.dataManager.save(new TransactionChangesLog(plainChangesLogImpl));
    }

    public void start() {
        if (!this.started) {
            block6: {
                try {
                    NodeData jcrSystem = (NodeData)this.dataManager.getItemData("00exo0jcr0system0uuid00000000000");
                    if (jcrSystem != null) {
                        NodeData exoNamespaces = (NodeData)this.dataManager.getItemData(jcrSystem, new QPathEntry(Constants.EXO_NAMESPACES, 1));
                        if (exoNamespaces == null) {
                            this.initStorage(jcrSystem, !this.repConfig.getAccessControl().equals("disable"));
                            this.nsRoot = (NodeData)this.dataManager.getItemData(jcrSystem, new QPathEntry(Constants.EXO_NAMESPACES, 1));
                        } else {
                            this.nsRoot = exoNamespaces;
                        }
                        break block6;
                    }
                    throw new RepositoryException("Nodetypes storage (/jcr:systemnode) is not initialized.");
                }
                catch (RepositoryException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
            }
            this.started = true;
        }
    }

    public void stop() {
    }

    @Deprecated
    DataManager getDataManager() {
        return this.dataManager;
    }

    void loadNamespaces(Map<String, String> namespacesMap, Map<String, String> urisMap) throws RepositoryException {
        if (!this.isInialized()) {
            NodeData jcrSystem = (NodeData)this.dataManager.getItemData("00exo0jcr0system0uuid00000000000");
            if (jcrSystem != null) {
                this.nsRoot = (NodeData)this.dataManager.getItemData(jcrSystem, new QPathEntry(Constants.EXO_NAMESPACES, 1));
            } else {
                throw new RepositoryException("/jcr:system is not found. Possible the workspace is not initialized properly");
            }
        }
        if (this.isInialized()) {
            NodeDataReader nsReader = new NodeDataReader(this.nsRoot, this.dataManager);
            nsReader.setRememberSkiped(true);
            nsReader.forNodesByType(Constants.EXO_NAMESPACE);
            nsReader.read();
            List<NodeDataReader> nsData = nsReader.getNodesByType(Constants.EXO_NAMESPACE);
            for (NodeDataReader nsr : nsData) {
                nsr.forProperty(Constants.EXO_URI_NAME, 1).forProperty(Constants.EXO_PREFIX, 1);
                nsr.read();
                try {
                    String exoUri = ValueDataConvertor.readString(nsr.getPropertyValue(Constants.EXO_URI_NAME));
                    String exoPrefix = ValueDataConvertor.readString(nsr.getPropertyValue(Constants.EXO_PREFIX));
                    namespacesMap.put(exoPrefix, exoUri);
                    urisMap.put(exoUri, exoPrefix);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Namespace " + exoPrefix + " is loaded"));
                }
                catch (IOException e) {
                    throw new RepositoryException("Namespace load error " + e, (Throwable)e);
                }
            }
            for (NodeData skipedNs : nsReader.getSkiped()) {
                log.warn((Object)("Namespace node " + skipedNs.getQPath().getName().getAsString() + " (primary type '" + skipedNs.getPrimaryTypeName().getAsString() + "') is not supported for loading. Nodes with 'exo:namespace' node type is supported only now."));
            }
        } else {
            log.warn((Object)"Namespace storage (/jcr:system/exo:namespaces node) is not initialized. No namespaces loaded.");
        }
    }

    private TransientItemData copyPropertyData(PropertyData prop) throws RepositoryException {
        if (prop == null) {
            return null;
        }
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued(), prop.getValues());
        return newData;
    }

    private void initStorage(NodeData nsSystem, boolean addACL) throws RepositoryException {
        TransientNodeData exoNamespaces;
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        if (addACL) {
            AccessControlList acl = new AccessControlList();
            InternalQName[] mixins = new InternalQName[]{Constants.EXO_OWNEABLE, Constants.EXO_PRIVILEGEABLE};
            exoNamespaces = TransientNodeData.createNodeData(nsSystem, Constants.EXO_NAMESPACES, Constants.NT_UNSTRUCTURED, mixins);
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(exoNamespaces.getPrimaryTypeName()));
            changesLog.add(ItemState.createAddedState(exoNamespaces)).add(ItemState.createAddedState(primaryType));
            ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
            for (InternalQName mixin : mixins) {
                mixValues.add(new TransientValueData(mixin));
            }
            TransientPropertyData exoMixinTypes = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.JCR_MIXINTYPES, 7, true, mixValues);
            TransientPropertyData exoOwner = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.EXO_OWNER, 1, false, new TransientValueData(acl.getOwner()));
            ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
            for (int i = 0; i < acl.getPermissionEntries().size(); ++i) {
                AccessControlEntry entry = acl.getPermissionEntries().get(i);
                permsValues.add(new TransientValueData(entry));
            }
            TransientPropertyData exoPerms = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.EXO_PERMISSIONS, 100, true, permsValues);
            changesLog.add(ItemState.createAddedState(exoMixinTypes)).add(ItemState.createAddedState(exoOwner)).add(ItemState.createAddedState(exoPerms));
            changesLog.add(new ItemState(exoNamespaces, 16, false, null));
        } else {
            exoNamespaces = TransientNodeData.createNodeData(nsSystem, Constants.EXO_NAMESPACES, Constants.NT_UNSTRUCTURED);
            TransientPropertyData primaryType = TransientPropertyData.createPropertyData((NodeData)exoNamespaces, Constants.JCR_PRIMARYTYPE, 7, false, new TransientValueData(exoNamespaces.getPrimaryTypeName()));
            changesLog.add(ItemState.createAddedState(exoNamespaces)).add(ItemState.createAddedState(primaryType));
        }
        this.nsRoot = exoNamespaces;
        this.dataManager.save(new TransactionChangesLog(changesLog));
    }

    private boolean isInialized() {
        return this.nsRoot != null;
    }
}

