/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.ChangesLogIterator;
import org.exoplatform.services.jcr.dataflow.CompositeChangesLog;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.dataflow.TransactionChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.lock.LockRemover;
import org.exoplatform.services.jcr.impl.core.lock.SessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheableLockManager;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.CacheableSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.ControllerCacheLoader;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.LockData;
import org.exoplatform.services.jcr.impl.dataflow.TransientItemData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.storage.JCRInvalidItemStateException;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.transaction.TransactionService;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="lockmanager")})
public class CacheableLockManagerImpl
implements CacheableLockManager,
ItemsPersistenceListener,
Startable {
    public static final String TIME_OUT = "time-out";
    public static final String JBOSSCACCHE_CONFIG = "jbosscache-configuration";
    public static final String JBOSSCACHE_JDBC_CL_DATASOURCE = "jbosscache-cl-cache.jdbc.datasource";
    public static final String JBOSSCACHE_JDBC_CL_NODE_COLUMN = "jbosscache-cl-cache.jdbc.node.type";
    public static final String JBOSSCACHE_JDBC_CL_FQN_COLUMN = "jbosscache-cl-cache.jdbc.fqn.type";
    public static final String JBOSSCACHE_JDBC_CL_AUTO = "auto";
    public static final long DEFAULT_LOCK_TIMEOUT = 1800000L;
    public static final String LOCKS = "$LOCKS";
    public static final String LOCK_DATA = "$LOCK_DATA";
    private final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CacheableLockManagerImpl");
    private final DataManager dataManager;
    private long lockTimeOut;
    private LockRemover lockRemover;
    private TransactionManager tm;
    private Cache<Serializable, Object> cache;
    private final Fqn<String> lockRoot;
    private Map<String, CacheableSessionLockManager> sessionLockManagers;
    private final LockActionNonTxAware<Integer, Object> getNumLocks = new LockActionNonTxAware<Integer, Object>(){

        @Override
        public Integer execute(Object arg) {
            return ((CacheSPI)CacheableLockManagerImpl.this.cache).getNumberOfNodes() - 1;
        }
    };
    private final LockActionNonTxAware<Boolean, Object> hasLocks = new LockActionNonTxAware<Boolean, Object>(){

        @Override
        public Boolean execute(Object arg) {
            return ((CacheSPI)CacheableLockManagerImpl.this.cache).getNode(CacheableLockManagerImpl.this.lockRoot).hasChildrenDirect();
        }
    };
    private final LockActionNonTxAware<Boolean, String> isLockLive = new LockActionNonTxAware<Boolean, String>(){

        @Override
        public Boolean execute(String nodeId) {
            if (CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn(nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA) != null) {
                return true;
            }
            return false;
        }
    };
    private final LockActionNonTxAware<Object, LockData> refresh = new LockActionNonTxAware<Object, LockData>(){

        @Override
        public Object execute(LockData newLockData) throws LockException {
            Fqn fqn = CacheableLockManagerImpl.this.makeLockFqn(newLockData.getNodeIdentifier());
            Object oldValue = CacheableLockManagerImpl.this.cache.put(fqn, (Object)CacheableLockManagerImpl.LOCK_DATA, (Object)newLockData);
            if (oldValue == null) {
                throw new LockException("Can't refresh lock for node " + newLockData.getNodeIdentifier() + " since lock is not exist");
            }
            return null;
        }
    };
    private final LockActionNonTxAware<Boolean, String> lockExist = new LockActionNonTxAware<Boolean, String>(){

        @Override
        public Boolean execute(String nodeId) throws LockException {
            return CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn(nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA) != null;
        }
    };
    private final LockActionNonTxAware<LockData, String> getLockDataById = new LockActionNonTxAware<LockData, String>(){

        @Override
        public LockData execute(String nodeId) throws LockException {
            return (LockData)CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn(nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA);
        }
    };
    private final LockActionNonTxAware<List<LockData>, Object> getLockList = new LockActionNonTxAware<List<LockData>, Object>(){

        @Override
        public List<LockData> execute(Object arg) throws LockException {
            Set nodesId = CacheableLockManagerImpl.this.cache.getChildrenNames(CacheableLockManagerImpl.this.lockRoot);
            ArrayList<LockData> locksData = new ArrayList<LockData>();
            for (Object nodeId : nodesId) {
                LockData lockData = (LockData)CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn((String)nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA);
                if (lockData == null) continue;
                locksData.add(lockData);
            }
            return locksData;
        }
    };

    public CacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionService transactionService, ConfigurationManager cfm) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, transactionService.getTransactionManager(), cfm);
    }

    public CacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, ConfigurationManager cfm) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, (TransactionManager)null, cfm);
    }

    public CacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionManager transactionManager, ConfigurationManager cfm) throws RepositoryConfigurationException, RepositoryException {
        long timeOut;
        this.lockRoot = Fqn.fromElements((Object[])new String[]{LOCKS});
        List<SimpleParameterEntry> paramenerts = config.getLockManager().getParameters();
        this.dataManager = dataManager;
        this.lockTimeOut = config.getLockManager() != null ? (paramenerts != null && config.getLockManager().getParameterValue(TIME_OUT, null) != null ? ((timeOut = config.getLockManager().getParameterTime(TIME_OUT).longValue()) > 0L ? timeOut : 1800000L) : (config.getLockManager().getTimeout() > 0L ? config.getLockManager().getTimeout() : 1800000L)) : 1800000L;
        this.sessionLockManagers = new ConcurrentHashMap<String, CacheableSessionLockManager>();
        dataManager.addItemPersistenceListener(this);
        if (config.getLockManager() == null) {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        this.tm = transactionManager;
        ExoJBossCacheFactory factory = new ExoJBossCacheFactory(cfm, transactionManager);
        this.configureJDBCCacheLoader(config.getLockManager());
        this.cache = factory.createCache(config.getLockManager());
        this.cache.create();
        this.addCacheLoader();
        this.cache.start();
        this.createStructuredNode(this.lockRoot);
        context.recall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureJDBCCacheLoader(MappedParametrizedObjectEntry parameterEntry) throws RepositoryException {
        String dataSourceName = parameterEntry.getParameterValue(JBOSSCACHE_JDBC_CL_DATASOURCE, null);
        if (dataSourceName != null) {
            String dialect;
            block26: {
                try {
                    DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
                    if (dataSource == null) {
                        throw new RepositoryException("DataSource (" + dataSourceName + ") can't be null");
                    }
                    Connection jdbcConn = null;
                    try {
                        jdbcConn = dataSource.getConnection();
                        dialect = DialectDetecter.detect(jdbcConn.getMetaData());
                        Object var7_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (jdbcConn != null && !jdbcConn.isClosed()) {
                            try {
                                jdbcConn.close();
                            }
                            catch (SQLException e) {
                                throw new RepositoryException("Error of connection close", (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (jdbcConn == null || jdbcConn.isClosed()) break block26;
                    try {
                        jdbcConn.close();
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Error of connection close", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new RepositoryException("Error configuring JDBC cache loader", (Throwable)e);
                }
            }
            String blobType = "BLOB";
            String charType = "VARCHAR(512)";
            if (dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
                blobType = "OBJECT";
            } else if (dialect.equals(DBConstants.DB_DIALECT_MYSQL) || dialect.equals(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
                blobType = "LONGBLOB";
            } else if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
                charType = "VARCHAR2(512)";
            } else if (dialect.equals(DBConstants.DB_DIALECT_PGSQL)) {
                blobType = "bytea";
            } else if (dialect.equals(DBConstants.DB_DIALECT_MSSQL)) {
                blobType = "VARBINARY(MAX)";
            } else if (dialect.equals(DBConstants.DB_DIALECT_SYBASE)) {
                blobType = "IMAGE";
            } else if (dialect.equals(DBConstants.DB_DIALECT_INGRES)) {
                blobType = "long byte";
            }
            if (parameterEntry.getParameterValue(JBOSSCACHE_JDBC_CL_NODE_COLUMN, JBOSSCACHE_JDBC_CL_AUTO).equalsIgnoreCase(JBOSSCACHE_JDBC_CL_AUTO)) {
                parameterEntry.putParameterValue(JBOSSCACHE_JDBC_CL_NODE_COLUMN, blobType);
            }
            if (parameterEntry.getParameterValue(JBOSSCACHE_JDBC_CL_FQN_COLUMN, JBOSSCACHE_JDBC_CL_AUTO).equalsIgnoreCase(JBOSSCACHE_JDBC_CL_AUTO)) {
                parameterEntry.putParameterValue(JBOSSCACHE_JDBC_CL_FQN_COLUMN, charType);
            }
        } else {
            this.LOG.warn((Object)"CacheLoader DataSource jbosscache-cl-cache.jdbc.datasource is not configured.");
        }
    }

    private void addCacheLoader() {
        List oldConfigs;
        CacheLoaderConfig config = this.cache.getConfiguration().getCacheLoaderConfig();
        if (config == null || (oldConfigs = config.getIndividualCacheLoaderConfigs()) == null || oldConfigs.isEmpty()) {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"No cache loader has been defined, thus no need to encapsulate any cache loader.");
            }
            return;
        }
        CacheLoaderManager clm = (CacheLoaderManager)((CacheSPI)this.cache).getComponentRegistry().getComponent(CacheLoaderManager.class);
        if (clm == null) {
            this.LOG.error((Object)"The CacheLoaderManager cannot be found");
            return;
        }
        CacheLoader currentCL = clm.getCacheLoader();
        if (currentCL == null) {
            this.LOG.error((Object)"The CacheLoader cannot be found");
            return;
        }
        ControllerCacheLoader ccl = new ControllerCacheLoader(currentCL);
        ArrayList<CacheLoaderConfig.IndividualCacheLoaderConfig> newConfig = new ArrayList<CacheLoaderConfig.IndividualCacheLoaderConfig>(1);
        CacheLoaderConfig.IndividualCacheLoaderConfig cclConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        cclConfig.setCacheLoader((CacheLoader)ccl);
        cclConfig.setFetchPersistentState(clm.isFetchPersistentState());
        cclConfig.setAsync(false);
        cclConfig.setIgnoreModifications(false);
        CacheLoaderConfig.IndividualCacheLoaderConfig first = config.getFirstCacheLoaderConfig();
        cclConfig.setPurgeOnStartup(first != null && first.isPurgeOnStartup());
        newConfig.add(cclConfig);
        config.setIndividualCacheLoaderConfigs(newConfig);
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)"The configured cache loader has been encapsulated successfully");
        }
    }

    @Managed
    @ManagedDescription(value="Remove the expired locks")
    public void cleanExpiredLocks() {
        this.removeExpired();
    }

    @Override
    public long getDefaultLockTimeOut() {
        return this.lockTimeOut;
    }

    @Managed
    @ManagedDescription(value="The number of active locks")
    public int getNumLocks() {
        try {
            return this.executeLockActionNonTxAware(this.getNumLocks, null);
        }
        catch (LockException lockException) {
            return -1;
        }
    }

    private boolean hasLocks() {
        try {
            return this.executeLockActionNonTxAware(this.hasLocks, null);
        }
        catch (LockException lockException) {
            return true;
        }
    }

    @Override
    public SessionLockManager getSessionLockManager(String sessionId, SessionDataManager transientManager) {
        CacheableSessionLockManager sessionManager = new CacheableSessionLockManager(sessionId, this, transientManager);
        this.sessionLockManagers.put(sessionId, sessionManager);
        return sessionManager;
    }

    @Override
    public boolean isLockLive(String nodeId) throws LockException {
        try {
            return this.executeLockActionNonTxAware(this.isLockLive, nodeId);
        }
        catch (LockException lockException) {
            return false;
        }
    }

    @Override
    public boolean isTXAware() {
        return true;
    }

    @Override
    public void onSaveItems(ItemStateChangesLog changesLog) {
        ArrayList<PlainChangesLog> chengesLogList = new ArrayList<PlainChangesLog>();
        if (changesLog instanceof TransactionChangesLog) {
            ChangesLogIterator logIterator = ((TransactionChangesLog)changesLog).getLogIterator();
            while (logIterator.hasNextLog()) {
                chengesLogList.add(logIterator.nextLog());
            }
        } else if (changesLog instanceof PlainChangesLog) {
            chengesLogList.add((PlainChangesLog)changesLog);
        } else if (changesLog instanceof CompositeChangesLog) {
            ChangesLogIterator iter = ((CompositeChangesLog)changesLog).getLogIterator();
            while (iter.hasNextLog()) {
                chengesLogList.add(iter.nextLog());
            }
        }
        ArrayList<LockOperationContainer> containers = new ArrayList<LockOperationContainer>();
        block10: for (PlainChangesLog currChangesLog : chengesLogList) {
            String sessionId = currChangesLog.getSessionId();
            try {
                switch (currChangesLog.getEventType()) {
                    case 0x400000: {
                        if (currChangesLog.getSize() < 2) {
                            this.LOG.error((Object)("Incorrect changes log  of type ExtendedEvent.LOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        String nodeIdentifier = currChangesLog.getAllStates().get(0).getData().getParentIdentifier();
                        CacheableSessionLockManager session = this.sessionLockManagers.get(sessionId);
                        if (session != null && session.containsPendingLock(nodeIdentifier)) {
                            containers.add(new LockOperationContainer(nodeIdentifier, currChangesLog.getSessionId(), 0x400000));
                            break;
                        }
                        this.LOG.error((Object)"Lock must exist in pending locks.");
                        break;
                    }
                    case 0x800000: {
                        if (currChangesLog.getSize() < 2) {
                            this.LOG.error((Object)("Incorrect changes log  of type ExtendedEvent.UNLOCK size=" + currChangesLog.getSize() + "<2 \n" + currChangesLog.dump()));
                            break;
                        }
                        containers.add(new LockOperationContainer(currChangesLog.getAllStates().get(0).getData().getParentIdentifier(), currChangesLog.getSessionId(), 0x800000));
                        break;
                    }
                    default: {
                        String nodeIdentifier;
                        HashSet<String> removedLock = new HashSet<String>();
                        for (ItemState itemState : currChangesLog.getAllStates()) {
                            if (!itemState.getData().isNode() || !this.lockExist(itemState.getData().getIdentifier())) continue;
                            nodeIdentifier = itemState.getData().getIdentifier();
                            if (itemState.isDeleted()) {
                                removedLock.add(nodeIdentifier);
                                continue;
                            }
                            if (!itemState.isAdded() && !itemState.isRenamed() && !itemState.isUpdated()) continue;
                            removedLock.remove(nodeIdentifier);
                        }
                        for (String identifier : removedLock) {
                            containers.add(new LockOperationContainer(identifier, currChangesLog.getSessionId(), 0x800000));
                        }
                        continue block10;
                    }
                }
            }
            catch (IllegalStateException e) {
                this.LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        Collections.sort(containers);
        for (LockOperationContainer container : containers) {
            try {
                container.apply();
            }
            catch (LockException e) {
                this.LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void refreshLockData(LockData newLockData) throws LockException {
        this.executeLockActionNonTxAware(this.refresh, newLockData);
    }

    @Override
    public synchronized void removeExpired() {
        ArrayList<String> removeLockList = new ArrayList<String>();
        for (LockData lock : this.getLockList()) {
            if (lock.isSessionScoped() || lock.getTimeToDeath() >= 0L) continue;
            removeLockList.add(lock.getNodeIdentifier());
        }
        Collections.sort(removeLockList);
        for (String rLock : removeLockList) {
            this.removeLock(rLock);
        }
    }

    public void start() {
        this.lockRemover = new LockRemover(this);
    }

    public void stop() {
        this.lockRemover.halt();
        this.lockRemover.interrupt();
        this.sessionLockManagers.clear();
        this.cache.stop();
    }

    private TransientItemData copyItemData(PropertyData prop) throws RepositoryException {
        if (prop == null) {
            return null;
        }
        TransientPropertyData newData = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued(), prop.getValues());
        return newData;
    }

    private synchronized void internalLock(String sessionId, String nodeIdentifier) throws LockException {
        CacheableSessionLockManager session = this.sessionLockManagers.get(sessionId);
        if (session != null && session.containsPendingLock(nodeIdentifier)) {
            LockData lockData = session.getPendingLock(nodeIdentifier);
            Fqn<String> lockPath = this.makeLockFqn(lockData.getNodeIdentifier());
            Node node = this.cache.getRoot().addChild(lockPath);
            LockData oldLockData = (LockData)node.putIfAbsent((Object)LOCK_DATA, (Object)lockData);
            if (oldLockData != null) {
                throw new LockException("Unable to write LockData. Node [" + lockData.getNodeIdentifier() + "] already has LockData!");
            }
        } else {
            throw new LockException("No lock in pending locks");
        }
        session.notifyLockPersisted(nodeIdentifier);
    }

    private synchronized void internalUnLock(String sessionId, String nodeIdentifier) throws LockException {
        LockData lData = this.getLockDataById(nodeIdentifier);
        if (lData != null) {
            this.cache.removeNode(this.makeLockFqn(nodeIdentifier));
            CacheableSessionLockManager sessMgr = this.sessionLockManagers.get(sessionId);
            if (sessMgr != null) {
                sessMgr.notifyLockRemoved(nodeIdentifier);
            }
        }
    }

    @Override
    public boolean lockExist(String nodeId) {
        try {
            return this.executeLockActionNonTxAware(this.lockExist, nodeId);
        }
        catch (LockException lockException) {
            return false;
        }
    }

    @Override
    public String getLockTokenHash(String token) {
        String hash = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(token.getBytes(), 0, token.length());
            hash = new BigInteger(1, m.digest()).toString(16);
        }
        catch (NoSuchAlgorithmException e) {
            this.LOG.error((Object)"Can't get instanse of MD5 MessageDigest!", (Throwable)e);
        }
        return hash;
    }

    @Override
    public LockData getExactNodeOrCloseParentLock(NodeData node) throws RepositoryException {
        return this.getExactNodeOrCloseParentLock(node, true);
    }

    private LockData getExactNodeOrCloseParentLock(NodeData node, boolean checkHasLocks) throws RepositoryException {
        NodeData parentData;
        if (node == null || checkHasLocks && !this.hasLocks()) {
            return null;
        }
        LockData retval = null;
        retval = this.getLockDataById(node.getIdentifier());
        if (retval == null && (parentData = (NodeData)this.dataManager.getItemData(node.getParentIdentifier())) != null) {
            retval = this.getExactNodeOrCloseParentLock(parentData, false);
        }
        return retval;
    }

    public LockData getExactNodeLock(NodeData node) throws RepositoryException {
        if (node == null || !this.hasLocks()) {
            return null;
        }
        return this.getLockDataById(node.getIdentifier());
    }

    @Override
    public LockData getClosedChild(NodeData node) throws RepositoryException {
        return this.getClosedChild(node, true);
    }

    private LockData getClosedChild(NodeData node, boolean checkHasLocks) throws RepositoryException {
        if (node == null || checkHasLocks && !this.hasLocks()) {
            return null;
        }
        LockData retval = null;
        List<NodeData> childData = this.dataManager.getChildNodesData(node);
        for (NodeData nodeData : childData) {
            retval = this.getLockDataById(nodeData.getIdentifier());
            if (retval == null) continue;
            return retval;
        }
        for (NodeData nodeData : childData) {
            retval = this.getClosedChild(nodeData, false);
            if (retval == null) continue;
            return retval;
        }
        return retval;
    }

    protected LockData getLockDataById(String nodeId) {
        try {
            return this.executeLockActionNonTxAware(this.getLockDataById, nodeId);
        }
        catch (LockException lockException) {
            return null;
        }
    }

    protected synchronized List<LockData> getLockList() {
        try {
            return this.executeLockActionNonTxAware(this.getLockList, null);
        }
        catch (LockException lockException) {
            return null;
        }
    }

    protected void removeLock(String nodeIdentifier) {
        try {
            NodeData nData = (NodeData)this.dataManager.getItemData(nodeIdentifier);
            if (nData == null) {
                return;
            }
            PlainChangesLogImpl changesLog = new PlainChangesLogImpl(new ArrayList<ItemState>(), SystemIdentity.SYSTEM, 0x800000);
            TransientItemData lockOwner = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKOWNER, 1)));
            if (lockOwner == null) {
                return;
            }
            changesLog.add(ItemState.createDeletedState(lockOwner));
            TransientItemData lockIsDeep = this.copyItemData((PropertyData)this.dataManager.getItemData(nData, new QPathEntry(Constants.JCR_LOCKISDEEP, 1)));
            if (lockIsDeep == null) {
                return;
            }
            changesLog.add(ItemState.createDeletedState(lockIsDeep));
            if (lockOwner == null && lockIsDeep == null) {
                return;
            }
            this.dataManager.save(new TransactionChangesLog(changesLog));
        }
        catch (JCRInvalidItemStateException e) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"The propperty was removed in other node of cluster.", (Throwable)((Object)e));
            }
        }
        catch (RepositoryException e) {
            this.LOG.error((Object)("Error occur during removing lock" + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    @Override
    public void closeSessionLockManager(String sessionID) {
        this.sessionLockManagers.remove(sessionID);
    }

    private Fqn<String> makeLockFqn(String nodeId) {
        return Fqn.fromRelativeElements(this.lockRoot, (Object[])new String[]{nodeId});
    }

    private void createStructuredNode(Fqn<String> fqn) {
        Node node = this.cache.getRoot().getChild(fqn);
        if (node == null) {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            node = this.cache.getRoot().addChild(fqn);
        }
        node.setResident(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R, A> R executeLockActionNonTxAware(LockActionNonTxAware<R, A> action, A arg) throws LockException {
        R r;
        block8: {
            Transaction tx = null;
            try {
                if (this.tm != null) {
                    try {
                        tx = this.tm.suspend();
                    }
                    catch (Exception e) {
                        this.LOG.warn((Object)"Cannot suspend the current transaction", (Throwable)e);
                    }
                }
                r = action.execute(arg);
                Object var6_6 = null;
                if (tx == null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var6_7 = null;
                    if (tx == null) break block9;
                    try {
                        this.tm.resume(tx);
                    }
                    catch (Exception e) {
                        this.LOG.warn((Object)"Cannot resume the current transaction", (Throwable)e);
                    }
                }
                throw throwable;
            }
            try {
                this.tm.resume(tx);
            }
            catch (Exception e) {
                this.LOG.warn((Object)"Cannot resume the current transaction", (Throwable)e);
            }
        }
        return r;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LockActionNonTxAware<R, A> {
        public R execute(A var1) throws LockException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LockOperationContainer
    implements Comparable<LockOperationContainer> {
        private String identifier;
        private String sessionId;
        private int type;

        public LockOperationContainer(String identifier, String sessionId, int type) {
            this.identifier = identifier;
            this.sessionId = sessionId;
            this.type = type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void apply() throws LockException {
            if (this.type == 0x400000) {
                CacheableLockManagerImpl.this.internalLock(this.sessionId, this.identifier);
            } else if (this.type == 0x800000) {
                CacheableLockManagerImpl.this.internalUnLock(this.sessionId, this.identifier);
            }
        }

        @Override
        public int compareTo(LockOperationContainer o) {
            return this.identifier.compareTo(o.getIdentifier());
        }
    }
}

