/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.QueryResult;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.AndQueryNode;
import org.exoplatform.services.jcr.impl.core.query.DefaultQueryNodeVisitor;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.OrderQueryNode;
import org.exoplatform.services.jcr.impl.core.query.PropertyTypeRegistry;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeFactory;
import org.exoplatform.services.jcr.impl.core.query.QueryParser;
import org.exoplatform.services.jcr.impl.core.query.QueryRootNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.LuceneQueryBuilder;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.SingleColumnQueryResult;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellSuggestion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
extends AbstractQueryImpl {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.QueryImpl");
    public static final InternalQName DEFAULT_SELECTOR_NAME = new InternalQName("", "s");
    protected final QueryRootNode root;

    public QueryImpl(SessionImpl session, SessionDataManager itemMgr, SearchIndex index, PropertyTypeRegistry propReg, String statement, String language, QueryNodeFactory factory) throws InvalidQueryException {
        super(session, itemMgr, index, propReg);
        this.root = QueryParser.parse(statement, language, session.getLocationFactory(), factory);
    }

    public QueryResult execute(long offset, long limit) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("Executing query: \n" + this.root.dump());
        }
        Query query = LuceneQueryBuilder.createQuery(this.root, this.session, this.index.getContext().getItemStateManager(), this.index.getNamespaceMappings(), this.index.getTextAnalyzer(), this.propReg, this.index.getSynonymProvider(), this.index.getIndexFormatVersion(), this.index.getContext().getVirtualTableResolver());
        OrderQueryNode orderNode = this.root.getOrderNode();
        OrderQueryNode.OrderSpec[] orderSpecs = orderNode != null ? orderNode.getOrderSpecs() : new OrderQueryNode.OrderSpec[]{};
        QPath[] orderProperties = new QPath[orderSpecs.length];
        boolean[] ascSpecs = new boolean[orderSpecs.length];
        for (int i = 0; i < orderSpecs.length; ++i) {
            orderProperties[i] = orderSpecs[i].getPropertyPath();
            ascSpecs[i] = orderSpecs[i].isAscending();
        }
        return new SingleColumnQueryResult(this.index, this.itemMgr, this.session, this.session.getAccessManager(), this, query, new SpellSuggestion(this.index.getSpellChecker(), this.root), this.getSelectProperties(), orderProperties, ascSpecs, this.getRespectDocumentOrder(), offset, limit);
    }

    protected InternalQName[] getSelectProperties() throws RepositoryException {
        ArrayList<InternalQName> selectProps = new ArrayList<InternalQName>();
        selectProps.addAll(Arrays.asList(this.root.getSelectProperties()));
        if (selectProps.size() == 0) {
            LocationStepQueryNode[] steps = this.root.getLocationNode().getPathSteps();
            final InternalQName[] ntName = new InternalQName[1];
            steps[steps.length - 1].acceptOperands(new DefaultQueryNodeVisitor(){

                public Object visit(AndQueryNode node, Object data) throws RepositoryException {
                    return node.acceptOperands(this, data);
                }

                public Object visit(NodeTypeQueryNode node, Object data) {
                    ntName[0] = node.getValue();
                    return data;
                }
            }, null);
            if (ntName[0] == null) {
                ntName[0] = Constants.NT_BASE;
            }
            NodeTypeData nt = this.session.getWorkspace().getNodeTypesHolder().getNodeType(ntName[0]);
            PropertyDefinitionData[] propDefs = nt.getDeclaredPropertyDefinitions();
            for (int i = 0; i < propDefs.length; ++i) {
                PropertyDefinitionData propDef = propDefs[i];
                if (propDef.isResidualSet() || propDef.isMultiple()) continue;
                selectProps.add(propDef.getName());
            }
        }
        if (!selectProps.contains((Object)Constants.JCR_PATH)) {
            selectProps.add(Constants.JCR_PATH);
        }
        if (!selectProps.contains((Object)Constants.JCR_SCORE)) {
            selectProps.add(Constants.JCR_SCORE);
        }
        return selectProps.toArray(new InternalQName[selectProps.size()]);
    }

    public boolean needsSystemTree() {
        return this.root.needsSystemTree();
    }
}

