/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.history.impl.jcr;

import java.util.List;
import org.exoplatform.services.xmpp.history.impl.jcr.InterlocutorImpl;
import org.exoplatform.services.xmpp.util.CodingUtils;
import org.jcrom.annotations.JcrChildNode;
import org.jcrom.annotations.JcrName;
import org.jcrom.annotations.JcrNode;
import org.jcrom.annotations.JcrPath;
import org.jcrom.annotations.JcrProperty;
import org.jivesoftware.smack.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JcrNode(nodeType="lr:participantchat")
public class Participant {
    @JcrName
    private String hexName;
    @JcrPath
    private String path;
    @JcrProperty(name="lr:participantchatjid")
    private String jid;
    @JcrProperty(name="lr:participantchatusername")
    private String username;
    @JcrChildNode
    private List<InterlocutorImpl> interlocutorList;
    @JcrChildNode
    private List<InterlocutorImpl> groupChatList;

    public Participant() {
    }

    public Participant(String jid, List<InterlocutorImpl> interlocutorList, List<InterlocutorImpl> groupChatList) {
        this.jid = jid;
        this.interlocutorList = interlocutorList;
        this.groupChatList = groupChatList;
        this.username = StringUtils.parseName((String)jid);
        this.hexName = CodingUtils.encodeToHex(this.username);
    }

    public void addInterlocutor(InterlocutorImpl interlocutor) {
        this.interlocutorList.add(interlocutor);
    }

    public void addGroupChat(InterlocutorImpl interlocutor) {
        this.groupChatList.add(interlocutor);
    }

    public String getHexName() {
        return this.hexName;
    }

    public InterlocutorImpl getInterlocutor(String name) {
        if (this.interlocutorList != null) {
            for (InterlocutorImpl interlocutor : this.interlocutorList) {
                if (!interlocutor.getInterlocutorName().equals(name)) continue;
                return interlocutor;
            }
        }
        return null;
    }

    public InterlocutorImpl getGroupChat(String name) {
        if (this.groupChatList != null) {
            for (InterlocutorImpl interlocutor : this.groupChatList) {
                if (!interlocutor.getInterlocutorName().equals(name)) continue;
                return interlocutor;
            }
        }
        return null;
    }

    public List<InterlocutorImpl> getInterlocutorList() {
        return this.interlocutorList;
    }

    public String getJid() {
        return this.jid;
    }

    public String getPath() {
        return this.path;
    }

    public String getUsername() {
        return this.username;
    }

    public List<InterlocutorImpl> getGroupChatList() {
        return this.groupChatList;
    }

    public void setHexName(String hexName) {
        this.hexName = hexName;
    }

    public void setInterlocutorList(List<InterlocutorImpl> interlocutorList) {
        this.interlocutorList = interlocutorList;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setGroupChatList(List<InterlocutorImpl> groupChatList) {
        this.groupChatList = groupChatList;
    }
}

