/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.AbstractCacheLoader;
import org.jboss.cache.loader.LocalDelegatingCacheLoaderConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDelegatingCacheLoader
extends AbstractCacheLoader {
    CacheLoaderConfig.IndividualCacheLoaderConfig config;
    CacheSPI delegate = null;

    @Override
    public void setConfig(CacheLoaderConfig.IndividualCacheLoaderConfig config) {
        this.config = config;
        if (config instanceof LocalDelegatingCacheLoaderConfig) {
            this.delegate = (CacheSPI)((LocalDelegatingCacheLoaderConfig)config).getDelegate();
        }
    }

    @Override
    public CacheLoaderConfig.IndividualCacheLoaderConfig getConfig() {
        return this.config;
    }

    @Override
    public Set<?> getChildrenNames(Fqn fqn) throws Exception {
        Node node = this.delegate.getRoot().getChild(fqn);
        if (node == null) {
            return null;
        }
        Set<Object> cn = node.getChildrenNames();
        if (cn.isEmpty()) {
            return null;
        }
        return cn;
    }

    @Override
    public Map<Object, Object> get(Fqn name) throws Exception {
        NodeSPI n = (NodeSPI)this.delegate.getRoot().getChild(name);
        if (n == null) {
            return null;
        }
        Map<Object, Object> m = n.getData();
        if (m == null) {
            m = Collections.emptyMap();
        }
        return m;
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        return this.delegate.getNode(name) != null;
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        return this.delegate.put(name, key, value);
    }

    @Override
    public void put(Fqn name, Map<Object, Object> attributes) throws Exception {
        this.delegate.put(name, attributes);
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        return this.delegate.remove(fqn, key);
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        this.delegate.removeNode(fqn);
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        Node node = this.delegate.getRoot().getChild(fqn);
        if (node != null) {
            node.clearData();
        }
    }

    protected void setDelegateCache(CacheSPI delegate) {
        this.delegate = delegate;
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        try {
            this.delegate.getStateTransferManager().getState(os, Fqn.ROOT, this.delegate.getConfiguration().getStateRetrievalTimeout(), true, false);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Caught exception getting state from delegate", t);
        }
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        this.delegate.getStateTransferManager().setState(is, Fqn.ROOT);
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        throw new UnsupportedOperationException("setting and loading state for specific Fqns not supported");
    }
}

