/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanELResolver
extends ELResolver {
    private final boolean readOnly;
    private final ConcurrentHashMap<Class<?>, BeanProperties> cache;

    public BeanELResolver() {
        this(false);
    }

    public BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.isResolvable(base) ? Object.class : null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isResolvable(base)) {
            PropertyDescriptor[] properties;
            try {
                properties = Introspector.getBeanInfo(base.getClass()).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                return Collections.emptyList().iterator();
            }
            return new Iterator<FeatureDescriptor>(){
                int next = 0;

                @Override
                public boolean hasNext() {
                    return properties != null && this.next < properties.length;
                }

                @Override
                public FeatureDescriptor next() {
                    PropertyDescriptor property = properties[this.next++];
                    FeatureDescriptor feature = new FeatureDescriptor();
                    feature.setDisplayName(property.getDisplayName());
                    feature.setName(property.getName());
                    feature.setShortDescription(property.getShortDescription());
                    feature.setExpert(property.isExpert());
                    feature.setHidden(property.isHidden());
                    feature.setPreferred(property.isPreferred());
                    feature.setValue("type", property.getPropertyType());
                    feature.setValue("resolvableAtDesignTime", true);
                    return feature;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove");
                }
            };
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        Class<?> result = null;
        if (this.isResolvable(base)) {
            result = this.toBeanProperty(base, property).getPropertyType();
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (this.isResolvable(base)) {
            Method method = this.toBeanProperty(base, property).getReadMethod();
            if (method == null) {
                throw new PropertyNotFoundException("Cannot read property " + property);
            }
            try {
                result = method.invoke(base, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new ELException(e.getCause());
            }
            catch (Exception e) {
                throw new ELException(e);
            }
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        boolean result = this.readOnly;
        if (this.isResolvable(base)) {
            result |= this.toBeanProperty(base, property).isReadOnly();
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isResolvable(base)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            Method method = this.toBeanProperty(base, property).getWriteMethod();
            if (method == null) {
                throw new PropertyNotWritableException("Cannot write property: " + property);
            }
            try {
                method.invoke(base, value);
            }
            catch (InvocationTargetException e) {
                throw new ELException("Cannot write property: " + property, e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new PropertyNotWritableException("Cannot write property: " + property, e);
            }
            context.setPropertyResolved(true);
        }
    }

    private final boolean isResolvable(Object base) {
        return base != null;
    }

    private final BeanProperty toBeanProperty(Object base, Object property) {
        BeanProperty beanProperty;
        BeanProperties beanProperties = this.cache.get(base.getClass());
        if (beanProperties == null) {
            beanProperties = new BeanProperties(base.getClass());
            this.cache.putIfAbsent(base.getClass(), beanProperties);
        }
        BeanProperty beanProperty2 = beanProperty = property == null ? null : beanProperties.getBeanProperty(property.toString());
        if (beanProperty == null) {
            throw new PropertyNotFoundException("Could not find property " + property + " in " + base.getClass());
        }
        return beanProperty;
    }

    private final void purgeBeanClasses(ClassLoader loader) {
        Iterator classes = this.cache.keySet().iterator();
        while (classes.hasNext()) {
            if (loader != ((Class)classes.next()).getClassLoader()) continue;
            classes.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperty {
        private final Class<?> baseClass;
        private final PropertyDescriptor descriptor;

        public BeanProperty(Class<?> baseClass, PropertyDescriptor descriptor) {
            this.baseClass = baseClass;
            this.descriptor = descriptor;
        }

        public Class<?> getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public Method getReadMethod() {
            return this.findAccessibleMethod(this.baseClass, this.descriptor.getReadMethod());
        }

        public Method getWriteMethod() {
            return this.findAccessibleMethod(this.baseClass, this.descriptor.getWriteMethod());
        }

        public boolean isReadOnly() {
            return this.findAccessibleMethod(this.baseClass, this.descriptor.getWriteMethod()) == null;
        }

        private Method findAccessibleMethod(Class<?> clazz, Method method) {
            if (method == null || Modifier.isPublic(clazz.getModifiers())) {
                return method;
            }
            for (Class<?> cls : clazz.getInterfaces()) {
                Method mth = null;
                try {
                    mth = cls.getMethod(method.getName(), method.getParameterTypes());
                    mth = this.findAccessibleMethod(mth.getDeclaringClass(), mth);
                    if (mth == null) continue;
                    return mth;
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            Class<?> cls = clazz.getSuperclass();
            if (cls != null) {
                Method mth = null;
                try {
                    mth = cls.getMethod(method.getName(), method.getParameterTypes());
                    mth = this.findAccessibleMethod(mth.getDeclaringClass(), mth);
                    if (mth != null) {
                        return mth;
                    }
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class BeanProperties {
        private final Map<String, BeanProperty> map = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> baseClass) {
            PropertyDescriptor[] descriptors;
            try {
                descriptors = Introspector.getBeanInfo(baseClass).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new ELException(e);
            }
            for (PropertyDescriptor descriptor : descriptors) {
                this.map.put(descriptor.getName(), new BeanProperty(baseClass, descriptor));
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this.map.get(property);
        }
    }
}

