/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import java.util.Calendar;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.DBObjectQuery;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.StandardSQLDAO;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.jdbc.SimpleJDBCUserListAccess;
import org.exoplatform.services.organization.jdbc.UserImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDAOImpl
extends StandardSQLDAO<UserImpl>
implements UserHandler {
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.organization.jdbc.UserDAOImpl");
    protected ListenerService listenerService_;

    public UserDAOImpl(ListenerService lService, ExoDatasource datasource, DBObjectMapper<UserImpl> mapper) {
        super(datasource, mapper, UserImpl.class);
        this.listenerService_ = lService;
    }

    public User createUserInstance() {
        return new UserImpl();
    }

    public User createUserInstance(String username) {
        return new UserImpl(username);
    }

    public void createUser(User user, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("----------- CREATE USER " + user.getUserName()));
        }
        UserImpl userImpl = (UserImpl)user;
        if (broadcast) {
            this.listenerService_.broadcast("organization.user.preCreate", (Object)this, (Object)userImpl);
        }
        super.save((DBObject)userImpl);
        if (broadcast) {
            this.listenerService_.broadcast("organization.user.postCreate", (Object)this, (Object)userImpl);
        }
    }

    public boolean authenticate(String username, String password) throws Exception {
        User user = this.findUserByName(username);
        if (user == null) {
            return false;
        }
        boolean authenticated = user.getPassword().equals(password);
        if (log.isDebugEnabled()) {
            log.debug((Object)("+++++++++++AUTHENTICATE USERNAME " + username + " AND PASS " + password + " - " + authenticated));
        }
        if (authenticated) {
            UserImpl userImpl = (UserImpl)user;
            userImpl.setLastLoginTime(Calendar.getInstance().getTime());
            this.saveUser(userImpl, false);
        }
        return authenticated;
    }

    public User findUserByName(String userName) throws Exception {
        DBObjectQuery query = new DBObjectQuery(UserImpl.class);
        query.addLIKE("USER_NAME", userName);
        User user = (User)this.loadUnique(query.toQuery());
        if (log.isDebugEnabled()) {
            log.debug((Object)("+++++++++++FIND USER BY USER NAME " + userName + " - " + (user != null)));
        }
        return user;
    }

    public LazyPageList<User> findUsers(Query orgQuery) throws Exception {
        return new LazyPageList(this.findUsersByQuery(orgQuery), 20);
    }

    public ListAccess<User> findUsersByQuery(Query orgQuery) throws Exception {
        DBObjectQuery dbQuery = new DBObjectQuery(UserImpl.class);
        if (orgQuery.getUserName() != null) {
            dbQuery.addLIKE("UPPER(USER_NAME)", orgQuery.getUserName().toUpperCase());
        }
        if (orgQuery.getFirstName() != null) {
            dbQuery.addLIKE("UPPER(FIRST_NAME)", orgQuery.getFirstName().toUpperCase());
        }
        if (orgQuery.getLastName() != null) {
            dbQuery.addLIKE("UPPER(LAST_NAME)", orgQuery.getLastName().toUpperCase());
        }
        dbQuery.addLIKE("EMAIL", orgQuery.getEmail());
        dbQuery.addGT("LAST_LOGIN_TIME", (Object)orgQuery.getFromLoginDate());
        dbQuery.addLT("LAST_LOGIN_TIME", (Object)orgQuery.getToLoginDate());
        return new SimpleJDBCUserListAccess((DAO)this, dbQuery.toQuery(), dbQuery.toCountQuery());
    }

    public LazyPageList<User> findUsersByGroup(String groupId) throws Exception {
        return new LazyPageList(this.findUsersByGroupId(groupId), 20);
    }

    public ListAccess<User> findUsersByGroupId(String groupId) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("+++++++++++FIND USER BY GROUP_ID " + groupId));
        }
        PortalContainer manager = PortalContainer.getInstance();
        OrganizationService service = (OrganizationService)manager.getComponentInstanceOfType(OrganizationService.class);
        MembershipHandler membershipHandler = service.getMembershipHandler();
        GroupHandler groupHandler = service.getGroupHandler();
        Group group = groupHandler.findGroupById(groupId);
        List members = (List)membershipHandler.findMembershipsByGroup(group);
        DBObjectQuery dbQuery = new DBObjectQuery(UserImpl.class);
        for (Membership member : members) {
            dbQuery.addLIKE("USER_NAME", member.getUserName());
        }
        return new SimpleJDBCUserListAccess((DAO)this, dbQuery.toQueryUseOR(), dbQuery.toCountQueryUseOR());
    }

    public LazyPageList<User> getUserPageList(int pageSize) throws Exception {
        return new LazyPageList(this.findAllUsers(), pageSize);
    }

    public ListAccess<User> findAllUsers() throws Exception {
        DBObjectQuery dbQuery = new DBObjectQuery(UserImpl.class);
        return new SimpleJDBCUserListAccess((DAO)this, dbQuery.toQuery(), dbQuery.toCountQuery());
    }

    public User removeUser(String userName, boolean broadcast) throws Exception {
        UserImpl userImpl = (UserImpl)this.findUserByName(userName);
        if (userImpl == null) {
            return null;
        }
        if (broadcast) {
            this.listenerService_.broadcast("organization.user.preDelete", (Object)this, (Object)userImpl);
        }
        super.remove((DBObject)userImpl);
        if (broadcast) {
            this.listenerService_.broadcast("organization.user.postDelete", (Object)this, (Object)userImpl);
        }
        return userImpl;
    }

    public void saveUser(User user, boolean broadcast) throws Exception {
        UserImpl userImpl = (UserImpl)user;
        if (broadcast) {
            this.listenerService_.broadcast("organization.user.preUpdate", (Object)this, (Object)userImpl);
        }
        super.update((DBObject)userImpl);
        if (broadcast) {
            this.listenerService_.broadcast("organization.user.postUpdate", (Object)this, (Object)userImpl);
        }
    }

    public void addUserEventListener(UserEventListener listener) {
    }
}

