/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerService {
    private Map<String, List<Listener>> listeners_ = new HashMap<String, List<Listener>>();
    private static Log log = ExoLogger.getLogger((String)"exo.kernel.component.common.ListenerService");

    public void addListener(Listener listener) {
        String name = listener.getName();
        List<Listener> list = this.listeners_.get(name);
        if (list == null) {
            list = new ArrayList<Listener>();
            this.listeners_.put(name, list);
        }
        list.add(listener);
    }

    public void addListener(String eventName, Listener listener) {
        listener.setName(eventName);
        this.addListener(listener);
    }

    public final <S, D> void broadcast(String name, S source, D data) throws Exception {
        List<Listener> list = this.listeners_.get(name);
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("broadcasting event " + name + " on " + listener.getName()));
            }
            listener.onEvent(new Event<S, D>(name, source, data));
        }
    }

    public final <T extends Event> void broadcast(T event) throws Exception {
        List<Listener> list = this.listeners_.get(event.getEventName());
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            listener.onEvent(event);
        }
    }
}

