/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.naming;

import java.util.Map;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;

public class BindReferencePlugin
extends BaseComponentPlugin {
    private String bindName;
    private Reference reference;

    public BindReferencePlugin(InitParams params) throws ConfigurationException {
        ValueParam bnParam = params.getValueParam("bind-name");
        if (bnParam == null) {
            throw new ConfigurationException("No 'bind-name' parameter found");
        }
        ValueParam cnParam = params.getValueParam("class-name");
        if (cnParam == null) {
            throw new ConfigurationException("No 'class-name' parameter found");
        }
        ValueParam factoryParam = params.getValueParam("factory");
        if (factoryParam == null) {
            throw new ConfigurationException("No 'factory' parameter found");
        }
        ValueParam flParam = params.getValueParam("factory-location");
        String factoryLocation = flParam != null ? flParam.getValue() : null;
        this.bindName = bnParam.getValue();
        this.reference = new Reference(cnParam.getValue(), factoryParam.getValue(), factoryLocation);
        PropertiesParam addrsParam = params.getPropertiesParam("ref-addresses");
        if (addrsParam != null) {
            for (Map.Entry entry : addrsParam.getProperties().entrySet()) {
                this.reference.add(new StringRefAddr((String)entry.getKey(), (String)entry.getValue()));
            }
        }
    }

    public Reference getReference() {
        return this.reference;
    }

    public String getBindName() {
        return this.bindName;
    }
}

