/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.navigation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.webui.navigation.ParentChildPair;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageNavigationUtils {
    public static void removeNode(List<PageNode> list, String uri) {
        if (list == null) {
            return;
        }
        for (PageNode pageNode : list) {
            if (!pageNode.getUri().equalsIgnoreCase(uri)) continue;
            list.remove(pageNode);
            return;
        }
    }

    @Deprecated
    public static PageNode[] searchPageNodesByUri(PageNode node, String uri) {
        if (node.getUri().equals(uri)) {
            return new PageNode[]{null, node};
        }
        if (node.getChildren() == null) {
            return null;
        }
        List children = node.getChildren();
        for (PageNode ele : children) {
            PageNode[] returnNodes = PageNavigationUtils.searchPageNodesByUri(ele, uri);
            if (returnNodes == null) continue;
            if (returnNodes[0] == null) {
                returnNodes[0] = node;
            }
            return returnNodes;
        }
        return null;
    }

    @Deprecated
    public static PageNode[] searchPageNodesByUri(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        ArrayList nodes = nav.getNodes();
        for (PageNode ele : nodes) {
            PageNode[] returnNodes = PageNavigationUtils.searchPageNodesByUri(ele, uri);
            if (returnNodes == null) continue;
            return returnNodes;
        }
        return null;
    }

    public static ParentChildPair searchParentChildPairByUri(PageNavigation nav, String uri) {
        ArrayList nodes = nav.getNodes();
        if (nodes == null) {
            return null;
        }
        for (PageNode ele : nodes) {
            ParentChildPair parentChildPair = PageNavigationUtils.searchParentChildPairUnderNode(ele, uri);
            if (parentChildPair == null) continue;
            return parentChildPair;
        }
        return null;
    }

    public static ParentChildPair searchParentChildPairUnderNode(PageNode rootNode, String uri) {
        if (uri.equals(rootNode.getUri())) {
            return new ParentChildPair(null, rootNode);
        }
        List nodes = rootNode.getNodes();
        if (nodes == null) {
            return null;
        }
        for (PageNode node : nodes) {
            ParentChildPair parentChildPair = PageNavigationUtils.searchParentChildPairUnderNode(node, uri);
            if (parentChildPair == null) continue;
            if (parentChildPair.getParentNode() == null) {
                parentChildPair.setParentNode(rootNode);
            }
            return parentChildPair;
        }
        return null;
    }

    public static ParentChildPair searchParentChildPairByPath(PageNode rootNode, String[] path) {
        if (path.length == 0) {
            throw new IllegalArgumentException("The input path must have unzero length");
        }
        if (!rootNode.getName().equals(path[0])) {
            return null;
        }
        if (path.length == 1) {
            return new ParentChildPair(null, rootNode);
        }
        PageNode tempNode = rootNode;
        PageNode parentNode = null;
        PageNode childNode = null;
        for (int i = 1; i < path.length; ++i) {
            childNode = tempNode.getChild(path[i]);
            if (childNode == null) {
                return null;
            }
            parentNode = tempNode;
        }
        return new ParentChildPair(parentNode, childNode);
    }

    public static PageNode searchPageNodeByUri(PageNode node, String uri) {
        if (node.getUri().equals(uri)) {
            return node;
        }
        if (node.getChildren() == null) {
            return null;
        }
        List children = node.getChildren();
        for (PageNode ele : children) {
            PageNode returnNode = PageNavigationUtils.searchPageNodeByUri(ele, uri);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public static PageNode searchPageNodeByUri(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        ArrayList nodes = nav.getNodes();
        for (PageNode ele : nodes) {
            PageNode returnNode = PageNavigationUtils.searchPageNodeByUri(ele, uri);
            if (returnNode == null) continue;
            return returnNode;
        }
        return null;
    }

    public static Object searchParentNode(PageNavigation nav, String uri) {
        if (nav.getNodes() == null) {
            return null;
        }
        int last = uri.lastIndexOf("/");
        String parentUri = "";
        if (last > -1) {
            parentUri = uri.substring(0, uri.lastIndexOf("/"));
        }
        for (PageNode ele : nav.getNodes()) {
            if (!ele.getUri().equals(uri)) continue;
            return nav;
        }
        if (parentUri.equals("")) {
            return null;
        }
        return PageNavigationUtils.searchPageNodeByUri(nav, parentUri);
    }

    public static PageNavigation filter(PageNavigation nav, String userName) throws Exception {
        return PageNavigationUtils.filterNavigation(nav, userName, false, false);
    }

    public static PageNavigation filterNavigation(PageNavigation nav, String userName, boolean acceptNonDisplayedNode, boolean acceptNodeWithoutPage) throws Exception {
        PageNavigation filter = nav.clone();
        filter.setNodes(new ArrayList());
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserACL userACL = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        for (PageNode node : nav.getNodes()) {
            PageNode newNode = PageNavigationUtils.filterNodeNavigation(node, userName, acceptNonDisplayedNode, acceptNodeWithoutPage, userService, userACL);
            if (newNode == null) continue;
            filter.addNode(newNode);
        }
        return filter;
    }

    @Deprecated
    public static PageNavigation filterNavigation(PageNavigation nav, String userName, boolean acceptNonDisplayedNode) throws Exception {
        return PageNavigationUtils.filterNavigation(nav, userName, acceptNonDisplayedNode, true);
    }

    @Deprecated
    private static PageNode filterNodeNavigation(PageNode startNode, String userName, boolean acceptNonDisplayedNode, UserPortalConfigService userService, UserACL userACL) throws Exception {
        PageNode cloneStartNode = PageNavigationUtils.filterNodeNavigation(startNode, userName, acceptNonDisplayedNode, false, userService, userACL);
        return cloneStartNode;
    }

    private static PageNode filterNodeNavigation(PageNode startNode, String userName, boolean acceptNonDisplayedNode, boolean acceptNodeWithoutPage, UserPortalConfigService userService, UserACL userACL) throws Exception {
        boolean doNothingCase_3;
        Visibility nodeVisibility = startNode.getVisibility();
        String pageReference = startNode.getPageReference();
        boolean doNothingCase_1 = nodeVisibility == Visibility.SYSTEM && (!userACL.getSuperUser().equals(userName) || !acceptNonDisplayedNode);
        boolean doNothingCase_2 = nodeVisibility != Visibility.SYSTEM && !startNode.isDisplay() && !acceptNonDisplayedNode;
        boolean bl = doNothingCase_3 = pageReference != null && userService.getPage(pageReference, userName) == null && !acceptNodeWithoutPage;
        if (doNothingCase_1 || doNothingCase_2 || doNothingCase_3) {
            return null;
        }
        PageNode cloneStartNode = startNode.clone();
        ArrayList<PageNode> filteredChildren = new ArrayList<PageNode>();
        List children = startNode.getChildren();
        if (children != null) {
            for (PageNode child : children) {
                PageNode filteredChildNode = PageNavigationUtils.filterNodeNavigation(child, userName, acceptNonDisplayedNode, acceptNodeWithoutPage, userService, userACL);
                if (filteredChildNode == null) continue;
                filteredChildren.add(filteredChildNode);
            }
        }
        if (!acceptNonDisplayedNode && filteredChildren.size() == 0 && cloneStartNode.getPageReference() == null) {
            return null;
        }
        cloneStartNode.setChildren(filteredChildren);
        return cloneStartNode;
    }

    public static PageNode filter(PageNode node, String userName, boolean acceptNonDisplayedNode) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        ExoContainer container = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userService = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserACL userACL = (UserACL)container.getComponentInstanceOfType(UserACL.class);
        return PageNavigationUtils.filterNodeNavigation(node, userName, acceptNonDisplayedNode, userService, userACL);
    }

    public static void localizePageNavigation(PageNavigation nav, Locale locale, ResourceBundleManager i18nManager) {
        if (nav.getOwnerType().equals("user")) {
            return;
        }
        ResourceBundle res = i18nManager.getNavigationResourceBundle(locale.getLanguage(), nav.getOwnerType(), nav.getOwnerId());
        for (PageNode node : nav.getNodes()) {
            PageNavigationUtils.resolveLabel(res, node);
        }
    }

    private static void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            PageNavigationUtils.resolveLabel(res, childNode);
        }
    }

    public static PageNavigation findNavigationByID(List<PageNavigation> all_Navigations, int id) {
        for (PageNavigation nav : all_Navigations) {
            if (nav.getId() != id) continue;
            return nav;
        }
        return null;
    }

    public static void sortPageNavigation(List<PageNavigation> navigations) {
        Collections.sort(navigations, new PageNavigationComparator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PageNavigationComparator
    implements Comparator<PageNavigation> {
        @Override
        public int compare(PageNavigation firstNav, PageNavigation secondNav) {
            int secondNavPriority;
            int firstNavPriority = firstNav.getPriority();
            if (firstNavPriority == (secondNavPriority = secondNav.getPriority())) {
                String firstNavId = firstNav.getOwnerId();
                String secondNavId = secondNav.getOwnerId();
                return firstNavId.compareTo(secondNavId);
            }
            if (firstNavPriority < secondNavPriority) {
                return -1;
            }
            return 1;
        }
    }
}

