/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.lock.UpdateLockingStrategy;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.sql.CaseFragment;
import org.hibernate.sql.DecodeCaseFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDMSOS2200Dialect
extends Dialect {
    private static Logger log = LoggerFactory.getLogger((Class)RDMSOS2200Dialect.class);

    public RDMSOS2200Dialect() {
        log.info("RDMSOS2200Dialect version: 1.0");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("sign", new StandardSQLFunction("sign", Hibernate.INTEGER));
        this.registerFunction("ascii", new StandardSQLFunction("ascii", Hibernate.INTEGER));
        this.registerFunction("char_length", new StandardSQLFunction("char_length", Hibernate.INTEGER));
        this.registerFunction("character_length", new StandardSQLFunction("character_length", Hibernate.INTEGER));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.INTEGER));
        this.registerFunction("concat", new SQLFunctionTemplate(Hibernate.STRING, "concat(?1, ?2)"));
        this.registerFunction("instr", new StandardSQLFunction("instr", Hibernate.STRING));
        this.registerFunction("lpad", new StandardSQLFunction("lpad", Hibernate.STRING));
        this.registerFunction("replace", new StandardSQLFunction("replace", Hibernate.STRING));
        this.registerFunction("rpad", new StandardSQLFunction("rpad", Hibernate.STRING));
        this.registerFunction("substr", new StandardSQLFunction("substr", Hibernate.STRING));
        this.registerFunction("lcase", new StandardSQLFunction("lcase"));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("ltrim", new StandardSQLFunction("ltrim"));
        this.registerFunction("reverse", new StandardSQLFunction("reverse"));
        this.registerFunction("rtrim", new StandardSQLFunction("rtrim"));
        this.registerFunction("trim", new SQLFunctionTemplate(Hibernate.INTEGER, "ltrim(rtrim(?1))"));
        this.registerFunction("soundex", new StandardSQLFunction("soundex"));
        this.registerFunction("space", new StandardSQLFunction("space", Hibernate.STRING));
        this.registerFunction("ucase", new StandardSQLFunction("ucase"));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("acos", new StandardSQLFunction("acos", Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction("asin", Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction("cosh", Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction("cot", Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction("log10", Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction("pi", Hibernate.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction("rand", Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction("sinh", Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction("tan", Hibernate.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction("tanh", Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction("round"));
        this.registerFunction("trunc", new StandardSQLFunction("trunc"));
        this.registerFunction("ceil", new StandardSQLFunction("ceil"));
        this.registerFunction("floor", new StandardSQLFunction("floor"));
        this.registerFunction("chr", new StandardSQLFunction("chr", Hibernate.CHARACTER));
        this.registerFunction("initcap", new StandardSQLFunction("initcap"));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING, false));
        this.registerFunction("current_date", new NoArgSQLFunction("current_date", Hibernate.DATE, false));
        this.registerFunction("current_time", new NoArgSQLFunction("current_timestamp", Hibernate.TIME, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("current_timestamp", Hibernate.TIMESTAMP, false));
        this.registerFunction("curdate", new NoArgSQLFunction("curdate", Hibernate.DATE));
        this.registerFunction("curtime", new NoArgSQLFunction("curtime", Hibernate.TIME));
        this.registerFunction("days", new StandardSQLFunction("days", Hibernate.INTEGER));
        this.registerFunction("dayofmonth", new StandardSQLFunction("dayofmonth", Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction("dayname", Hibernate.STRING));
        this.registerFunction("dayofweek", new StandardSQLFunction("dayofweek", Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction("dayofyear", Hibernate.INTEGER));
        this.registerFunction("hour", new StandardSQLFunction("hour", Hibernate.INTEGER));
        this.registerFunction("last_day", new StandardSQLFunction("last_day", Hibernate.DATE));
        this.registerFunction("microsecond", new StandardSQLFunction("microsecond", Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction("minute", Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction("month", Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction("monthname", Hibernate.STRING));
        this.registerFunction("now", new NoArgSQLFunction("now", Hibernate.TIMESTAMP));
        this.registerFunction("quarter", new StandardSQLFunction("quarter", Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction("second", Hibernate.INTEGER));
        this.registerFunction("time", new StandardSQLFunction("time", Hibernate.TIME));
        this.registerFunction("timestamp", new StandardSQLFunction("timestamp", Hibernate.TIMESTAMP));
        this.registerFunction("week", new StandardSQLFunction("week", Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction("year", Hibernate.INTEGER));
        this.registerFunction("atan2", new StandardSQLFunction("atan2", Hibernate.DOUBLE));
        this.registerFunction("mod", new StandardSQLFunction("mod", Hibernate.INTEGER));
        this.registerFunction("nvl", new StandardSQLFunction("nvl"));
        this.registerFunction("power", new StandardSQLFunction("power", Hibernate.DOUBLE));
        this.registerColumnType(-7, "SMALLINT");
        this.registerColumnType(-6, "SMALLINT");
        this.registerColumnType(-5, "NUMERIC(21,0)");
        this.registerColumnType(5, "SMALLINT");
        this.registerColumnType(1, "CHARACTER(1)");
        this.registerColumnType(8, "DOUBLE PRECISION");
        this.registerColumnType(6, "FLOAT");
        this.registerColumnType(7, "REAL");
        this.registerColumnType(4, "INTEGER");
        this.registerColumnType(2, "NUMERIC(21,$l)");
        this.registerColumnType(3, "NUMERIC(21,$l)");
        this.registerColumnType(91, "DATE");
        this.registerColumnType(92, "TIME");
        this.registerColumnType(93, "TIMESTAMP");
        this.registerColumnType(12, "CHARACTER($l)");
        this.registerColumnType(2004, "BLOB($l)");
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean forUpdateOfColumns() {
        return false;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsUniqueConstraintInCreateAlterTable() {
        return true;
    }

    public boolean supportsCascadeDelete() {
        return false;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getNullColumnString() {
        return " null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select permuted_id('NEXT',31) from rdms.rdms_dummy where key_col = 1 ";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "";
    }

    public String getDropSequenceString(String sequenceName) {
        return "";
    }

    public String getCascadeConstraintsString() {
        return " including contents";
    }

    public CaseFragment createCaseFragment() {
        return new DecodeCaseFragment();
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getLimitString(String sql, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuffer(sql.length() + 40).append(sql).append(" fetch first ").append(limit).append(" rows only ").toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean supportsUnionAll() {
        return true;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode.greaterThan(LockMode.READ)) {
            return new UpdateLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }
}

