/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.util.RangeAddress;

public class HSSFName {
    private Workbook book;
    private NameRecord name;

    protected HSSFName(Workbook book, NameRecord name) {
        this.book = book;
        this.name = name;
    }

    public String getSheetName() {
        short indexToExternSheet = this.name.getExternSheetNumber();
        String result = this.book.findSheetNameFromExternSheet(indexToExternSheet);
        return result;
    }

    public String getNameName() {
        String result = this.name.getNameText();
        return result;
    }

    public void setNameName(String nameName) {
        this.name.setNameText(nameName);
        this.name.setNameTextLength((byte)nameName.length());
        for (int i = this.book.getNumNames() - 1; i >= 0; --i) {
            NameRecord rec = this.book.getNameRecord(i);
            if (rec == this.name || !rec.getNameText().equalsIgnoreCase(this.getNameName())) continue;
            throw new IllegalArgumentException("The workbook already contains this name (case-insensitive)");
        }
    }

    public String getReference() {
        String result = this.name.getAreaReference(this.book);
        return result;
    }

    private void setSheetName(String sheetName) {
        int sheetNumber = this.book.getSheetIndex(sheetName);
        short externSheetNumber = this.book.checkExternSheet(sheetNumber);
        this.name.setExternSheetNumber(externSheetNumber);
    }

    public void setReference(String ref) {
        RangeAddress ra = new RangeAddress(ref);
        String sheetName = ra.getSheetName();
        if (ra.hasSheetName()) {
            this.setSheetName(sheetName);
        }
        this.name.setAreaReference(ref);
    }
}

