/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.storage.ListManagedBlock;
import org.apache.poi.util.IOUtils;

public class RawDataBlock
implements ListManagedBlock {
    private byte[] _data;
    private boolean _eof;

    public RawDataBlock(InputStream stream) throws IOException {
        this(stream, 512);
    }

    public RawDataBlock(InputStream stream, int blockSize) throws IOException {
        this._data = new byte[blockSize];
        int count = IOUtils.readFully(stream, this._data);
        if (count == -1) {
            this._eof = true;
        } else {
            if (count != blockSize) {
                this._eof = true;
                String type = " byte" + (count == 1 ? "" : "s");
                throw new IOException("Unable to read entire block; " + count + type + " read before EOF; expected " + blockSize + " bytes");
            }
            this._eof = false;
        }
    }

    public boolean eof() throws IOException {
        return this._eof;
    }

    public byte[] getData() throws IOException {
        if (this.eof()) {
            throw new IOException("Cannot return empty data");
        }
        return this._data;
    }
}

