/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.wsqa.httpclient.FileParameter;
import org.exoplatform.wsqa.httpclient.HttpRequest;
import org.exoplatform.wsqa.httpclient.HttpRequestBody;
import org.exoplatform.wsqa.httpclient.HttpRequestHeader;
import org.exoplatform.wsqa.httpclient.HttpResponse;
import org.exoplatform.wsqa.httpclient.Parameter;
import org.exoplatform.wsqa.httpclient.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebUnit {
    private String name_;
    private String method_ = "GET";
    private String host_;
    private int port_;
    private String pathInfo_;
    private Map<String, Parameter> parameters_;
    private String contentType_;
    private String referer_;
    private Map<String, Parameter> bodyParameters_;
    private HttpRequest request_;
    private HttpResponse response_;
    private List<Validator> validators_;

    public WebUnit(String name) {
        this.name_ = name;
    }

    public WebUnit(HttpRequest request, HttpResponse response) {
        this.request_ = request;
        this.response_ = response;
        HttpRequestHeader headers = request.getHeaders();
        this.name_ = headers.getUri().getPathInfo();
        if (this.name_.length() > 60) {
            this.name_ = this.name_.substring(0, 60) + "...";
        }
        this.host_ = headers.getUri().getHost() + ":" + headers.getUri().getPort();
        this.method_ = headers.getMethod();
        this.pathInfo_ = headers.getUri().getPathInfo();
        this.parameters_ = headers.getUri().getCloneParameters();
        this.referer_ = headers.getReferer();
        if (this.method_.equals("POST")) {
            HttpRequestBody body = request.getRequestBody();
            this.contentType_ = body.getContentType();
            this.bodyParameters_ = body.getBodyParameters();
        }
    }

    public String getName() {
        return this.name_;
    }

    public WebUnit setName(String name) {
        this.name_ = name;
        return this;
    }

    public boolean isGETMethod() {
        return "GET".equals(this.method_);
    }

    public String getMethod() {
        return this.method_;
    }

    public WebUnit setMethod(String method) {
        this.method_ = method;
        return this;
    }

    public String getHost() {
        return this.host_;
    }

    public WebUnit setHost(String host) {
        this.host_ = host;
        return this;
    }

    public int getPort() {
        return this.port_;
    }

    public WebUnit setHost(int port) {
        this.port_ = port;
        return this;
    }

    public String getPathInfo() {
        return this.pathInfo_;
    }

    public WebUnit setPathInfo(String s) {
        this.pathInfo_ = s;
        return this;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public WebUnit setContentType(String s) {
        this.contentType_ = s;
        return this;
    }

    public String getReferer() {
        return this.referer_;
    }

    public WebUnit setReferer(String s) {
        this.referer_ = s;
        return this;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters_;
    }

    public WebUnit addParameter(String name, String value) {
        if (this.parameters_ == null) {
            this.parameters_ = new LinkedHashMap<String, Parameter>();
        }
        this.parameters_.put(name, new Parameter(name, value));
        return this;
    }

    public Map<String, Parameter> getBodyParameters() {
        return this.bodyParameters_;
    }

    public WebUnit addBodyParameter(String name, String value) {
        if (this.bodyParameters_ == null) {
            this.bodyParameters_ = new LinkedHashMap<String, Parameter>();
        }
        this.bodyParameters_.put(name, new Parameter(name, value));
        return this;
    }

    public WebUnit addBodyFileParameter(String name, String filename, String filetype, Object value) {
        if (this.bodyParameters_ == null) {
            this.bodyParameters_ = new LinkedHashMap<String, Parameter>();
        }
        this.bodyParameters_.put(name, new FileParameter(name, filename, filetype, value));
        return this;
    }

    public List<Validator> getValidators() {
        return this.validators_;
    }

    public WebUnit addValidator(Validator validator) {
        if (this.validators_ == null) {
            this.validators_ = new ArrayList<Validator>();
        }
        this.validators_.add(validator);
        return this;
    }

    public HttpRequest getHttpRequest() {
        return this.request_;
    }

    public HttpResponse getHttpResponse() {
        return this.response_;
    }
}

