/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.web.application.Application;
import org.exoplatform.web.application.ApplicationLifecycle;
import org.exoplatform.web.application.RequestFailure;
import org.exoplatform.webui.application.WebuiRequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileLifecycle
implements ApplicationLifecycle<WebuiRequestContext> {
    public static final String USER_PROFILE_ATTRIBUTE_NAME = "PortalUserProfile";
    private final ThreadLocal<UserProfile> currentUserProfile = new ThreadLocal();

    public void onInit(Application app) {
    }

    public void onStartRequest(Application app, WebuiRequestContext context) throws Exception {
        ExoContainer exoContainer;
        String user = context.getRemoteUser();
        UserProfile userProfile = null;
        if (user != null && (exoContainer = app.getApplicationServiceContainer()) != null) {
            OrganizationService organizationService = (OrganizationService)exoContainer.getComponentInstanceOfType(OrganizationService.class);
            userProfile = organizationService.getUserProfileHandler().findUserProfileByName(user);
        }
        this.currentUserProfile.set(userProfile);
        context.setAttribute(USER_PROFILE_ATTRIBUTE_NAME, userProfile);
    }

    public void onFailRequest(Application app, WebuiRequestContext context, RequestFailure failureType) throws Exception {
    }

    public void onEndRequest(Application app, WebuiRequestContext context) throws Exception {
        this.currentUserProfile.remove();
    }

    public void onDestroy(Application app) {
    }
}

