/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.SessionLifecycleListener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;

public class SessionProvider
implements SessionLifecycleListener {
    public static final String SESSION_PROVIDER = "JCRsessionProvider";
    private final Map<String, ExtendedSession> cache;
    private boolean isSystem;
    private ManageableRepository currentRepository;
    private String currentWorkspace;
    private boolean closed;

    public SessionProvider(ConversationState userState) {
        this(false);
        if (userState.getAttribute(SESSION_PROVIDER) == null) {
            userState.setAttribute(SESSION_PROVIDER, (Object)this);
        }
    }

    private SessionProvider(boolean isSystem) {
        this.isSystem = isSystem;
        this.cache = new HashMap<String, ExtendedSession>();
        this.closed = false;
    }

    public static SessionProvider createSystemProvider() {
        return new SessionProvider(true);
    }

    public static SessionProvider createAnonimProvider() {
        Identity id = new Identity(SystemIdentity.ANONIM, new HashSet());
        return new SessionProvider(new ConversationState(id));
    }

    public synchronized Session getSession(String workspaceName, ManageableRepository repository) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        if (this.closed) {
            throw new IllegalStateException("Session provider already closed");
        }
        if (workspaceName == null) {
            throw new NullPointerException("Workspace Name is null");
        }
        ExtendedSession session = this.cache.get(this.key(repository, workspaceName));
        if (session == null) {
            session = !this.isSystem ? (ExtendedSession)repository.login(workspaceName) : (ExtendedSession)repository.getSystemSession(workspaceName);
            session.registerLifecycleListener((SessionLifecycleListener)this);
            this.cache.put(this.key(repository, workspaceName), session);
        }
        return session;
    }

    public synchronized void close() {
        if (this.closed) {
            throw new IllegalStateException("Session provider already closed");
        }
        this.closed = true;
        for (ExtendedSession session : this.cache.values().toArray(new ExtendedSession[this.cache.values().size()])) {
            session.logout();
        }
        this.cache.clear();
    }

    public synchronized void onCloseSession(ExtendedSession session) {
        this.cache.remove(this.key((ManageableRepository)session.getRepository(), session.getWorkspace().getName()));
    }

    private String key(ManageableRepository repository, String workspaceName) {
        String repositoryName = repository.getConfiguration().getName();
        return repositoryName + workspaceName;
    }

    public ManageableRepository getCurrentRepository() {
        return this.currentRepository;
    }

    public String getCurrentWorkspace() {
        return this.currentWorkspace;
    }

    public void setCurrentRepository(ManageableRepository currentRepository) {
        this.currentRepository = currentRepository;
    }

    public void setCurrentWorkspace(String currentWorkspace) {
        this.currentWorkspace = currentWorkspace;
    }
}

