/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.ecm.webui.form.validator.CronExpressionValidator;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.form.validator.RepeatCountValidator;
import org.exoplatform.ecm.webui.form.validator.RepeatIntervalValidator;
import org.exoplatform.ecm.webui.form.validator.XSSValidator;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NullFieldValidator;
import org.exoplatform.webui.form.validator.NumberFormatValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogFormUtil {
    public static String VALIDATOR_PARAM_BEGIN = "(";
    public static String VALIDATOR_PARAM_END = ")";
    public static String VALIDATOR_PARAM_SEPERATOR = ";";
    public static String SANITIZATION_FLAG = "noSanitization";
    public static String TYPE_FLOAT = "Float";
    public static String TYPE_DOUBLE = "Double";
    public static String TYPE_INTEGER = "Int";
    public static String TYPE_STRING = "String";

    public static Map<String, JcrInputProperty> prepareMap(List inputs, Map properties) throws Exception {
        return DialogFormUtil.prepareMap(inputs, properties, null);
    }

    public static Map<String, JcrInputProperty> prepareMap(List inputs, Map properties, Map options) throws Exception {
        HashMap<String, JcrInputProperty> rawinputs = new HashMap<String, JcrInputProperty>();
        HashMap<String, JcrInputProperty> hasMap = new HashMap<String, JcrInputProperty>();
        String inputName = null;
        String mimeTypeJcrPath = null;
        InputStream inputStream = null;
        Object content = null;
        HashMap<String, JcrInputProperty> mimeTypes = new HashMap<String, JcrInputProperty>();
        for (int i = 0; i < inputs.size(); ++i) {
            JcrInputProperty property = null;
            String option = null;
            if (inputs.get(i) instanceof UIFormMultiValueInputSet) {
                inputName = ((UIFormMultiValueInputSet)inputs.get(i)).getName();
                if (!hasMap.containsKey(inputName)) {
                    List values = ((UIFormMultiValueInputSet)inputs.get(i)).getValue();
                    property = (JcrInputProperty)properties.get(inputName);
                    if (property != null) {
                        property.setValue((Object)values.toArray(new String[values.size()]));
                    }
                }
                hasMap.put(inputName, property);
                continue;
            }
            UIFormInputBase input = (UIFormInputBase)inputs.get(i);
            property = (JcrInputProperty)properties.get(input.getName());
            if (options != null && options.get(input.getName()) != null) {
                option = (String)options.get(input.getName());
            }
            if (property == null) continue;
            if (input instanceof UIFormUploadInput) {
                UploadResource uploadResource = ((UIFormUploadInput)input).getUploadResource();
                if (uploadResource == null) continue;
                String location = uploadResource.getStoreLocation();
                byte[] uploadData = IOUtil.getFileContentAsBytes((String)location);
                property.setValue((Object)uploadData);
                mimeTypeJcrPath = property.getJcrPath().replace("jcr:data", "jcr:mimeType");
                JcrInputProperty mimeTypeInputPropertyTmp = new JcrInputProperty();
                mimeTypeInputPropertyTmp.setJcrPath(mimeTypeJcrPath);
                mimeTypeInputPropertyTmp.setValue((Object)((UIFormUploadInput)input).getUploadResource().getMimeType());
                mimeTypes.put(mimeTypeJcrPath, mimeTypeInputPropertyTmp);
                continue;
            }
            if (input instanceof UIFormDateTimeInput) {
                property.setValue((Object)((UIFormDateTimeInput)input).getCalendar());
                continue;
            }
            if (input instanceof UIFormSelectBox) {
                UIFormSelectBox uiSelectBox = (UIFormSelectBox)input;
                if (!uiSelectBox.isMultiple()) {
                    property.setValue(uiSelectBox.getValue());
                    continue;
                }
                property.setValue((Object)uiSelectBox.getSelectedValues());
                continue;
            }
            if (input instanceof UIFormCheckBoxInput) {
                property.setValue((Object)((UIFormCheckBoxInput)input).isChecked());
                continue;
            }
            if (input.getValue() != null) {
                String inputValue = input.getValue().toString().trim();
                boolean isEmpty = Utils.isEmptyContent(inputValue);
                if (isEmpty) {
                    inputValue = "";
                } else if (option == null || option.indexOf(SANITIZATION_FLAG) < 0) {
                    inputValue = Utils.sanitize(inputValue);
                }
                property.setValue((Object)inputValue);
                continue;
            }
            property.setValue(input.getValue());
        }
        for (JcrInputProperty property : properties.values()) {
            rawinputs.put(property.getJcrPath(), property);
        }
        for (String jcrPath : mimeTypes.keySet()) {
            if (rawinputs.containsKey(jcrPath)) continue;
            rawinputs.put(jcrPath, (JcrInputProperty)mimeTypes.get(jcrPath));
        }
        ArrayList<UIFormUploadInput> formUploadList = new ArrayList<UIFormUploadInput>();
        for (Object input : inputs) {
            if (input instanceof UIFormMultiValueInputSet) {
                UIFormMultiValueInputSet uiSet = (UIFormMultiValueInputSet)input;
                if (uiSet.getId() == null || !uiSet.getUIFormInputBase().equals(UIFormUploadInput.class) || !uiSet.getId().equals("attachment__")) continue;
                List list = uiSet.getChildren();
                for (UIComponent component : list) {
                    if (formUploadList.contains(component)) continue;
                    formUploadList.add((UIFormUploadInput)component);
                }
                continue;
            }
            if (!(input instanceof UIFormUploadInput) || formUploadList.contains(input)) continue;
            formUploadList.add((UIFormUploadInput)input);
        }
        if (formUploadList.size() > 0) {
            ArrayList<String> keyListToRemove = new ArrayList<String>();
            HashMap<String, JcrInputProperty> jcrPropertiesToAdd = new HashMap<String, JcrInputProperty>();
            for (String inputJCRKeyTmp : rawinputs.keySet()) {
                String inputJCRKey = inputJCRKeyTmp;
                if (!inputJCRKey.contains("attachment__")) continue;
                JcrInputProperty jcrInputProperty = (JcrInputProperty)rawinputs.get(inputJCRKey);
                for (UIFormUploadInput formUploadInput : formUploadList) {
                    JcrInputProperty newJcrInputProperty = DialogFormUtil.clone(jcrInputProperty);
                    if (formUploadInput == null || formUploadInput.getUploadResource() == null || formUploadInput.getUploadResource().getFileName() == null) continue;
                    String fileName = formUploadInput.getUploadResource().getFileName();
                    String newJCRPath = inputJCRKey.replace("attachment__", fileName);
                    newJcrInputProperty.setJcrPath(newJCRPath);
                    if (inputJCRKey.endsWith("attachment__")) {
                        newJcrInputProperty.setValue((Object)fileName);
                        JcrInputProperty mimeTypeInputPropertyTmp = new JcrInputProperty();
                        mimeTypeInputPropertyTmp.setJcrPath(newJCRPath + "/jcr:content/jcr:mimeType");
                        mimeTypeInputPropertyTmp.setValue((Object)formUploadInput.getUploadResource().getMimeType());
                        jcrPropertiesToAdd.put(mimeTypeInputPropertyTmp.getJcrPath(), mimeTypeInputPropertyTmp);
                    }
                    if (inputJCRKey.endsWith("jcr:data")) {
                        inputStream = formUploadInput.getUploadDataAsStream();
                        newJcrInputProperty.setValue((Object)inputStream);
                    }
                    jcrPropertiesToAdd.put(newJCRPath, newJcrInputProperty);
                }
                keyListToRemove.add(inputJCRKey);
                keyListToRemove.add(inputJCRKey.replace("jcr:data", "jcr:mimeType"));
            }
            for (String keyToRemove : keyListToRemove) {
                rawinputs.remove(keyToRemove);
            }
            rawinputs.putAll(jcrPropertiesToAdd);
        }
        return rawinputs;
    }

    private static JcrInputProperty clone(JcrInputProperty fileNodeInputProperty) {
        JcrInputProperty jcrInputProperty = new JcrInputProperty();
        jcrInputProperty.setJcrPath(fileNodeInputProperty.getJcrPath());
        jcrInputProperty.setMixintype(fileNodeInputProperty.getMixintype());
        jcrInputProperty.setNodetype(fileNodeInputProperty.getNodetype());
        jcrInputProperty.setType(fileNodeInputProperty.getType());
        jcrInputProperty.setValue(fileNodeInputProperty.getValue());
        jcrInputProperty.setValueType(fileNodeInputProperty.getValueType());
        return jcrInputProperty;
    }

    public static <T extends UIFormInputBase> T createFormInput(Class<T> type, String name, String label, String validateType, Class valueType) throws Exception {
        Object[] args = new Object[]{name, null, valueType};
        UIFormInputBase formInput = (UIFormInputBase)type.getConstructor(new Class[0]).newInstance(args);
        DialogFormUtil.addValidators(formInput, validateType);
        if (label != null && label.length() != 0) {
            formInput.setLabel(label);
        }
        return (T)((UIFormInputBase)type.cast(formInput));
    }

    public static String getPropertyValueAsString(Node node, String propertyName) throws Exception {
        Property property = null;
        try {
            property = node.getProperty(propertyName);
        }
        catch (PathNotFoundException e) {
            return "";
        }
        int valueType = property.getType();
        switch (valueType) {
            case 1: {
                return property.getString();
            }
            case 3: {
                return Long.toString(property.getLong());
            }
            case 4: {
                return Double.toString(property.getDouble());
            }
            case 5: {
                return property.getDate().getTime().toString();
            }
            case 6: {
                return Boolean.toString(property.getBoolean());
            }
            case 7: {
                return property.getName();
            }
        }
        return "";
    }

    public static Class getValidator(String validatorType) throws ClassNotFoundException {
        if (validatorType.equals("name")) {
            return ECMNameValidator.class;
        }
        if (validatorType.equals("email")) {
            return EmailAddressValidator.class;
        }
        if (validatorType.equals("number")) {
            return NumberFormatValidator.class;
        }
        if (validatorType.equals("empty")) {
            return MandatoryValidator.class;
        }
        if (validatorType.equals("null")) {
            return NullFieldValidator.class;
        }
        if (validatorType.equals("datetime")) {
            return DateTimeValidator.class;
        }
        if (validatorType.equals("cronExpressionValidator")) {
            return CronExpressionValidator.class;
        }
        if (validatorType.equals("repeatCountValidator")) {
            return RepeatCountValidator.class;
        }
        if (validatorType.equals("repeatIntervalValidator")) {
            return RepeatIntervalValidator.class;
        }
        if (validatorType.equals("length")) {
            return StringLengthValidator.class;
        }
        if (validatorType.equals("XSSValidator")) {
            return XSSValidator.class;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.loadClass(validatorType);
    }

    public static void addValidators(UIFormInputBase uiInput, String validators) throws Exception {
        String[] validatorList = null;
        validatorList = validators.indexOf(44) > -1 ? validators.split(",") : new String[]{validators};
        for (String validator : validatorList) {
            String s_param = null;
            int p_begin = validator.indexOf(VALIDATOR_PARAM_BEGIN);
            int p_end = validator.indexOf(VALIDATOR_PARAM_END);
            if (p_begin > 0 && p_end > p_begin) {
                s_param = validator.substring(p_begin + 1, p_end);
                Object[] params = s_param.split(VALIDATOR_PARAM_SEPERATOR);
                params = DialogFormUtil.parserValidatorParam(params, params.length - 1, params[params.length - 1].toString());
                String v_name = validator.substring(0, p_begin);
                uiInput.addValidator(DialogFormUtil.getValidator(v_name.trim()), params);
                continue;
            }
            uiInput.addValidator(DialogFormUtil.getValidator(validator.trim()), new Object[0]);
        }
    }

    public static Object[] parserValidatorParam(Object[] params, int length, String type) throws Exception {
        if (length < 1) {
            return params;
        }
        Object[] newParams = new Object[length];
        if (type.equalsIgnoreCase(TYPE_INTEGER)) {
            for (int i = 0; i < length; ++i) {
                newParams[i] = Integer.parseInt(params[i].toString());
            }
        } else if (type.equalsIgnoreCase(TYPE_FLOAT)) {
            for (int i = 0; i < length; ++i) {
                newParams[i] = Float.valueOf(Float.parseFloat(params[i].toString()));
            }
        } else if (type.equalsIgnoreCase(TYPE_DOUBLE)) {
            for (int i = 0; i < length; ++i) {
                newParams[i] = Double.parseDouble(params[i].toString());
            }
        } else {
            return params;
        }
        return newParams;
    }
}

