/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chromattic.metamodel.mapping.NodeTypeMapping;
import org.chromattic.metamodel.typegen.NodeDefinition;
import org.chromattic.metamodel.typegen.PropertyDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeType {
    final NodeTypeMapping mapping;
    final Map<String, NodeDefinition> children;
    final Map<String, PropertyDefinition> properties;
    final Set<NodeType> superTypes;

    NodeType(NodeTypeMapping mapping) {
        this.mapping = mapping;
        this.children = new HashMap<String, NodeDefinition>();
        this.properties = new HashMap<String, PropertyDefinition>();
        this.superTypes = new HashSet<NodeType>();
    }

    public boolean isOrderable() {
        return this.mapping.isOrderable();
    }

    public Collection<NodeType> getSuperTypes() {
        return this.superTypes;
    }

    public PropertyDefinition getPropertyDefinition(String propertyName) {
        return this.properties.get(propertyName);
    }

    public Map<String, PropertyDefinition> getPropertyDefinitions() {
        return this.properties;
    }

    public String getName() {
        return this.mapping.getTypeName();
    }

    public boolean isMixin() {
        return this.mapping.isMixin();
    }

    public boolean isPrimary() {
        return this.mapping.isPrimary();
    }

    public Map<String, NodeDefinition> getChildNodeDefinitions() {
        return this.children;
    }

    public NodeDefinition getChildNodeDefinition(String childNodeName) {
        return this.children.get(childNodeName);
    }

    void addChildNodeType(String childNodeName, NodeTypeMapping childNodeTypeMapping) {
        NodeDefinition nodeDefinition = this.children.get(childNodeName);
        if (nodeDefinition == null) {
            nodeDefinition = new NodeDefinition(childNodeName);
            this.children.put(childNodeName, nodeDefinition);
        }
        nodeDefinition.mappings.add(childNodeTypeMapping);
    }
}

