/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import com.install4j.runtime.util.CustomLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;

public class HyperlinkLabel
extends CustomLabel
implements MouseListener {
    private static final Color COLOR_PASSIVE = Color.blue;
    private static final Color COLOR_ACTIVE = Color.red;
    private Action action;
    private boolean override;
    private static Color passiveColor = COLOR_PASSIVE;
    private static Color activeColor = COLOR_ACTIVE;

    public static void setPassiveColor(Color color) {
        passiveColor = color;
    }

    public static void setActiveColor(Color color) {
        activeColor = color;
    }

    public HyperlinkLabel(Action action) {
        this((String)action.getValue("Name"), action);
    }

    public HyperlinkLabel(String string, Action action) {
        super(string);
        this.action = action;
        this.setupComponent();
        this.setupEventHandlers();
        this.changeState(action.isEnabled());
    }

    public void setEnabled(boolean bl) {
        this.override = true;
        this.changeState(bl);
    }

    public void clearOverride() {
        this.override = false;
        this.changeState(this.action.isEnabled());
    }

    public Action getAction() {
        return this.action;
    }

    private void setupComponent() {
        this.setUnderlined(true);
        this.setForeground(passiveColor);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    private void setupEventHandlers() {
        this.action.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("enabled") && !HyperlinkLabel.this.override) {
                    HyperlinkLabel.this.changeState((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    private void changeState(boolean bl) {
        this.setUnderlined(bl);
        if (bl) {
            this.addMouseListener(this);
        } else {
            this.removeMouseListener(this);
        }
        super.setEnabled(bl);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.setForeground(activeColor);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        this.setForeground(passiveColor);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        if (this.action != null && this.action.isEnabled()) {
            this.action.actionPerformed(new ActionEvent(this, 0, null));
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

