/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.desktop.internal.impl;

import org.jdesktop.jdic.desktop.internal.impl.WinBrowserService;
import org.jdesktop.jdic.desktop.internal.impl.WinLaunchService;
import org.jdesktop.jdic.desktop.internal.impl.WinMapiMailer;
import org.jdesktop.jdic.desktop.internal.impl.WinMozMailer;
import org.jdesktop.jdic.desktop.internal.impl.WinUtility;

public class ServiceManagerStub {
    private ServiceManagerStub() {
    }

    public static Object getService(String string) throws IllegalArgumentException {
        if (string.equals("LaunchService")) {
            return new WinLaunchService();
        }
        if (string.equals("BrowserService")) {
            return new WinBrowserService();
        }
        if (string.equals("MailerService")) {
            String string2 = WinUtility.getDefaultMailer();
            if (string2.equalsIgnoreCase("Mozilla") || string2.equalsIgnoreCase("Mozilla Thunderbird")) {
                String string3 = WinUtility.getMozMailerLocation(string2);
                return new WinMozMailer(string3);
            }
            if ((string2.equalsIgnoreCase("Microsoft Outlook") || string2.equalsIgnoreCase("Outlook Express")) && WinUtility.isMapiSupported()) {
                return new WinMapiMailer();
            }
            throw new UnsupportedOperationException("Current system default mailer is not supported.");
        }
        throw new IllegalArgumentException("The requested service is not supported.");
    }
}

