/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.application;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.servlet.http.Cookie;
import org.exoplatform.commons.utils.Text;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.portlet.PortletExceptionHandleService;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ApplicationResourceResolver;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.portletcontainer.PortletContainerException;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.lifecycle.Lifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.exception.MessageException;
import org.gatein.common.util.MultiValuedPropertyMap;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.RenderInvocation;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIPortletLifecycle<S, C extends Serializable, I>
extends Lifecycle<UIPortlet<S, C>> {
    protected static Log log = ExoLogger.getLogger((String)"portal:UIPortletLifecycle");

    public void processAction(UIPortlet<S, C> uicomponent, WebuiRequestContext context) throws Exception {
        try {
            String portletActionType;
            Event event;
            String windowState;
            Event event2;
            String action = context.getRequestParameter("portal:action");
            if (action != null) {
                Event event3 = uicomponent.createEvent(action, Event.Phase.PROCESS, context);
                if (event3 != null) {
                    event3.broadcast();
                }
                return;
            }
            String portletMode = context.getRequestParameter("portal:portletMode");
            if (portletMode != null && (event2 = uicomponent.createEvent("ChangePortletMode", Event.Phase.PROCESS, context)) != null) {
                event2.broadcast();
            }
            if ((windowState = context.getRequestParameter("portal:windowState")) != null && (event = uicomponent.createEvent("ChangeWindowState", Event.Phase.PROCESS, context)) != null) {
                event.broadcast();
            }
            if ((portletActionType = context.getRequestParameter("portal:type")) != null) {
                Event event4;
                if (portletActionType.equals("action")) {
                    Event event5 = uicomponent.createEvent("ProcessAction", Event.Phase.PROCESS, context);
                    if (event5 != null) {
                        event5.broadcast();
                    }
                } else if (portletActionType.equals("resource") && (event4 = uicomponent.createEvent("ServeResource", Event.Phase.PROCESS, context)) != null) {
                    event4.broadcast();
                }
            } else {
                Event event6 = uicomponent.createEvent("Render", Event.Phase.PROCESS, context);
                if (event6 != null) {
                    event6.broadcast();
                }
            }
            context.addUIComponentToUpdateByAjax(uicomponent);
        }
        catch (Exception e) {
            String message = e.getLocalizedMessage();
            log.error((Object)("Error processing the action: " + message), (Throwable)e);
            Object[] args = new Object[]{message};
            context.addUIComponentToUpdateByAjax(uicomponent);
            throw new MessageException(new ApplicationMessage("UIPortletLifecycle.msg.process-error", args, 0));
        }
    }

    public void processRender(UIPortlet<S, C> uicomponent, WebuiRequestContext context) throws Exception {
        PortalRequestContext prcontext = (PortalRequestContext)context;
        ExoContainer container = prcontext.getApplication().getApplicationServiceContainer();
        Text markup = null;
        try {
            Map paramMap = prcontext.getRequest().getParameterMap();
            if (paramMap.containsKey("removePP")) {
                UIPortal uiPortal = Util.getUIPortal();
                for (String publicParamName : (String[])paramMap.get("removePP")) {
                    uiPortal.getPublicParameters().remove(publicParamName);
                }
            }
            RenderInvocation renderInvocation = uicomponent.create(RenderInvocation.class, prcontext);
            String appStatus = (String)uicomponent.getProperties().get((Object)"appStatus");
            if ("Window".equals(uicomponent.getPortletStyle()) && !"SHOW".equals(appStatus) && !"HIDE".equals(appStatus)) {
                markup = Text.create((String)"<span></span>");
            } else {
                int portalMode = Util.getUIPortalApplication().getModeState();
                if ((portalMode == 0 || portalMode == 2 || portalMode == 4 || uicomponent.getCurrentPortletMode().equals((Object)PortletMode.EDIT)) && uicomponent.hasPermission()) {
                    PortletInvocationResponse response = uicomponent.invoke((PortletInvocation)renderInvocation);
                    if (response instanceof FragmentResponse) {
                        FragmentResponse fragmentResponse = (FragmentResponse)response;
                        switch (fragmentResponse.getType()) {
                            case 1: {
                                markup = Text.create((String)fragmentResponse.getContent());
                                break;
                            }
                            case 2: {
                                markup = Text.create((byte[])fragmentResponse.getBytes(), (Charset)Charset.forName("UTF-8"));
                                break;
                            }
                            case 0: {
                                markup = Text.create((String)"");
                            }
                        }
                        uicomponent.setConfiguredTitle(fragmentResponse.getTitle());
                        if (fragmentResponse.getProperties() != null) {
                            MultiValuedPropertyMap markupHeaders;
                            List markupElements;
                            if (fragmentResponse.getProperties().getTransportHeaders() != null) {
                                MultiValuedPropertyMap transportHeaders = fragmentResponse.getProperties().getTransportHeaders();
                                for (String key : transportHeaders.keySet()) {
                                    for (String value : transportHeaders.getValues(key)) {
                                        prcontext.getResponse().setHeader(key, value);
                                    }
                                }
                            }
                            if (fragmentResponse.getProperties().getCookies() != null) {
                                List cookies = fragmentResponse.getProperties().getCookies();
                                for (Cookie cookie : cookies) {
                                    prcontext.getResponse().addCookie(cookie);
                                }
                            }
                            if (fragmentResponse.getProperties().getMarkupHeaders() != null && (markupElements = (markupHeaders = fragmentResponse.getProperties().getMarkupHeaders()).getValues("javax.portlet.markup.head.element")) != null) {
                                for (Element element : markupElements) {
                                    if ("title".equals(element.getNodeName().toLowerCase()) && element.getFirstChild() != null) {
                                        String title = element.getFirstChild().getTextContent();
                                        prcontext.getRequest().setAttribute(PortalRequestContext.REQUEST_TITLE, (Object)title);
                                        continue;
                                    }
                                    prcontext.addExtraMarkupHeader(element);
                                }
                            }
                        }
                    } else {
                        PortletContainerException pcException;
                        if (response instanceof ErrorResponse) {
                            ErrorResponse errorResponse = (ErrorResponse)response;
                            pcException = new PortletContainerException(errorResponse.getMessage(), errorResponse.getCause());
                        } else {
                            pcException = new PortletContainerException("Unknown invocation response type [" + response.getClass() + "]. Expected a FragmentResponse or an ErrorResponse");
                        }
                        PortletExceptionHandleService portletExceptionService = (PortletExceptionHandleService)uicomponent.getApplicationComponent(PortletExceptionHandleService.class);
                        if (portletExceptionService != null) {
                            portletExceptionService.handle(pcException);
                        }
                        log.error((Object)"Portlet render threw an exception", (Throwable)pcException);
                        markup = Text.create((String)context.getApplicationResourceBundle().getString("UIPortlet.message.RuntimeError"));
                    }
                }
            }
        }
        catch (Exception e) {
            PortletContainerException pcException = new PortletContainerException((Throwable)e);
            PortletExceptionHandleService portletExceptionService = (PortletExceptionHandleService)uicomponent.getApplicationComponent(PortletExceptionHandleService.class);
            if (portletExceptionService != null) {
                portletExceptionService.handle(pcException);
            }
            log.error((Object)"Portlet render threw an exception", (Throwable)pcException);
            markup = Text.create((String)context.getApplicationResourceBundle().getString("UIPortlet.message.RuntimeError"));
        }
        if (context.useAjax() && !prcontext.getFullRender()) {
            if (markup != null) {
                markup.writeTo(prcontext.getWriter());
            }
        } else {
            WebuiApplication app = (WebuiApplication)prcontext.getApplication();
            ApplicationResourceResolver resolver = app.getResourceResolver();
            WebuiBindingContext bcontext = new WebuiBindingContext((ResourceResolver)resolver, context.getWriter(), uicomponent, (WebuiRequestContext)prcontext);
            bcontext.put((Object)"uicomponent", uicomponent);
            bcontext.put((Object)"portletContent", (Object)markup);
            try {
                this.renderTemplate(uicomponent.getTemplate(), bcontext);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

