/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands;

import java.util.List;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.packet.AdHocCommandData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AdHocCommand {
    private AdHocCommandData data = new AdHocCommandData();

    public static SpecificErrorCondition getSpecificErrorCondition(XMPPError error) {
        for (SpecificErrorCondition condition : SpecificErrorCondition.values()) {
            if (error.getExtension(condition.toString(), "http://jabber.org/protocol/commands") == null) continue;
            return condition;
        }
        return null;
    }

    public void setName(String name) {
        this.data.setName(name);
    }

    public String getName() {
        return this.data.getName();
    }

    public void setNode(String node) {
        this.data.setNode(node);
    }

    public String getNode() {
        return this.data.getNode();
    }

    public abstract String getOwnerJID();

    public List<AdHocCommandNote> getNotes() {
        return this.data.getNotes();
    }

    protected void addNote(AdHocCommandNote note) {
        this.data.addNote(note);
    }

    public Form getForm() {
        if (this.data.getForm() == null) {
            return null;
        }
        return new Form(this.data.getForm());
    }

    protected void setForm(Form form) {
        this.data.setForm(form.getDataFormToSend());
    }

    public abstract void execute() throws XMPPException;

    public abstract void next(Form var1) throws XMPPException;

    public abstract void complete(Form var1) throws XMPPException;

    public abstract void prev() throws XMPPException;

    public abstract void cancel() throws XMPPException;

    protected List<Action> getActions() {
        return this.data.getActions();
    }

    protected void addActionAvailable(Action action) {
        this.data.addAction(action);
    }

    protected Action getExecuteAction() {
        return this.data.getExecuteAction();
    }

    protected void setExecuteAction(Action action) {
        this.data.setExecuteAction(action);
    }

    public Status getStatus() {
        return this.data.getStatus();
    }

    void setData(AdHocCommandData data) {
        this.data = data;
    }

    AdHocCommandData getData() {
        return this.data;
    }

    protected boolean isValidAction(Action action) {
        return this.getActions().contains((Object)action) || Action.cancel.equals((Object)action);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecificErrorCondition {
        badAction("bad-action"),
        malformedAction("malformed-action"),
        badLocale("bad-locale"),
        badPayload("bad-payload"),
        badSessionid("bad-sessionid"),
        sessionExpired("session-expired");

        private String value;

        private SpecificErrorCondition(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Action {
        execute,
        cancel,
        prev,
        next,
        complete,
        unknown;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        executing,
        completed,
        canceled;

    }
}

