/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.formats.tiff.JpegImageData;
import org.apache.sanselan.formats.tiff.TiffContents;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffHeader;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.constants.TiffConstants;
import org.apache.sanselan.util.Debug;

public class TiffReader
extends BinaryFileParser
implements TiffConstants {
    private final boolean strict;

    public TiffReader(boolean strict) {
        this.strict = strict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TiffHeader readTiffHeader(ByteSource byteSource, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            TiffHeader tiffHeader = this.readTiffHeader(is, formatCompliance);
            return tiffHeader;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    private TiffHeader readTiffHeader(InputStream is, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        byte BYTE_ORDER_1 = this.readByte("BYTE_ORDER_1", is, "Not a Valid TIFF File");
        byte BYTE_ORDER_2 = this.readByte("BYTE_ORDER_2", is, "Not a Valid TIFF File");
        this.setByteOrder(BYTE_ORDER_1, BYTE_ORDER_2);
        int tiffVersion = this.read2Bytes("tiffVersion", is, "Not a Valid TIFF File");
        if (tiffVersion != 42) {
            throw new ImageReadException("Unknown Tiff Version: " + tiffVersion);
        }
        int offsetToFirstIFD = this.read4Bytes("offsetToFirstIFD", is, "Not a Valid TIFF File");
        this.skipBytes(is, offsetToFirstIFD - 8, "Not a Valid TIFF File: couldn't find IFDs");
        if (this.debug) {
            System.out.println("");
        }
        return new TiffHeader(BYTE_ORDER_1, tiffVersion, offsetToFirstIFD);
    }

    private void readDirectories(ByteSource byteSource, FormatCompliance formatCompliance, Listener listener) throws ImageReadException, IOException {
        TiffHeader tiffHeader = this.readTiffHeader(byteSource, formatCompliance);
        if (!listener.setTiffHeader(tiffHeader)) {
            return;
        }
        int offset = tiffHeader.offsetToFirstIFD;
        int dirType = 0;
        ArrayList visited = new ArrayList();
        this.readDirectory(byteSource, offset, dirType, formatCompliance, listener, visited);
    }

    private boolean readDirectory(ByteSource byteSource, int offset, int dirType, FormatCompliance formatCompliance, Listener listener, List visited) throws ImageReadException, IOException {
        boolean ignoreNextDirectory = false;
        return this.readDirectory(byteSource, offset, dirType, formatCompliance, listener, ignoreNextDirectory, visited);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readDirectory(ByteSource byteSource, int offset, int dirType, FormatCompliance formatCompliance, Listener listener, boolean ignoreNextDirectory, List visited) throws ImageReadException, IOException {
        Integer key = new Integer(offset);
        if (visited.contains(key)) {
            return false;
        }
        visited.add(key);
        InputStream is = null;
        try {
            int entryCount;
            is = byteSource.getInputStream();
            if (offset > 0) {
                is.skip(offset);
            }
            ArrayList<TiffField> fields = new ArrayList<TiffField>();
            if ((long)offset >= byteSource.getLength()) {
                boolean bl = true;
                return bl;
            }
            try {
                entryCount = this.read2Bytes("DirectoryEntryCount", is, "Not a Valid TIFF File");
            }
            catch (IOException e) {
                if (this.strict) {
                    throw e;
                }
                boolean bl = true;
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e2) {
                    Debug.debug(e2);
                }
                return bl;
            }
            for (int i = 0; i < entryCount; ++i) {
                int tag = this.read2Bytes("Tag", is, "Not a Valid TIFF File");
                int type = this.read2Bytes("Type", is, "Not a Valid TIFF File");
                int length = this.read4Bytes("Length", is, "Not a Valid TIFF File");
                byte[] valueOffsetBytes = this.readByteArray("ValueOffset", 4, is, "Not a Valid TIFF File");
                int valueOffset = this.convertByteArrayToInt("ValueOffset", valueOffsetBytes);
                if (tag == 0) continue;
                TiffField field = new TiffField(tag, dirType, type, length, valueOffset, valueOffsetBytes, this.getByteOrder());
                field.setSortHint(i);
                field.fillInValue(byteSource);
                fields.add(field);
                if (listener.addField(field)) continue;
                boolean bl = true;
                return bl;
            }
            int nextDirectoryOffset = this.read4Bytes("nextDirectoryOffset", is, "Not a Valid TIFF File");
            TiffDirectory directory = new TiffDirectory(dirType, fields, offset, nextDirectoryOffset);
            if (listener.readImageData()) {
                if (directory.hasTiffImageData()) {
                    TiffImageData rawImageData = this.getTiffRawImageData(byteSource, directory);
                    directory.setTiffImageData(rawImageData);
                }
                if (directory.hasJpegImageData()) {
                    JpegImageData rawJpegImageData = this.getJpegRawImageData(byteSource, directory);
                    directory.setJpegImageData(rawJpegImageData);
                }
            }
            if (!listener.addDirectory(directory)) {
                boolean rawJpegImageData = true;
                return rawJpegImageData;
            }
            if (listener.readOffsetDirectories()) {
                ArrayList<TiffField> fieldsToRemove = new ArrayList<TiffField>();
                for (int j = 0; j < fields.size(); ++j) {
                    int subDirectoryType;
                    TiffField entry = (TiffField)fields.get(j);
                    if (entry.tag != TiffConstants.EXIF_TAG_EXIF_OFFSET.tag && entry.tag != TiffConstants.EXIF_TAG_GPSINFO.tag && entry.tag != TiffConstants.EXIF_TAG_INTEROP_OFFSET.tag) continue;
                    int subDirectoryOffset = ((Number)entry.getValue()).intValue();
                    if (entry.tag == TiffConstants.EXIF_TAG_EXIF_OFFSET.tag) {
                        subDirectoryType = -2;
                    } else if (entry.tag == TiffConstants.EXIF_TAG_GPSINFO.tag) {
                        subDirectoryType = -3;
                    } else if (entry.tag == TiffConstants.EXIF_TAG_INTEROP_OFFSET.tag) {
                        subDirectoryType = -4;
                    } else {
                        throw new ImageReadException("Unknown subdirectory type.");
                    }
                    boolean subDirectoryRead = this.readDirectory(byteSource, subDirectoryOffset, subDirectoryType, formatCompliance, listener, true, visited);
                    if (subDirectoryRead) continue;
                    fieldsToRemove.add(entry);
                }
                fields.removeAll(fieldsToRemove);
            }
            if (!ignoreNextDirectory && directory.nextDirectoryOffset > 0) {
                this.readDirectory(byteSource, directory.nextDirectoryOffset, dirType + 1, formatCompliance, listener, visited);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public TiffContents readFirstDirectory(ByteSource byteSource, Map params, boolean readImageData, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        FirstDirectoryCollector collector = new FirstDirectoryCollector(readImageData);
        this.read(byteSource, params, formatCompliance, collector);
        TiffContents contents = collector.getContents();
        if (contents.directories.size() < 1) {
            throw new ImageReadException("Image did not contain any directories.");
        }
        return contents;
    }

    public TiffContents readDirectories(ByteSource byteSource, boolean readImageData, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        FirstDirectoryCollector collector = new FirstDirectoryCollector(readImageData);
        this.readDirectories(byteSource, formatCompliance, collector);
        TiffContents contents = collector.getContents();
        if (contents.directories.size() < 1) {
            throw new ImageReadException("Image did not contain any directories.");
        }
        return contents;
    }

    public TiffContents readContents(ByteSource byteSource, Map params, FormatCompliance formatCompliance) throws ImageReadException, IOException {
        Collector collector = new Collector(params);
        this.read(byteSource, params, formatCompliance, collector);
        TiffContents contents = collector.getContents();
        return contents;
    }

    public void read(ByteSource byteSource, Map params, FormatCompliance formatCompliance, Listener listener) throws ImageReadException, IOException {
        this.readDirectories(byteSource, formatCompliance, listener);
    }

    private TiffImageData getTiffRawImageData(ByteSource byteSource, TiffDirectory directory) throws ImageReadException, IOException {
        ArrayList elements = directory.getTiffRawImageDataElements();
        TiffElement.DataElement[] data = new TiffImageData.Data[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            TiffDirectory.ImageDataElement element = (TiffDirectory.ImageDataElement)elements.get(i);
            byte[] bytes = byteSource.getBlock(element.offset, element.length);
            data[i] = new TiffImageData.Data(element.offset, element.length, bytes);
        }
        if (directory.imageDataInStrips()) {
            TiffField rowsPerStripField = directory.findField(TIFF_TAG_ROWS_PER_STRIP);
            if (null == rowsPerStripField) {
                throw new ImageReadException("Can't find rows per strip field.");
            }
            int rowsPerStrip = rowsPerStripField.getIntValue();
            return new TiffImageData.Strips(data, rowsPerStrip);
        }
        TiffField tileWidthField = directory.findField(TIFF_TAG_TILE_WIDTH);
        if (null == tileWidthField) {
            throw new ImageReadException("Can't find tile width field.");
        }
        int tileWidth = tileWidthField.getIntValue();
        TiffField tileLengthField = directory.findField(TIFF_TAG_TILE_LENGTH);
        if (null == tileLengthField) {
            throw new ImageReadException("Can't find tile length field.");
        }
        int tileLength = tileLengthField.getIntValue();
        return new TiffImageData.Tiles(data, tileWidth, tileLength);
    }

    private JpegImageData getJpegRawImageData(ByteSource byteSource, TiffDirectory directory) throws ImageReadException, IOException {
        TiffDirectory.ImageDataElement element = directory.getJpegRawImageDataElement();
        int offset = element.offset;
        int length = element.length;
        if ((long)(offset + length) == byteSource.getLength() + 1L) {
            --length;
        }
        byte[] data = byteSource.getBlock(offset, length);
        return new JpegImageData(offset, length, data);
    }

    private static class DirectoryCollector
    extends Collector {
        private final boolean readImageData;

        public DirectoryCollector(boolean readImageData) {
            this.readImageData = readImageData;
        }

        public boolean addDirectory(TiffDirectory directory) {
            super.addDirectory(directory);
            return false;
        }

        public boolean readImageData() {
            return this.readImageData;
        }
    }

    private static class FirstDirectoryCollector
    extends Collector {
        private final boolean readImageData;

        public FirstDirectoryCollector(boolean readImageData) {
            this.readImageData = readImageData;
        }

        public boolean addDirectory(TiffDirectory directory) {
            super.addDirectory(directory);
            return false;
        }

        public boolean readImageData() {
            return this.readImageData;
        }
    }

    private static class Collector
    implements Listener {
        private TiffHeader tiffHeader = null;
        private ArrayList directories = new ArrayList();
        private ArrayList fields = new ArrayList();
        private final boolean readThumbnails;

        public Collector() {
            this(null);
        }

        public Collector(Map params) {
            boolean readThumbnails = true;
            if (params != null && params.containsKey("READ_THUMBNAILS")) {
                readThumbnails = Boolean.TRUE.equals(params.get("READ_THUMBNAILS"));
            }
            this.readThumbnails = readThumbnails;
        }

        public boolean setTiffHeader(TiffHeader tiffHeader) {
            this.tiffHeader = tiffHeader;
            return true;
        }

        public boolean addDirectory(TiffDirectory directory) {
            this.directories.add(directory);
            return true;
        }

        public boolean addField(TiffField field) {
            this.fields.add(field);
            return true;
        }

        public boolean readImageData() {
            return this.readThumbnails;
        }

        public boolean readOffsetDirectories() {
            return true;
        }

        public TiffContents getContents() {
            return new TiffContents(this.tiffHeader, this.directories);
        }
    }

    public static interface Listener {
        public boolean setTiffHeader(TiffHeader var1);

        public boolean addDirectory(TiffDirectory var1);

        public boolean addField(TiffField var1);

        public boolean readImageData();

        public boolean readOffsetDirectories();
    }
}

