/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.context.WizardContext;
import com.install4j.runtime.dirchooser.DirectoryChooser;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class DirectorySelector
extends JPanel
implements AbstractFileSelector {
    private static final String BAD_CHARS = ":*?\"<>|" + (InstallerUtil.isWindows() ? "/" : "\\");
    private static File lastDirectory = null;
    private String standardDirectoryName;
    public boolean noStandardDirectoryNameForUpdate;
    private InternalValidator internalValidator;
    private WizardContext wizardContext;
    private JTextField txtDirectory;
    private JButton btnBrowse;
    private DirectoryChooser directoryChooser;
    private String directoryDescription;
    private boolean designTime;
    static /* synthetic */ Class class$java$awt$Window;

    public DirectorySelector(String string, boolean bl) {
        this.directoryDescription = string;
        this.designTime = bl;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setInternalValidator(InternalValidator internalValidator) {
        this.internalValidator = internalValidator;
    }

    public void activateNextScreenOnEnter(WizardContext wizardContext) {
        this.wizardContext = wizardContext;
    }

    public void setEnabled(boolean bl) {
        this.txtDirectory.setEnabled(bl);
        this.btnBrowse.setEnabled(bl);
    }

    public void initDirectory(File file, String string) {
        this.standardDirectoryName = string;
        this.txtDirectory.setText(this.getSuggestedPath(file));
    }

    public void setNoStandardDirectoryNameForUpdate(boolean bl) {
        this.noStandardDirectoryNameForUpdate = bl;
    }

    public void setSelectedFile(File file) {
        this.initDirectory(file, "");
    }

    public File getSelectedFile() {
        return new File(this.getSelectedDirectoryName());
    }

    public JTextField getTextField() {
        return this.txtDirectory;
    }

    public JButton getButton() {
        return this.btnBrowse;
    }

    public boolean checkSelectedDirectory() {
        File file;
        String string = this.getSelectedDirectoryName();
        Window window = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = DirectorySelector.class$("java.awt.Window")) : class$java$awt$Window, this);
        ResourceBundle resourceBundle = Messages.getMessages();
        if (string.length() == 0) {
            GUIHelper.showMessage(window, resourceBundle.getString("MustEnterDirectory"), 2);
            return false;
        }
        if (!new File(string).isAbsolute()) {
            GUIHelper.showMessage(window, MessageFormat.format(resourceBundle.getString("InvalidDirectory"), string), 2);
            return false;
        }
        if (!InstallerUtil.isWindows() && !InstallerUtil.isMacOS() && string.indexOf(32) > -1) {
            GUIHelper.showMessage(window, MessageFormat.format(resourceBundle.getString("NoDirNameWithSpace"), BAD_CHARS), 2);
            return false;
        }
        char[] cArray = BAD_CHARS.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            int n = string.indexOf(cArray[i]);
            if (n < 0 || cArray[i] == ':' && n == 1 && string.lastIndexOf(58) == n && InstallerUtil.isWindows()) continue;
            GUIHelper.showMessage(window, MessageFormat.format(resourceBundle.getString("BadDirName32"), BAD_CHARS), 2);
            return false;
        }
        try {
            file = new File(string).getCanonicalFile();
        }
        catch (IOException iOException) {
            GUIHelper.showMessage(window, MessageFormat.format(resourceBundle.getString("InvalidDirectory"), string), 2);
            return false;
        }
        if (this.internalValidator != null) {
            File file2 = this.internalValidator.validateInternally(file);
            if (file2 == null) {
                return false;
            }
            if (!file2.equals(file)) {
                this.setSelectedFile(file2);
            }
        }
        return true;
    }

    public void focusTextField() {
        this.txtDirectory.requestFocus();
        this.txtDirectory.setSelectionStart(0);
        this.txtDirectory.setSelectionEnd(this.txtDirectory.getDocument().getLength());
    }

    private void setupControls() {
        this.txtDirectory = new JTextField(" ");
        this.btnBrowse = new JButton(this.designTime ? "Browse ... " : Messages.getMessages().getString("ButtonBrowse"));
    }

    private void setupComponent() {
        if (this.directoryDescription != null) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.directoryDescription), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.txtDirectory, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.left = 5;
        this.add((Component)this.btnBrowse, gridBagConstraints);
    }

    private void setupEventHandlers() {
        if (this.designTime) {
            return;
        }
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectorySelector.this.doBrowse();
            }
        });
        KeyboardUtil.addAccelerator(0, this.txtDirectory, this.txtDirectory, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DirectorySelector.this.wizardContext != null) {
                    DirectorySelector.this.wizardContext.pressNextButton();
                }
            }
        }, 10, 0);
    }

    private void doBrowse() {
        File file;
        File file2;
        String string;
        ResourceBundle resourceBundle = Messages.getMessages();
        if (this.directoryChooser == null) {
            this.directoryChooser = new DirectoryChooser();
            this.directoryChooser.setTitle(resourceBundle.getString("SelectDirectory"));
            this.directoryChooser.setMultiSelectionEnabled(false);
        }
        if ((string = this.txtDirectory.getText()).trim().length() == 0) {
            if (lastDirectory == null) {
                lastDirectory = new File(System.getProperty("user.home"));
            }
            file2 = lastDirectory;
        } else {
            file2 = new File(string);
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!(file2.exists() && file2.isDirectory() || (file = this.directoryChooser.getFileSystemView().getParentDirectory(file2)) == null || file2.equals(file))) {
            file2 = file;
        }
        if (file2.exists() && file2.isDirectory()) {
            this.directoryChooser.setCurrentDirectory(file2);
        }
        if (this.directoryChooser.showDialog(this, resourceBundle.getString("ButtonOK"), resourceBundle.getString("ButtonCancel")) == 0) {
            file = this.directoryChooser.getSelectedFile();
            this.txtDirectory.setText(this.getSuggestedPath(file));
            lastDirectory = file;
        }
    }

    private String getSelectedDirectoryName() {
        String string = this.txtDirectory.getText().trim();
        if (new File(string).getParent() != null) {
            while (string.endsWith("\\") || string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private String getSuggestedPath(File file) {
        if (file.getPath().trim().length() == 0) {
            return "";
        }
        if (this.standardDirectoryName == null || this.standardDirectoryName.trim().length() == 0 || this.noStandardDirectoryNameForUpdate && ApplicationRegistry.isUpdateDirectory(file)) {
            return file.getPath();
        }
        return new File(file, this.standardDirectoryName).getPath();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface InternalValidator {
        public File validateInternally(File var1);
    }
}

