/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.html.parser;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.exoplatform.services.html.Group;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.MoveType;
import org.exoplatform.services.html.Name;
import org.exoplatform.services.html.NodeConfig;
import org.exoplatform.services.html.NodeConfigs;
import org.exoplatform.services.html.Tag;
import org.exoplatform.services.html.parser.NodeImpl;
import org.exoplatform.services.token.TypeToken;

@NodeConfigs(value={@NodeConfig(name=Name.A, type=Group.Special.class), @NodeConfig(name=Name.ABBR, type=Group.Phrase.class), @NodeConfig(name=Name.ACRONYM, type=Group.Phrase.class), @NodeConfig(name=Name.ADDRESS, type=Group.Block.class), @NodeConfig(name=Name.APPLET, type=Group.Special.class), @NodeConfig(name=Name.AREA, end=Tag.FORBIDDEN, type=Group.Default.class), @NodeConfig(name=Name.B, type=Group.Fontstyle.class), @NodeConfig(name=Name.BASE, end=Tag.FORBIDDEN, parent={Name.HEAD}, type=Group.HeadContent.class), @NodeConfig(name=Name.BASEFONT, end=Tag.FORBIDDEN, type=Group.Special.class), @NodeConfig(name=Name.BDO, type=Group.Special.class), @NodeConfig(name=Name.BIG, type=Group.Fontstyle.class), @NodeConfig(name=Name.BLOCKQUOTE, type=Group.Block.class), @NodeConfig(name=Name.BODY, start=Tag.OPTIONAL, end=Tag.OPTIONAL, parent={Name.HTML}, type=Group.HtmlContent.class, only=true), @NodeConfig(name=Name.BR, end=Tag.FORBIDDEN, type=Group.Special.class), @NodeConfig(name=Name.BUTTON, type=Group.Formctrl.class), @NodeConfig(name=Name.CAPTION, parent={Name.TABLE}, type=Group.Table.class), @NodeConfig(name=Name.CENTER, type=Group.Block.class), @NodeConfig(name=Name.CITE, type=Group.Phrase.class), @NodeConfig(name=Name.CODE, type=Group.Phrase.class), @NodeConfig(name=Name.COL, end=Tag.FORBIDDEN, parent={Name.COLGROUP}, type=Group.Default.class), @NodeConfig(name=Name.COLGROUP, end=Tag.OPTIONAL, parent={Name.TABLE}, children={Name.COL}, type=Group.Default.class), @NodeConfig(name=Name.DD, end=Tag.OPTIONAL, parent={Name.DL}, type=Group.Default.class, end_names={Name.DT, Name.DD}), @NodeConfig(name=Name.DEL, type=Group.Default.class), @NodeConfig(name=Name.DFN, type=Group.Phrase.class), @NodeConfig(name=Name.DIR, type=Group.List.class), @NodeConfig(name=Name.DIV, type=Group.Block.class), @NodeConfig(name=Name.DL, type=Group.Block.class), @NodeConfig(name=Name.DT, end=Tag.OPTIONAL, parent={Name.DL}, type=Group.Default.class, end_names={Name.DT}), @NodeConfig(name=Name.EM, type=Group.Phrase.class), @NodeConfig(name=Name.EMBED, end=Tag.FORBIDDEN, parent={Name.OBJECT}, type=Group.Default.class), @NodeConfig(name=Name.FIELDSET, type=Group.Block.class), @NodeConfig(name=Name.FONT, type=Group.Special.class), @NodeConfig(name=Name.FORM, hidden=true, type=Group.Block.class), @NodeConfig(name=Name.FRAME, end=Tag.FORBIDDEN, parent={Name.FRAMESET}, type=Group.Default.class), @NodeConfig(name=Name.FRAMESET, children={Name.FRAMESET, Name.FRAME, Name.NOFRAMES}, type=Group.Default.class), @NodeConfig(name=Name.H1, end=Tag.OPTIONAL, type=Group.Heading.class, end_types={Group.Heading.class}), @NodeConfig(name=Name.H2, end=Tag.OPTIONAL, type=Group.Heading.class, end_types={Group.Heading.class}), @NodeConfig(name=Name.H3, end=Tag.OPTIONAL, type=Group.Heading.class, end_types={Group.Heading.class}), @NodeConfig(name=Name.H4, end=Tag.OPTIONAL, type=Group.Heading.class, end_types={Group.Heading.class}), @NodeConfig(name=Name.H5, end=Tag.OPTIONAL, type=Group.Heading.class, end_types={Group.Heading.class}), @NodeConfig(name=Name.H6, end=Tag.OPTIONAL, type=Group.Heading.class, end_types={Group.Heading.class}), @NodeConfig(name=Name.HEAD, start=Tag.OPTIONAL, end=Tag.OPTIONAL, parent={Name.HTML}, children={Name.TITLE, Name.META, Name.LINK, Name.SCRIPT, Name.STYLE, Name.BASE}, type=Group.HtmlContent.class, only=true), @NodeConfig(name=Name.HR, end=Tag.FORBIDDEN, type=Group.Block.class), @NodeConfig(name=Name.HTML, start=Tag.OPTIONAL, end=Tag.OPTIONAL, children={Name.HEAD, Name.BODY}, type=Group.Default.class, only=true), @NodeConfig(name=Name.I, type=Group.Fontstyle.class), @NodeConfig(name=Name.IFRAME, type=Group.Special.class), @NodeConfig(name=Name.IMG, end=Tag.FORBIDDEN, type=Group.Special.class), @NodeConfig(name=Name.INPUT, end=Tag.FORBIDDEN, type=Group.Formctrl.class), @NodeConfig(name=Name.INS, type=Group.Default.class), @NodeConfig(name=Name.ISINDEX, end=Tag.FORBIDDEN, type=Group.Block.class), @NodeConfig(name=Name.KBD, type=Group.Phrase.class), @NodeConfig(name=Name.LABEL, type=Group.Formctrl.class), @NodeConfig(name=Name.LEGEND, parent={Name.FIELDSET}, type=Group.Default.class), @NodeConfig(name=Name.LI, end=Tag.OPTIONAL, type=Group.Flow.class, end_names={Name.LI}), @NodeConfig(name=Name.LINK, end=Tag.FORBIDDEN, parent={Name.HEAD}, type=Group.HeadMisc.class), @NodeConfig(name=Name.MAP, type=Group.Special.class), @NodeConfig(name=Name.MARQUEE, type=Group.Block.class), @NodeConfig(name=Name.MENU, type=Group.List.class), @NodeConfig(name=Name.META, end=Tag.FORBIDDEN, parent={Name.HEAD}, type=Group.HeadMisc.class), @NodeConfig(name=Name.NOBR, type=Group.Block.class), @NodeConfig(name=Name.NOFRAMES, parent={Name.FRAMESET}, type=Group.Block.class), @NodeConfig(name=Name.NOSCRIPT, type=Group.Block.class), @NodeConfig(name=Name.OBJECT, type=Group.Special.class), @NodeConfig(name=Name.OL, type=Group.List.class), @NodeConfig(name=Name.OPTGROUP, parent={Name.SELECT}, children={Name.OPTION}, type=Group.Table.class, move=MoveType.REMOVE), @NodeConfig(name=Name.OPTION, end=Tag.OPTIONAL, parent={Name.SELECT, Name.OPTGROUP}, type=Group.Default.class), @NodeConfig(name=Name.P, end=Tag.OPTIONAL, type=Group.Block.class, end_types={Group.Block.class, Group.Heading.class}), @NodeConfig(name=Name.PARAM, end=Tag.FORBIDDEN, parent={Name.OBJECT}, type=Group.Default.class), @NodeConfig(name=Name.PRE, type=Group.Preformatted.class), @NodeConfig(name=Name.Q, type=Group.Special.class), @NodeConfig(name=Name.S, type=Group.Fontstyle.class), @NodeConfig(name=Name.SAMP, type=Group.Phrase.class), @NodeConfig(name=Name.SCRIPT, type=Group.Special.class), @NodeConfig(name=Name.SELECT, children={Name.OPTION, Name.OPTGROUP}, type=Group.Formctrl.class, move=MoveType.REMOVE, block=true), @NodeConfig(name=Name.SMALL, type=Group.Fontstyle.class), @NodeConfig(name=Name.SPAN, type=Group.Special.class), @NodeConfig(name=Name.STRIKE, type=Group.Fontstyle.class), @NodeConfig(name=Name.STRONG, type=Group.Phrase.class), @NodeConfig(name=Name.STYLE, move=MoveType.HEADER, type=Group.HeadMisc.class), @NodeConfig(name=Name.SUB, type=Group.Special.class), @NodeConfig(name=Name.SUP, type=Group.Special.class), @NodeConfig(name=Name.TABLE, children={Name.TBODY, Name.THEAD, Name.TFOOT, Name.CAPTION, Name.COLGROUP}, type=Group.Block.class, block=true, move=MoveType.INSERT), @NodeConfig(name=Name.TBODY, start=Tag.OPTIONAL, end=Tag.OPTIONAL, parent={Name.TABLE}, children={Name.TR}, type=Group.Table.class, move=MoveType.INSERT), @NodeConfig(name=Name.TD, end=Tag.OPTIONAL, parent={Name.TR}, type=Group.Table.class), @NodeConfig(name=Name.TEXTAREA, type=Group.Formctrl.class), @NodeConfig(name=Name.TFOOT, end=Tag.OPTIONAL, parent={Name.TABLE}, children={Name.TR}, type=Group.Table.class, move=MoveType.INSERT), @NodeConfig(name=Name.TH, end=Tag.OPTIONAL, parent={Name.TR}, type=Group.Table.class), @NodeConfig(name=Name.THEAD, end=Tag.OPTIONAL, parent={Name.TABLE}, children={Name.TR}, type=Group.Table.class, move=MoveType.INSERT), @NodeConfig(name=Name.TITLE, move=MoveType.HEADER, type=Group.HeadContent.class), @NodeConfig(name=Name.TR, end=Tag.OPTIONAL, parent={Name.TBODY, Name.THEAD, Name.TFOOT}, children={Name.TD, Name.TH}, type=Group.Table.class, move=MoveType.INSERT), @NodeConfig(name=Name.TT, type=Group.Fontstyle.class), @NodeConfig(name=Name.U, type=Group.Fontstyle.class), @NodeConfig(name=Name.UL, type=Group.List.class), @NodeConfig(name=Name.VAR, type=Group.Phrase.class), @NodeConfig(name=Name.CONTENT, end=Tag.FORBIDDEN, type=Group.Default.class), @NodeConfig(name=Name.COMMENT, end=Tag.FORBIDDEN, type=Group.Default.class), @NodeConfig(name=Name.DOCTYPE, end=Tag.FORBIDDEN, type=Group.Default.class), @NodeConfig(name=Name.UNKNOWN, end=Tag.FORBIDDEN, type=Group.Default.class)})
public class HTML {
    public static SoftReference<NodeConfig[]> refConfig;
    private static HashMap<Name, NodeConfig> mapConfig;

    public static Name getName(String value) {
        Name name = null;
        try {
            name = Name.valueOf(value);
        }
        catch (Exception e) {
            return null;
        }
        return name;
    }

    public static NodeConfig getConfig(String value) {
        Name name = HTML.getName(value);
        if (name == null) {
            return null;
        }
        return HTML.getConfig(name);
    }

    public static NodeConfig getConfig(Name key) {
        NodeConfig config = mapConfig.get((Object)key);
        if (config != null) {
            return config;
        }
        if (refConfig == null || refConfig.get() == null) {
            HTML.loadNodeConfigs();
        }
        NodeConfig[] configs = refConfig.get();
        int low = 0;
        int high = configs.length - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            config = configs[mid];
            int cmp = config.name().compareTo(key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            config = configs[mid];
            mapConfig.put(key, config);
            return config;
        }
        return null;
    }

    private static void loadNodeConfigs() {
        NodeConfigs nodeConfigs = HTML.class.getAnnotation(NodeConfigs.class);
        NodeConfig[] configs = nodeConfigs.value();
        Arrays.sort(configs, new Comparator<NodeConfig>(){

            @Override
            public int compare(NodeConfig c1, NodeConfig c2) {
                return c1.name().compareTo(c2.name());
            }
        });
        refConfig = new SoftReference<NodeConfig[]>(configs);
    }

    static boolean isChild(HTMLNode parent, NodeConfig config) {
        Name[] names;
        if (parent.getConfig().children().length < 1 && parent.getConfig().children_types().length < 1) {
            return true;
        }
        if (parent.getConfig().end() == Tag.FORBIDDEN) {
            return false;
        }
        if (config.hidden()) {
            return true;
        }
        for (Name name : names = parent.getConfig().children()) {
            if (config.name() != name) continue;
            return true;
        }
        Class<?>[] children = parent.getConfig().children_types();
        if (children.length < 1) {
            return false;
        }
        NodeImpl node = new NodeImpl(config.name().toString().toCharArray(), config.name(), TypeToken.TAG);
        for (Class<?> clazz : children) {
            if (!clazz.isInstance(node)) continue;
            return true;
        }
        return false;
    }

    static boolean isEndType(HTMLNode node, NodeConfig config) {
        Name[] names;
        Class<?>[] classes;
        for (Class<?> clazz : classes = config.end_types()) {
            if (clazz != node.getConfig().type()) continue;
            return true;
        }
        for (Name name : names = config.end_names()) {
            if (node.getConfig().name() != name) continue;
            return true;
        }
        return false;
    }

    static {
        mapConfig = new HashMap();
    }
}

