/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.token;

import org.exoplatform.services.chars.CharsUtil;
import org.exoplatform.services.chars.SpecChar;
import org.exoplatform.services.common.util.Queue;
import org.exoplatform.services.token.TypeToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenParser {
    private static char[] closeComment = new char[]{SpecChar.HYPHEN, SpecChar.HYPHEN, SpecChar.CLOSE_TAG};

    public synchronized <T, E extends Factory<T>> void createBeans(Factory<T> factory, char[] data) throws Exception {
        if (data == null || data.length < 2) {
            return;
        }
        int start = 1;
        int end = 0;
        boolean open = false;
        while (end < data.length) {
            if (data[end] == SpecChar.OPEN_TAG && !open) {
                start = factory.create(data, start, end, TypeToken.CONTENT) + 1;
                open = true;
            } else if (data[end] == SpecChar.OPEN_TAG && open) {
                start = Character.isWhitespace(data[start]) ? factory.create(data, start - 1, end, TypeToken.CONTENT) + 1 : factory.create(data, start, end, TypeToken.TAG) + 1;
                open = true;
            } else if (data[end] == SpecChar.CLOSE_TAG && open) {
                if (end < (start = factory.create(data, start, end, TypeToken.TAG) + 1) - 1) {
                    end = start - 1;
                }
                open = false;
            } else if (data[end] == SpecChar.PUNCTUATION_MASK && this.isComment(data, end)) {
                start = end;
                if ((start = factory.create(data, start - 1, end = this.findEndComment(data, end), TypeToken.COMMENT)) < data.length && data[start] == SpecChar.OPEN_TAG) {
                    ++start;
                }
                open = false;
                continue;
            }
            ++end;
        }
        if (start < end) {
            factory.create(data, start, end, TypeToken.CONTENT);
        }
    }

    public boolean isComment(char[] value, int start) {
        if (start < 1) {
            return false;
        }
        if (value[start - 1] != SpecChar.OPEN_TAG) {
            return false;
        }
        return value[start + 1] == SpecChar.HYPHEN && value[start + 2] == SpecChar.HYPHEN;
    }

    public int findEndComment(char[] value, int start) {
        int index = -1;
        index = CharsUtil.indexOf(value, closeComment, start);
        if (index > -1) {
            return index + 3;
        }
        index = CharsUtil.indexOf(value, SpecChar.n, start);
        if (index > -1) {
            return index + 1;
        }
        return value.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Factory<T>
    extends Queue<T> {
        public abstract int create(char[] var1, int var2, int var3, int var4);
    }
}

