/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.bean;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.chromattic.api.BuilderException;
import org.chromattic.api.annotations.Path;
import org.chromattic.metamodel.bean.ArrayPropertyInfo;
import org.chromattic.metamodel.bean.BeanInfo;
import org.chromattic.metamodel.bean.BeanValueInfo;
import org.chromattic.metamodel.bean.CollectionPropertyInfo;
import org.chromattic.metamodel.bean.ListPropertyInfo;
import org.chromattic.metamodel.bean.MapPropertyInfo;
import org.chromattic.metamodel.bean.PropertyInfo;
import org.chromattic.metamodel.bean.SimpleType;
import org.chromattic.metamodel.bean.SimpleValueInfo;
import org.chromattic.metamodel.bean.SingleValuedPropertyInfo;
import org.chromattic.metamodel.bean.ValueInfo;
import org.reflext.api.ArrayTypeInfo;
import org.reflext.api.ClassKind;
import org.reflext.api.ClassTypeInfo;
import org.reflext.api.MethodInfo;
import org.reflext.api.ParameterizedTypeInfo;
import org.reflext.api.SimpleTypeInfo;
import org.reflext.api.TypeInfo;
import org.reflext.api.introspection.AnnotationIntrospector;
import org.reflext.api.introspection.MethodIntrospector;
import org.reflext.api.visit.HierarchyScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanInfoFactory {
    public BeanInfo build(ClassTypeInfo typeInfo) {
        Map<String, PropertyInfo> properties = this.buildProperties(typeInfo);
        return new BeanInfo(typeInfo, properties);
    }

    private Map<String, PropertyInfo> buildProperties(ClassTypeInfo type) {
        PropertyInfo property;
        String name;
        MethodIntrospector introspector = new MethodIntrospector(HierarchyScope.ALL, true);
        Map getterMap = introspector.getGetterMap(type);
        Map setterMap = introspector.getSetterMap(type);
        HashMap<String, PropertyInfo> properties = new HashMap<String, PropertyInfo>();
        for (Map.Entry getterEntry : getterMap.entrySet()) {
            name = (String)getterEntry.getKey();
            MethodInfo getter = (MethodInfo)getterEntry.getValue();
            TypeInfo getterTypeInfo = getter.getReturnType();
            Set setters = (Set)setterMap.get(name);
            property = null;
            if (setters != null) {
                for (MethodInfo setter : setters) {
                    TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                    if (!getterTypeInfo.equals(setterTypeInfo)) continue;
                    property = this.createPropertyInfo(type, name, getterTypeInfo, getter, setter);
                }
            }
            if (property == null) {
                property = this.createPropertyInfo(type, name, getterTypeInfo, getter, null);
            }
            if (property == null) continue;
            properties.put(name, property);
        }
        setterMap.keySet().removeAll(properties.keySet());
        block2: for (Map.Entry setterEntry : setterMap.entrySet()) {
            name = (String)setterEntry.getKey();
            for (MethodInfo setter : (Set)setterEntry.getValue()) {
                TypeInfo setterTypeInfo = (TypeInfo)setter.getParameterTypes().get(0);
                property = this.createPropertyInfo(type, name, setterTypeInfo, null, setter);
                if (property == null) continue;
                properties.put(name, property);
                continue block2;
            }
        }
        return properties;
    }

    private ClassTypeInfo resolveClass(ClassTypeInfo baseType, TypeInfo type) {
        TypeInfo resolvedType = baseType.resolve(type);
        return resolvedType instanceof ClassTypeInfo ? (ClassTypeInfo)resolvedType : null;
    }

    private Map<Class<? extends Annotation>, List<? extends Annotation>> getAnnotations(MethodInfo getter, MethodInfo setter, Class<? extends Annotation> ... annotationClasses) {
        HashMap<Class<? extends Annotation>, List<? extends Annotation>> annotationMap = new HashMap<Class<? extends Annotation>, List<? extends Annotation>>();
        for (Class<? extends Annotation> annotationClass : annotationClasses) {
            List<? extends Annotation> annotations = this.getAnnotation(getter, setter, annotationClass);
            if (annotations.size() <= 0) continue;
            annotationMap.put(annotationClass, annotations);
        }
        return annotationMap;
    }

    private <A extends Annotation> List<A> getAnnotation(MethodInfo getter, MethodInfo setter, Class<A> annotationClass) {
        Annotation setterAnnotation;
        Annotation getterAnnotation;
        AnnotationIntrospector spector = new AnnotationIntrospector(annotationClass);
        ArrayList<Annotation> list = new ArrayList<Annotation>(2);
        if (getter != null && (getterAnnotation = spector.resolve(getter)) != null) {
            list.add(getterAnnotation);
        }
        if (setter != null && (setterAnnotation = spector.resolve(setter)) != null) {
            list.add(setterAnnotation);
        }
        return list;
    }

    private ValueInfo createValue(ClassTypeInfo type, MethodInfo getter, MethodInfo setter) throws BuilderException {
        if (type instanceof SimpleTypeInfo) {
            return this.createSimpleValueInfo(type);
        }
        if (type.getName().equals(String.class.getName())) {
            AnnotationIntrospector intro = new AnnotationIntrospector(Path.class);
            if (getter != null && intro.resolve(getter) != null || setter != null && intro.resolve(setter) != null) {
                return BeanInfoFactory.createPath(type);
            }
            return this.createSimpleValueInfo(type);
        }
        if (type.getName().equals(InputStream.class.getName()) || type.getName().equals(Date.class.getName()) || type.getKind() == ClassKind.ENUM) {
            return this.createSimpleValueInfo(type);
        }
        return new BeanValueInfo(type);
    }

    private PropertyInfo createPropertyInfo(ClassTypeInfo beanTypeInfo, String name, TypeInfo typeInfo, MethodInfo getter, MethodInfo setter) {
        TypeInfo resolvedTI = beanTypeInfo.resolve(typeInfo);
        if (resolvedTI instanceof ParameterizedTypeInfo) {
            ParameterizedTypeInfo parameterizedTI = (ParameterizedTypeInfo)resolvedTI;
            TypeInfo rawTI = parameterizedTI.getRawType();
            if (rawTI instanceof ClassTypeInfo) {
                TypeInfo elementTV;
                ClassTypeInfo elementTI;
                ClassTypeInfo rawClassTI = (ClassTypeInfo)rawTI;
                String rawClassName = rawClassTI.getName();
                if (rawClassName.equals("java.util.Collection") || rawClassName.equals("java.util.List")) {
                    TypeInfo elementTV2 = (TypeInfo)parameterizedTI.getTypeArguments().get(0);
                    ClassTypeInfo elementTI2 = this.resolveClass(beanTypeInfo, elementTV2);
                    if (elementTI2 != null) {
                        ValueInfo resolvedElementTI = this.createValue(elementTI2, getter, setter);
                        if (rawClassName.equals("java.util.Collection")) {
                            return new CollectionPropertyInfo<ValueInfo>(name, resolvedElementTI, getter, setter);
                        }
                        return new ListPropertyInfo<ValueInfo>(name, resolvedElementTI, getter, setter);
                    }
                } else if (rawClassName.equals("java.util.Map") && (elementTI = this.resolveClass(beanTypeInfo, elementTV = (TypeInfo)parameterizedTI.getTypeArguments().get(1))) != null) {
                    ValueInfo resolvedElementTI = this.createValue(elementTI, getter, setter);
                    TypeInfo keyTV = (TypeInfo)parameterizedTI.getTypeArguments().get(0);
                    ClassTypeInfo keyTI = this.resolveClass(beanTypeInfo, keyTV);
                    if (keyTI != null) {
                        ValueInfo resolvedKeyTI = this.createValue(keyTI, getter, setter);
                        return new MapPropertyInfo<ValueInfo, ValueInfo>(name, resolvedElementTI, resolvedKeyTI, getter, setter);
                    }
                }
            }
        } else {
            ClassTypeInfo rawComponentTI;
            ValueInfo resolved;
            TypeInfo componentTI;
            if (resolvedTI instanceof ClassTypeInfo) {
                ValueInfo resolved2 = this.createValue((ClassTypeInfo)resolvedTI, getter, setter);
                return new SingleValuedPropertyInfo<ValueInfo>(name, resolved2, getter, setter);
            }
            if (resolvedTI instanceof ArrayTypeInfo && (componentTI = ((ArrayTypeInfo)resolvedTI).getComponentType()) instanceof ClassTypeInfo && (resolved = this.createValue(rawComponentTI = (ClassTypeInfo)componentTI, getter, setter)) instanceof SimpleValueInfo) {
                return new ArrayPropertyInfo<SimpleValueInfo>(name, (SimpleValueInfo)resolved, getter, setter);
            }
        }
        return null;
    }

    private SimpleValueInfo<?> createSimpleValueInfo(ClassTypeInfo typeInfo) throws BuilderException {
        if (typeInfo == null) {
            throw new NullPointerException();
        }
        if (typeInfo instanceof SimpleTypeInfo && ((SimpleTypeInfo)typeInfo).isPrimitive()) {
            return this.foo(typeInfo);
        }
        switch (typeInfo.getKind()) {
            case CLASS: 
            case ENUM: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return this.foo(typeInfo);
    }

    private <E> SimpleValueInfo<E> foo(ClassTypeInfo typeInfo) {
        SimpleType<?> st = SimpleType.create(typeInfo);
        return new SimpleValueInfo(typeInfo, st);
    }

    private static SimpleValueInfo<String> createPath(ClassTypeInfo typeInfo) {
        if (typeInfo == null) {
            throw new NullPointerException();
        }
        if (typeInfo.getName().equals(String.class.getName())) {
            return new SimpleValueInfo<String>(typeInfo, SimpleType.PATH);
        }
        throw new IllegalArgumentException("Simple value of type path must have a type of " + String.class.getName());
    }
}

