/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Method;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressDisplay
extends JPanel {
    private static final String PROPERTY_XP_INDETERMINATE = "install4j.xpIndeterminate";
    private static boolean JAVA_1_3_AND_LOWER;
    private static boolean JAVA_1_6_AND_HIGHER;
    private JLabel lblStatus;
    private JLabel lblDetail;
    private JProgressBar progressBar;
    private IndeterminateUpdaterThread indeterminateUpdaterThread;
    private GridBagConstraints gc;
    private int percentCompleted = 0;

    public ProgressDisplay() {
        this.setupControls();
        this.setupComponent();
    }

    public void setStatusMessage(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        this.lblStatus.setText(string);
    }

    public void setDetailMessage(String string) {
        if (string.length() == 0) {
            string = " ";
        }
        this.lblDetail.setText(string);
    }

    public void setPercentCompleted(int n) {
        this.percentCompleted = n <= 100 ? n : 100;
        this.progressBar.setValue(n);
    }

    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    private void setupControls() {
        this.lblStatus = new JLabel(" ");
        this.lblDetail = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 0, 100);
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        this.gc = new GridBagConstraints();
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.weightx = 1.0;
        this.gc.fill = 2;
        this.add((Component)this.lblStatus, this.gc);
        ++this.gc.gridy;
        this.add((Component)this.lblDetail, this.gc);
        ++this.gc.gridy;
        this.gc.insets.top = 3;
        this.gc.insets.bottom = 3;
        this.add((Component)this.progressBar, this.gc);
        ++this.gc.gridy;
    }

    public void setIndeterminateProgress(final boolean bl) {
        if (!this.isEmulate()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressDisplay.this.setIndeterminateInternal(bl);
                }
            });
        }
        if (!bl) {
            if (this.indeterminateUpdaterThread == null) {
                return;
            }
            this.indeterminateUpdaterThread.cancel();
            try {
                this.indeterminateUpdaterThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProgressDisplay.this.setPercentCompleted(ProgressDisplay.this.percentCompleted);
                }
            });
            this.indeterminateUpdaterThread = null;
        } else {
            if (this.indeterminateUpdaterThread != null) {
                return;
            }
            this.indeterminateUpdaterThread = new IndeterminateUpdaterThread();
            this.indeterminateUpdaterThread.start();
        }
    }

    private void setIndeterminateInternal(boolean bl) {
        Object object;
        if (JAVA_1_6_AND_HIGHER) {
            this.progressBar.setPreferredSize(null);
            if (bl) {
                object = this.progressBar.getPreferredSize();
                --((Dimension)object).height;
                this.progressBar.setPreferredSize((Dimension)object);
            }
            this.progressBar.invalidate();
            this.validate();
        }
        try {
            object = this.progressBar.getClass().getMethod("setIndeterminate", Boolean.TYPE);
            ((Method)object).invoke((Object)this.progressBar, bl ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isEmulate() {
        return JAVA_1_3_AND_LOWER || GUIHelper.isWindowsXpLaF() && !Boolean.getBoolean(PROPERTY_XP_INDETERMINATE) && !JAVA_1_6_AND_HIGHER;
    }

    public void activate() {
    }

    static {
        String string = System.getProperty("java.version");
        JAVA_1_3_AND_LOWER = string.startsWith("1.2") || string.startsWith("1.3");
        JAVA_1_6_AND_HIGHER = !string.startsWith("1.2") && !string.startsWith("1.3") && !string.startsWith("1.4") && !string.startsWith("1.5");
    }

    private class IndeterminateUpdaterThread
    extends Thread {
        private boolean canceled;

        private IndeterminateUpdaterThread() {
        }

        public void run() {
            while (!this.canceled) {
                for (int i = 0; i <= 100; i += 5) {
                    final int n = i;
                    if (ProgressDisplay.this.isEmulate()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ProgressDisplay.this.progressBar.setValue(n);
                            }
                        });
                    }
                    try {
                        Thread.sleep(80L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        public void cancel() {
            this.canceled = true;
        }
    }
}

