/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VFreeBusy;
import net.fortuna.ical4j.model.component.VToDo;
import net.fortuna.ical4j.model.property.Attach;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.util.CompatibilityHints;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.RemoteCalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCalendarServiceImpl
implements RemoteCalendarService {
    private static final Namespace CALDAV_NAMESPACE = Namespace.getNamespace((String)"C", (String)"urn:ietf:params:xml:ns:caldav");
    private static final String CALDAV_XML_CALENDAR_MULTIGET = "calendar-multiget";
    private static final String CALDAV_XML_CALENDAR_QUERY = "calendar-query";
    private static final String CALDAV_XML_CALENDAR_DATA = "calendar-data";
    private static final String CALDAV_XML_FILTER = "filter";
    private static final String CALDAV_XML_COMP_FILTER = "comp-filter";
    private static final String CALDAV_XML_TIME_RANGE = "time-range";
    private static final String CALDAV_XML_START = "start";
    private static final String CALDAV_XML_END = "end";
    private static final String CALDAV_XML_COMP_FILTER_NAME = "name";
    private static final String CALDAV_XML_TIMEZONE = "timezone";
    private static final Log logger = ExoLogger.getLogger((String)"cs.calendar.service.remote");
    private JCRDataStorage storage_;

    public RemoteCalendarServiceImpl(JCRDataStorage storage) {
        this.storage_ = storage;
    }

    @Override
    public InputStream connectToRemoteServer(String remoteUrl, String remoteType, String remoteUser, String remotePassword) throws IOException {
        HostConfiguration hostConfig = new HostConfiguration();
        String host = new URL(remoteUrl).getHost();
        if (StringUtils.isEmpty((String)host)) {
            host = remoteUrl;
        }
        hostConfig.setHost(host);
        HttpClient client = new HttpClient();
        client.setHostConfiguration(hostConfig);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        client.getHttpConnectionManager().getParams().setSoTimeout(10000);
        if (!StringUtils.isEmpty((String)remoteUser)) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(remoteUser, remotePassword);
            client.getState().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), (Credentials)credentials);
        }
        GetMethod get = new GetMethod(remoteUrl);
        try {
            client.executeMethod((HttpMethod)get);
            InputStream icalInputStream = get.getResponseBodyAsStream();
            return icalInputStream;
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean isValidRemoteUrl(String url, String type, String remoteUser, String remotePassword) throws IOException, UnsupportedOperationException {
        try {
            HttpClient client = new HttpClient();
            HostConfiguration hostConfig = new HostConfiguration();
            String host = new URL(url).getHost();
            if (StringUtils.isEmpty((String)host)) {
                host = url;
            }
            hostConfig.setHost(host);
            client.setHostConfiguration(hostConfig);
            UsernamePasswordCredentials credentials = null;
            client.setHostConfiguration(hostConfig);
            if (!StringUtils.isEmpty((String)remoteUser)) {
                credentials = new UsernamePasswordCredentials(remoteUser, remotePassword);
                client.getState().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), (Credentials)credentials);
            }
            if (type.equals(CalendarService.ICALENDAR)) {
                GetMethod get = new GetMethod(url);
                client.executeMethod((HttpMethod)get);
                int statusCode = get.getStatusCode();
                get.releaseConnection();
                return statusCode == 200;
            }
            if (type.equals(CalendarService.CALDAV)) {
                OptionsMethod options = new OptionsMethod(url);
                client.executeMethod((HttpMethod)options);
                Header header = options.getResponseHeader("DAV");
                options.releaseConnection();
                if (header == null) {
                    logger.debug((Object)"Cannot connect to remoter server or not support WebDav access");
                    return false;
                }
                Boolean support = header.toString().contains("calendar-access");
                options.releaseConnection();
                if (!support.booleanValue()) {
                    logger.debug((Object)"Remote server does not support CalDav access");
                    throw new UnsupportedOperationException("Remote server does not support CalDav access");
                }
                return support;
            }
            return false;
        }
        catch (MalformedURLException e) {
            logger.debug((Object)e.getMessage());
            throw new IOException("URL is invalid. Maybe no legal protocol or URl could not be parsed");
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            throw new IOException("Error occurs when connecting to remote server");
        }
    }

    @Override
    public Calendar importRemoteCalendar(String username, String calendarId, InputStream icalInputStream) throws Exception {
        net.fortuna.ical4j.model.Calendar iCalendar;
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        try {
            iCalendar = calendarBuilder.build(icalInputStream);
        }
        catch (ParserException e) {
            logger.debug((Object)e.getMessage());
            throw new ParserException("Cannot parsed the input stream. The input stream format must be iCalendar", e.getLineNo());
        }
        catch (IOException e) {
            logger.debug((Object)e.getMessage());
            throw new IOException("I/O error when parsing input stream");
        }
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (calService == null) {
            calService = (CalendarService)ExoContainerContext.getContainerByName((String)PortalContainer.getCurrentPortalContainerName()).getComponentInstanceOfType(CalendarService.class);
        }
        HashMap<String, VFreeBusy> vFreeBusyData = new HashMap<String, VFreeBusy>();
        HashMap<String, VAlarm> vAlarmData = new HashMap<String, VAlarm>();
        Calendar eXoCalendar = calService.getUserCalendar(username, calendarId);
        ComponentList componentList = iCalendar.getComponents();
        for (Object obj : componentList) {
            VEvent v;
            if (obj instanceof VEvent && !(v = (VEvent)obj).getAlarms().isEmpty()) {
                for (Object o : v.getAlarms()) {
                    if (!(o instanceof VAlarm)) continue;
                    VAlarm va = (VAlarm)o;
                    vAlarmData.put(v.getUid().getValue() + ":" + va.getProperty("ACTION").getName(), va);
                }
            }
            if (!(obj instanceof VFreeBusy)) continue;
            vFreeBusyData.put(((VFreeBusy)obj).getUid().getValue(), (VFreeBusy)obj);
        }
        for (Object obj : componentList) {
            PropertyList attendees;
            EventCategory evCate;
            CalendarEvent exoEvent;
            VEvent event;
            if (obj instanceof VEvent) {
                PropertyList attendees2;
                event = (VEvent)obj;
                exoEvent = new CalendarEvent();
                if (event.getProperty("CATEGORIES") != null) {
                    evCate = new EventCategory();
                    evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                    try {
                        calService.saveEventCategory(username, evCate, true);
                    }
                    catch (ItemExistsException e) {
                        evCate = calService.getEventCategoryByName(username, evCate.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    exoEvent.setEventCategoryId(evCate.getId());
                    exoEvent.setEventCategoryName(evCate.getName());
                }
                exoEvent.setCalType(String.valueOf(0));
                exoEvent.setCalendarId(calendarId);
                if (event.getSummary() != null) {
                    exoEvent.setSummary(event.getSummary().getValue());
                }
                if (event.getDescription() != null) {
                    exoEvent.setDescription(event.getDescription().getValue());
                }
                if (event.getStatus() != null) {
                    exoEvent.setStatus(event.getStatus().getValue());
                }
                exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
                String sValue = "";
                String eValue = "";
                if (event.getStartDate() != null) {
                    sValue = event.getStartDate().getValue();
                    exoEvent.setFromDateTime((Date)event.getStartDate().getDate());
                }
                if (event.getEndDate() != null) {
                    eValue = event.getEndDate().getValue();
                    exoEvent.setToDateTime((Date)event.getEndDate().getDate());
                }
                if (sValue.length() == 8 && eValue.length() == 8) {
                    exoEvent.setToDateTime(new Date(event.getEndDate().getDate().getTime() - 1L));
                }
                if (sValue.length() > 8 && eValue.length() > 8 && "0000".equals(sValue.substring(9, 13)) && "0000".equals(eValue.substring(9, 13))) {
                    exoEvent.setToDateTime(new Date(event.getEndDate().getDate().getTime() - 1L));
                }
                if (event.getLocation() != null) {
                    exoEvent.setLocation(event.getLocation().getValue());
                }
                if (event.getPriority() != null) {
                    exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
                }
                if (event.getProperty(Utils.X_STATUS) != null) {
                    exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
                }
                if (event.getClassification() != null) {
                    exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
                }
                if (!(attendees2 = event.getProperties("ATTENDEE")).isEmpty()) {
                    String[] invitation = new String[attendees2.size()];
                    for (int i = 0; i < attendees2.size(); ++i) {
                        invitation[i] = ((Attendee)attendees2.get(i)).getValue();
                    }
                    exoEvent.setInvitation(invitation);
                }
                try {
                    PropertyList dataList = event.getProperties("ATTACH");
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    for (Object o : dataList) {
                        Attach a = (Attach)o;
                        Attachment att = new Attachment();
                        att.setName(a.getParameter("CN").getValue());
                        att.setMimeType(a.getParameter("FMTTYPE").getValue());
                        ByteArrayInputStream in = new ByteArrayInputStream(a.getBinary());
                        att.setSize(((InputStream)in).available());
                        att.setInputStream(in);
                        attachments.add(att);
                    }
                    if (!attachments.isEmpty()) {
                        exoEvent.setAttachment(attachments);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                calService.saveUserEvent(username, calendarId, exoEvent, true);
                continue;
            }
            if (!(obj instanceof VToDo)) continue;
            event = (VToDo)obj;
            exoEvent = new CalendarEvent();
            if (event.getProperty("CATEGORIES") != null) {
                evCate = new EventCategory();
                evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                try {
                    calService.saveEventCategory(username, evCate, true);
                }
                catch (ItemExistsException e) {
                    evCate = calService.getEventCategoryByName(username, evCate.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalType(String.valueOf(0));
            exoEvent.setCalendarId(calendarId);
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_TASK);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((Date)event.getStartDate().getDate());
            }
            if (event.getDue() != null) {
                exoEvent.setToDateTime((Date)event.getDue().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
            }
            if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                exoEvent.setStatus(CalendarEvent.ST_BUSY);
            }
            if (event.getProperty(Utils.X_STATUS) != null) {
                exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
            }
            if (event.getClassification() != null) {
                exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
            }
            if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            try {
                PropertyList dataList = event.getProperties("ATTACH");
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Object o : dataList) {
                    Attach a = (Attach)o;
                    Attachment att = new Attachment();
                    att.setName(a.getParameter("CN").getValue());
                    att.setMimeType(a.getParameter("FMTTYPE").getValue());
                    ByteArrayInputStream in = new ByteArrayInputStream(a.getBinary());
                    att.setSize(((InputStream)in).available());
                    att.setInputStream(in);
                    attachments.add(att);
                }
                if (!attachments.isEmpty()) {
                    exoEvent.setAttachment(attachments);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            calService.saveUserEvent(username, calendarId, exoEvent, true);
        }
        return eXoCalendar;
    }

    @Override
    public Calendar importRemoteCalendar(String username, String remoteUrl, String remoteType, String calendarName, String syncPeriod, Credentials credentials) throws Exception {
        String remoteUser = null;
        String remotePassword = null;
        if (credentials != null) {
            remoteUser = ((UsernamePasswordCredentials)credentials).getUserName();
            remotePassword = ((UsernamePasswordCredentials)credentials).getPassword();
        }
        if (remoteType.equals(CalendarService.ICALENDAR)) {
            InputStream icalInputStream = this.connectToRemoteServer(remoteUrl, remoteType, remoteUser, remotePassword);
            Calendar eXoCalendar = this.storage_.createRemoteCalendar(username, calendarName, remoteUrl, remoteType, syncPeriod, remoteUser, remotePassword);
            this.importRemoteCalendar(username, eXoCalendar.getId(), icalInputStream);
            this.storage_.setRemoteCalendarLastUpdated(username, eXoCalendar.getId(), Utils.getGreenwichMeanTime());
            icalInputStream.close();
            return eXoCalendar;
        }
        if (remoteType.equals(CalendarService.CALDAV)) {
            MultiStatus multiStatus = this.connectToCalDavServer(remoteUrl, remoteUser, remotePassword);
            Calendar eXoCalendar = this.storage_.createRemoteCalendar(username, calendarName, remoteUrl, remoteType, syncPeriod, remoteUser, remotePassword);
            CalendarBuilder builder = new CalendarBuilder();
            CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
            for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                MultiStatusResponse multiRes = multiStatus.getResponses()[i];
                String href = multiRes.getHref();
                DavPropertySet propSet = multiRes.getProperties(200);
                DavProperty calendarData = propSet.get(CALDAV_XML_CALENDAR_DATA, CALDAV_NAMESPACE);
                DavProperty etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                try {
                    net.fortuna.ical4j.model.Calendar iCalEvent = builder.build((Reader)new StringReader(calendarData.getValue().toString()));
                    this.importRemoteCalendarEvent(username, eXoCalendar.getId(), iCalEvent, href, etag.getValue().toString());
                    this.storage_.setRemoteCalendarLastUpdated(username, eXoCalendar.getId(), Utils.getGreenwichMeanTime());
                    continue;
                }
                catch (Exception e) {
                    logger.debug((Object)("Exception occurs when import calendar component " + href + ". Skip this component."));
                }
            }
            return eXoCalendar;
        }
        return null;
    }

    @Override
    public Calendar refreshRemoteCalendar(String username, String remoteCalendarId) throws Exception {
        if (!this.storage_.isRemoteCalendar(username, remoteCalendarId)) {
            logger.debug((Object)"This calendar is not remote calendar.");
            return null;
        }
        Node calendarNode = this.storage_.getUserCalendarHome(username).getNode(remoteCalendarId);
        String remoteType = calendarNode.getProperty(Utils.EXO_REMOTE_TYPE).getString();
        if (CalendarService.ICALENDAR.equals(remoteType)) {
            String remoteUrl = calendarNode.getProperty(Utils.EXO_REMOTE_URL).getString();
            String remoteUser = calendarNode.getProperty(Utils.EXO_REMOTE_USERNAME).getString();
            String remotePassword = calendarNode.getProperty(Utils.EXO_REMOTE_PASSWORD).getString();
            InputStream icalInputStream = this.connectToRemoteServer(remoteUrl, remoteType, remoteUser, remotePassword);
            ArrayList<String> calendarIds = new ArrayList<String>();
            calendarIds.add(remoteCalendarId);
            List<CalendarEvent> events = this.storage_.getUserEventByCalendar(username, calendarIds);
            for (CalendarEvent event : events) {
                this.storage_.removeUserEvent(username, remoteCalendarId, event.getId());
            }
            Calendar eXoCalendar = this.importRemoteCalendar(username, remoteCalendarId, icalInputStream);
            this.storage_.setRemoteCalendarLastUpdated(username, eXoCalendar.getId(), Utils.getGreenwichMeanTime());
            icalInputStream.close();
            return eXoCalendar;
        }
        if (CalendarService.CALDAV.equals(remoteType)) {
            java.util.Calendar from = java.util.Calendar.getInstance();
            from.add(1, -1);
            java.util.Calendar to = java.util.Calendar.getInstance();
            to.add(1, 1);
            Calendar eXoCalendar = this.synchronizeWithCalDavServer(username, remoteCalendarId, from, to);
            this.storage_.setRemoteCalendarLastUpdated(username, eXoCalendar.getId(), Utils.getGreenwichMeanTime());
            return eXoCalendar;
        }
        return null;
    }

    @Override
    public boolean isValidate(InputStream icalInputStream) throws Exception {
        try {
            CalendarBuilder calendarBuilder = new CalendarBuilder();
            CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
            calendarBuilder.build(icalInputStream);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public MultiStatus connectToCalDavServer(String url, String username, String password) throws Exception {
        HostConfiguration hostConfig = new HostConfiguration();
        String host = new URL(url).getHost();
        if (StringUtils.isEmpty((String)host)) {
            host = url;
        }
        hostConfig.setHost(host);
        HttpClient client = new HttpClient();
        client.setHostConfiguration(hostConfig);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        client.getHttpConnectionManager().getParams().setSoTimeout(10000);
        if (!StringUtils.isEmpty((String)username)) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            client.getState().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), (Credentials)credentials);
        }
        return this.doCalendarQuery(client, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getEntityTags(HttpClient client, String uri, java.util.Calendar from, java.util.Calendar to) throws Exception {
        HashMap<String, String> etags = new HashMap<String, String>();
        ReportMethod report = null;
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element calendarQuery = DomUtil.createElement((Document)doc, (String)CALDAV_XML_CALENDAR_QUERY, (Namespace)CALDAV_NAMESPACE);
            calendarQuery.setAttributeNS(Namespace.XMLNS_NAMESPACE.getURI(), Namespace.XMLNS_NAMESPACE.getPrefix() + ":" + DavConstants.NAMESPACE.getPrefix(), DavConstants.NAMESPACE.getURI());
            ReportInfo reportInfo = new ReportInfo(calendarQuery, 0);
            DavPropertyNameSet propNameSet = reportInfo.getPropertyNameSet();
            propNameSet.add(DavPropertyName.GETETAG);
            Element filter = DomUtil.createElement((Document)doc, (String)CALDAV_XML_FILTER, (Namespace)CALDAV_NAMESPACE);
            Element calendarComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            calendarComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VCALENDAR");
            Element eventComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            eventComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VEVENT");
            Element todoComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            todoComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VTODO");
            Element timeRange = DomUtil.createElement((Document)doc, (String)CALDAV_XML_TIME_RANGE, (Namespace)CALDAV_NAMESPACE);
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            timeRange.setAttribute(CALDAV_XML_START, format.format(from.getTime()));
            timeRange.setAttribute(CALDAV_XML_END, format.format(to.getTime()));
            eventComp.appendChild(timeRange);
            todoComp.appendChild(timeRange);
            calendarComp.appendChild(eventComp);
            calendarComp.appendChild(todoComp);
            filter.appendChild(calendarComp);
            reportInfo.setContentElement(filter);
            report = new ReportMethod(uri, reportInfo);
            client.executeMethod((HttpMethod)report);
            MultiStatus multiStatus = report.getResponseBodyAsMultiStatus();
            for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                MultiStatusResponse multiRes = multiStatus.getResponses()[i];
                String href = multiRes.getHref();
                DavPropertySet propSet = multiRes.getProperties(200);
                DavProperty etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                etags.put(href, etag.getValue().toString());
            }
            HashMap<String, String> hashMap = etags;
            return hashMap;
        }
        finally {
            if (report != null) {
                report.releaseConnection();
            }
        }
    }

    public Calendar synchronizeWithCalDavServer(String username, String remoteCalendarId, java.util.Calendar from, java.util.Calendar to) throws Exception {
        MultiStatus multiStatus;
        DavProperty etag;
        DavProperty calendarData;
        DavPropertySet propSet;
        MultiStatusResponse multiRes;
        String href;
        if (!this.storage_.isRemoteCalendar(username, remoteCalendarId)) {
            return null;
        }
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (calService == null) {
            calService = (CalendarService)ExoContainerContext.getContainerByName((String)PortalContainer.getCurrentPortalContainerName()).getComponentInstanceOfType(CalendarService.class);
        }
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        if (!CalendarService.CALDAV.equals(calService.getRemoteCalendarType(username, remoteCalendarId))) {
            throw new UnsupportedOperationException("Not support");
        }
        String url = calService.getRemoteCalendarUrl(username, remoteCalendarId);
        String remoteUser = calService.getRemoteCalendarUsername(username, remoteCalendarId);
        String remotePassword = calService.getRemoteCalendarPassword(username, remoteCalendarId);
        HttpClient client = new HttpClient();
        HostConfiguration hostConfig = new HostConfiguration();
        String host = new URL(url).getHost();
        if (StringUtils.isEmpty((String)host)) {
            host = url;
        }
        hostConfig.setHost(host);
        client.setHostConfiguration(hostConfig);
        UsernamePasswordCredentials credentials = null;
        client.setHostConfiguration(hostConfig);
        if (!StringUtils.isEmpty((String)remoteUser)) {
            credentials = new UsernamePasswordCredentials(remoteUser, remotePassword);
            client.getState().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), (Credentials)credentials);
        }
        Map<String, String> entityTags = this.getEntityTags(client, url, from, to);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setCalendarId(new String[]{remoteCalendarId});
        eventQuery.setFromDate(from);
        eventQuery.setToDate(to);
        List<CalendarEvent> eXoEvents = calService.getUserEvents(username, eventQuery);
        Iterator<CalendarEvent> it = eXoEvents.iterator();
        HashMap<String, String> events = new HashMap<String, String>();
        while (it.hasNext()) {
            CalendarEvent event = it.next();
            events.put(calService.getCalDavResourceHref(username, remoteCalendarId, event.getId()), event.getId());
        }
        ArrayList<String> created = new ArrayList<String>();
        HashMap<String, String> updated = new HashMap<String, String>();
        ArrayList<String> deleted = new ArrayList<String>();
        for (Map.Entry<String, String> entry : entityTags.entrySet()) {
            href = entry.getKey();
            String etag2 = entry.getValue();
            if (!events.containsKey(href)) {
                created.add(href);
                continue;
            }
            String eventId = (String)events.get(href);
            String calendarId = calService.getEvent(username, eventId).getCalendarId();
            String localEtag = calService.getCalDavResourceEtag(username, calendarId, eventId);
            if (localEtag.equals(etag2)) continue;
            updated.put(href, eventId);
        }
        for (Map.Entry<String, String> entry : events.entrySet()) {
            href = entry.getKey();
            if (entityTags.containsKey(href)) continue;
            deleted.add(entry.getValue());
        }
        MultiStatus multiStatus2 = this.doCalendarMultiGet(client, url, created.toArray(new String[0]));
        if (multiStatus2 != null) {
            for (int i = 0; i < multiStatus2.getResponses().length; ++i) {
                multiRes = multiStatus2.getResponses()[i];
                href = multiRes.getHref();
                propSet = multiRes.getProperties(200);
                calendarData = propSet.get(CALDAV_XML_CALENDAR_DATA, CALDAV_NAMESPACE);
                etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                try {
                    net.fortuna.ical4j.model.Calendar iCalEvent = calendarBuilder.build((Reader)new StringReader(calendarData.getValue().toString()));
                    this.importRemoteCalendarEvent(username, remoteCalendarId, iCalEvent, href, etag.getValue().toString());
                    continue;
                }
                catch (Exception e) {
                    logger.debug((Object)("Exception occurs when import calendar component " + href + ". Skip this component."));
                }
            }
        }
        if ((multiStatus = this.doCalendarMultiGet(client, url, updated.keySet().toArray(new String[0]))) != null) {
            for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                multiRes = multiStatus.getResponses()[i];
                href = multiRes.getHref();
                propSet = multiRes.getProperties(200);
                calendarData = propSet.get(CALDAV_XML_CALENDAR_DATA, CALDAV_NAMESPACE);
                etag = propSet.get(DavPropertyName.GETETAG.getName(), DavConstants.NAMESPACE);
                String eventId = (String)updated.get(href);
                try {
                    net.fortuna.ical4j.model.Calendar iCalEvent = calendarBuilder.build((Reader)new StringReader(calendarData.getValue().toString()));
                    this.updateRemoteCalendarEvent(username, remoteCalendarId, eventId, iCalEvent, etag.getValue().toString());
                    continue;
                }
                catch (Exception e) {
                    logger.debug((Object)("Exception occurs when import calendar component " + href + ". Skip this component."));
                }
            }
        }
        for (String eventId : deleted) {
            calService.removeUserEvent(username, remoteCalendarId, eventId);
        }
        return calService.getUserCalendar(username, remoteCalendarId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus doCalendarMultiGet(HttpClient client, String uri, String[] hrefs) throws Exception {
        if (hrefs.length == 0) {
            return null;
        }
        ReportMethod report = null;
        try {
            MultiStatus multiStatus;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element calendarMultiGet = DomUtil.createElement((Document)doc, (String)CALDAV_XML_CALENDAR_MULTIGET, (Namespace)CALDAV_NAMESPACE);
            calendarMultiGet.setAttributeNS(Namespace.XMLNS_NAMESPACE.getURI(), Namespace.XMLNS_NAMESPACE.getPrefix() + ":" + DavConstants.NAMESPACE.getPrefix(), DavConstants.NAMESPACE.getURI());
            ReportInfo reportInfo = new ReportInfo(calendarMultiGet, 0);
            DavPropertyNameSet propNameSet = reportInfo.getPropertyNameSet();
            propNameSet.add(DavPropertyName.GETETAG);
            DavPropertyName calendarData = DavPropertyName.create((String)CALDAV_XML_CALENDAR_DATA, (Namespace)CALDAV_NAMESPACE);
            propNameSet.add(calendarData);
            for (int i = 0; i < hrefs.length; ++i) {
                Element href = DomUtil.createElement((Document)doc, (String)"href", (Namespace)DavConstants.NAMESPACE, (String)hrefs[i]);
                reportInfo.setContentElement(href);
            }
            report = new ReportMethod(uri, reportInfo);
            client.executeMethod((HttpMethod)report);
            MultiStatus multiStatus2 = multiStatus = report.getResponseBodyAsMultiStatus();
            return multiStatus2;
        }
        finally {
            if (report != null) {
                report.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiStatus doCalendarQuery(HttpClient client, String uri) throws Exception {
        ReportMethod report = null;
        try {
            MultiStatus multiStatus;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element calendarQuery = DomUtil.createElement((Document)doc, (String)CALDAV_XML_CALENDAR_QUERY, (Namespace)CALDAV_NAMESPACE);
            calendarQuery.setAttributeNS(Namespace.XMLNS_NAMESPACE.getURI(), Namespace.XMLNS_NAMESPACE.getPrefix() + ":" + DavConstants.NAMESPACE.getPrefix(), DavConstants.NAMESPACE.getURI());
            ReportInfo reportInfo = new ReportInfo(calendarQuery, 0);
            DavPropertyNameSet propNameSet = reportInfo.getPropertyNameSet();
            propNameSet.add(DavPropertyName.GETETAG);
            DavPropertyName calendarData = DavPropertyName.create((String)CALDAV_XML_CALENDAR_DATA, (Namespace)CALDAV_NAMESPACE);
            propNameSet.add(calendarData);
            Element filter = DomUtil.createElement((Document)doc, (String)CALDAV_XML_FILTER, (Namespace)CALDAV_NAMESPACE);
            Element calendarComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            calendarComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VCALENDAR");
            Element eventComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            eventComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VEVENT");
            Element todoComp = DomUtil.createElement((Document)doc, (String)CALDAV_XML_COMP_FILTER, (Namespace)CALDAV_NAMESPACE);
            todoComp.setAttribute(CALDAV_XML_COMP_FILTER_NAME, "VTODO");
            calendarComp.appendChild(eventComp);
            calendarComp.appendChild(todoComp);
            filter.appendChild(calendarComp);
            reportInfo.setContentElement(filter);
            report = new ReportMethod(uri, reportInfo);
            client.executeMethod((HttpMethod)report);
            MultiStatus multiStatus2 = multiStatus = report.getResponseBodyAsMultiStatus();
            return multiStatus2;
        }
        finally {
            if (report != null) {
                report.releaseConnection();
            }
        }
    }

    public void importRemoteCalendarEvent(String username, String calendarId, net.fortuna.ical4j.model.Calendar iCalendar, String href, String etag) throws Exception {
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (calService == null) {
            calService = (CalendarService)ExoContainerContext.getContainerByName((String)PortalContainer.getCurrentPortalContainerName()).getComponentInstanceOfType(CalendarService.class);
        }
        HashMap<String, VFreeBusy> vFreeBusyData = new HashMap<String, VFreeBusy>();
        HashMap<String, VAlarm> vAlarmData = new HashMap<String, VAlarm>();
        Calendar eXoCalendar = calService.getUserCalendar(username, calendarId);
        ComponentList componentList = iCalendar.getComponents();
        for (Object obj : componentList) {
            VEvent v;
            if (obj instanceof VEvent && !(v = (VEvent)obj).getAlarms().isEmpty()) {
                for (Object o : v.getAlarms()) {
                    if (!(o instanceof VAlarm)) continue;
                    VAlarm va = (VAlarm)o;
                    vAlarmData.put(v.getUid().getValue() + ":" + va.getProperty("ACTION").getName(), va);
                }
            }
            if (!(obj instanceof VFreeBusy)) continue;
            vFreeBusyData.put(((VFreeBusy)obj).getUid().getValue(), (VFreeBusy)obj);
        }
        for (Object obj : componentList) {
            PropertyList attendees;
            EventCategory evCate;
            CalendarEvent exoEvent;
            VEvent event;
            if (obj instanceof VEvent) {
                PropertyList attendees2;
                event = (VEvent)obj;
                exoEvent = new CalendarEvent();
                if (event.getProperty("CATEGORIES") != null) {
                    evCate = new EventCategory();
                    evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                    try {
                        calService.saveEventCategory(username, evCate, true);
                    }
                    catch (ItemExistsException e) {
                        evCate = calService.getEventCategoryByName(username, evCate.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    exoEvent.setEventCategoryId(evCate.getId());
                    exoEvent.setEventCategoryName(evCate.getName());
                }
                exoEvent.setCalType(String.valueOf(0));
                exoEvent.setCalendarId(calendarId);
                if (event.getSummary() != null) {
                    exoEvent.setSummary(event.getSummary().getValue());
                }
                if (event.getDescription() != null) {
                    exoEvent.setDescription(event.getDescription().getValue());
                }
                if (event.getStatus() != null) {
                    exoEvent.setStatus(event.getStatus().getValue());
                }
                exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
                String sValue = "";
                String eValue = "";
                if (event.getStartDate() != null) {
                    sValue = event.getStartDate().getValue();
                    exoEvent.setFromDateTime((Date)event.getStartDate().getDate());
                }
                if (event.getEndDate() != null) {
                    eValue = event.getEndDate().getValue();
                    exoEvent.setToDateTime((Date)event.getEndDate().getDate());
                }
                if (sValue.length() == 8 && eValue.length() == 8) {
                    exoEvent.setToDateTime(new Date(event.getEndDate().getDate().getTime() - 1L));
                }
                if (sValue.length() > 8 && eValue.length() > 8 && "0000".equals(sValue.substring(9, 13)) && "0000".equals(eValue.substring(9, 13))) {
                    exoEvent.setToDateTime(new Date(event.getEndDate().getDate().getTime() - 1L));
                }
                if (event.getLocation() != null) {
                    exoEvent.setLocation(event.getLocation().getValue());
                }
                if (event.getPriority() != null) {
                    exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
                }
                if (event.getProperty(Utils.X_STATUS) != null) {
                    exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
                }
                if (event.getClassification() != null) {
                    exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
                }
                if (!(attendees2 = event.getProperties("ATTENDEE")).isEmpty()) {
                    String[] invitation = new String[attendees2.size()];
                    for (int i = 0; i < attendees2.size(); ++i) {
                        invitation[i] = ((Attendee)attendees2.get(i)).getValue();
                    }
                    exoEvent.setInvitation(invitation);
                }
                try {
                    PropertyList dataList = event.getProperties("ATTACH");
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    for (Object o : dataList) {
                        Attach a = (Attach)o;
                        Attachment att = new Attachment();
                        att.setName(a.getParameter("CN").getValue());
                        att.setMimeType(a.getParameter("FMTTYPE").getValue());
                        ByteArrayInputStream in = new ByteArrayInputStream(a.getBinary());
                        att.setSize(((InputStream)in).available());
                        att.setInputStream(in);
                        attachments.add(att);
                    }
                    if (!attachments.isEmpty()) {
                        exoEvent.setAttachment(attachments);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                calService.saveUserEvent(username, calendarId, exoEvent, true);
                this.storage_.setRemoteEvent(username, calendarId, exoEvent.getId(), href, etag);
                continue;
            }
            if (!(obj instanceof VToDo)) continue;
            event = (VToDo)obj;
            exoEvent = new CalendarEvent();
            if (event.getProperty("CATEGORIES") != null) {
                evCate = new EventCategory();
                evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                try {
                    calService.saveEventCategory(username, evCate, true);
                }
                catch (ItemExistsException e) {
                    evCate = calService.getEventCategoryByName(username, evCate.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalType(String.valueOf(0));
            exoEvent.setCalendarId(calendarId);
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_TASK);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((Date)event.getStartDate().getDate());
            }
            if (event.getDue() != null) {
                exoEvent.setToDateTime((Date)event.getDue().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
            }
            if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                exoEvent.setStatus(CalendarEvent.ST_BUSY);
            }
            if (event.getProperty(Utils.X_STATUS) != null) {
                exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
            }
            if (event.getClassification() != null) {
                exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
            }
            if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            try {
                PropertyList dataList = event.getProperties("ATTACH");
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Object o : dataList) {
                    Attach a = (Attach)o;
                    Attachment att = new Attachment();
                    att.setName(a.getParameter("CN").getValue());
                    att.setMimeType(a.getParameter("FMTTYPE").getValue());
                    ByteArrayInputStream in = new ByteArrayInputStream(a.getBinary());
                    att.setSize(((InputStream)in).available());
                    att.setInputStream(in);
                    attachments.add(att);
                }
                if (!attachments.isEmpty()) {
                    exoEvent.setAttachment(attachments);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            calService.saveUserEvent(username, calendarId, exoEvent, true);
            this.storage_.setRemoteEvent(username, calendarId, exoEvent.getId(), href, etag);
        }
    }

    public void updateRemoteCalendarEvent(String username, String calendarId, String eventId, net.fortuna.ical4j.model.Calendar iCalendar, String etag) throws Exception {
        CalendarService calService = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        if (calService == null) {
            calService = (CalendarService)ExoContainerContext.getContainerByName((String)PortalContainer.getCurrentPortalContainerName()).getComponentInstanceOfType(CalendarService.class);
        }
        HashMap<String, VFreeBusy> vFreeBusyData = new HashMap<String, VFreeBusy>();
        HashMap<String, VAlarm> vAlarmData = new HashMap<String, VAlarm>();
        Calendar eXoCalendar = calService.getUserCalendar(username, calendarId);
        ComponentList componentList = iCalendar.getComponents();
        for (Object obj : componentList) {
            VEvent v;
            if (obj instanceof VEvent && !(v = (VEvent)obj).getAlarms().isEmpty()) {
                for (Object o : v.getAlarms()) {
                    if (!(o instanceof VAlarm)) continue;
                    VAlarm va = (VAlarm)o;
                    vAlarmData.put(v.getUid().getValue() + ":" + va.getProperty("ACTION").getName(), va);
                }
            }
            if (!(obj instanceof VFreeBusy)) continue;
            vFreeBusyData.put(((VFreeBusy)obj).getUid().getValue(), (VFreeBusy)obj);
        }
        for (Object obj : componentList) {
            PropertyList attendees;
            EventCategory evCate;
            CalendarEvent exoEvent;
            VEvent event;
            if (obj instanceof VEvent) {
                PropertyList attendees2;
                event = (VEvent)obj;
                exoEvent = calService.getEvent(username, eventId);
                if (event.getProperty("CATEGORIES") != null) {
                    evCate = new EventCategory();
                    evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                    try {
                        calService.saveEventCategory(username, evCate, true);
                    }
                    catch (ItemExistsException e) {
                        evCate = calService.getEventCategoryByName(username, evCate.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    exoEvent.setEventCategoryId(evCate.getId());
                    exoEvent.setEventCategoryName(evCate.getName());
                }
                exoEvent.setCalType(String.valueOf(0));
                exoEvent.setCalendarId(calendarId);
                if (event.getSummary() != null) {
                    exoEvent.setSummary(event.getSummary().getValue());
                }
                if (event.getDescription() != null) {
                    exoEvent.setDescription(event.getDescription().getValue());
                }
                if (event.getStatus() != null) {
                    exoEvent.setStatus(event.getStatus().getValue());
                }
                exoEvent.setEventType(CalendarEvent.TYPE_EVENT);
                String sValue = "";
                String eValue = "";
                if (event.getStartDate() != null) {
                    sValue = event.getStartDate().getValue();
                    exoEvent.setFromDateTime((Date)event.getStartDate().getDate());
                }
                if (event.getEndDate() != null) {
                    eValue = event.getEndDate().getValue();
                    exoEvent.setToDateTime((Date)event.getEndDate().getDate());
                }
                if (sValue.length() == 8 && eValue.length() == 8) {
                    exoEvent.setToDateTime(new Date(event.getEndDate().getDate().getTime() - 1L));
                }
                if (sValue.length() > 8 && eValue.length() > 8 && "0000".equals(sValue.substring(9, 13)) && "0000".equals(eValue.substring(9, 13))) {
                    exoEvent.setToDateTime(new Date(event.getEndDate().getDate().getTime() - 1L));
                }
                if (event.getLocation() != null) {
                    exoEvent.setLocation(event.getLocation().getValue());
                }
                if (event.getPriority() != null) {
                    exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
                }
                if (event.getProperty(Utils.X_STATUS) != null) {
                    exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
                }
                if (event.getClassification() != null) {
                    exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
                }
                if (!(attendees2 = event.getProperties("ATTENDEE")).isEmpty()) {
                    String[] invitation = new String[attendees2.size()];
                    for (int i = 0; i < attendees2.size(); ++i) {
                        invitation[i] = ((Attendee)attendees2.get(i)).getValue();
                    }
                    exoEvent.setInvitation(invitation);
                }
                try {
                    PropertyList dataList = event.getProperties("ATTACH");
                    ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                    for (Object o : dataList) {
                        Attach a = (Attach)o;
                        Attachment att = new Attachment();
                        att.setName(a.getParameter("CN").getValue());
                        att.setMimeType(a.getParameter("FMTTYPE").getValue());
                        ByteArrayInputStream in = new ByteArrayInputStream(a.getBinary());
                        att.setSize(((InputStream)in).available());
                        att.setInputStream(in);
                        attachments.add(att);
                    }
                    if (!attachments.isEmpty()) {
                        exoEvent.setAttachment(attachments);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                calService.saveUserEvent(username, calendarId, exoEvent, false);
                this.storage_.setRemoteEvent(username, calendarId, exoEvent.getId(), null, etag);
                continue;
            }
            if (!(obj instanceof VToDo)) continue;
            event = (VToDo)obj;
            exoEvent = new CalendarEvent();
            if (event.getProperty("CATEGORIES") != null) {
                evCate = new EventCategory();
                evCate.setName(event.getProperty("CATEGORIES").getValue().trim());
                try {
                    calService.saveEventCategory(username, evCate, true);
                }
                catch (ItemExistsException e) {
                    evCate = calService.getEventCategoryByName(username, evCate.getName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                exoEvent.setEventCategoryName(evCate.getName());
            }
            exoEvent.setCalType(String.valueOf(0));
            exoEvent.setCalendarId(calendarId);
            if (event.getSummary() != null) {
                exoEvent.setSummary(event.getSummary().getValue());
            }
            if (event.getDescription() != null) {
                exoEvent.setDescription(event.getDescription().getValue());
            }
            if (event.getStatus() != null) {
                exoEvent.setStatus(event.getStatus().getValue());
            }
            exoEvent.setEventType(CalendarEvent.TYPE_TASK);
            if (event.getStartDate() != null) {
                exoEvent.setFromDateTime((Date)event.getStartDate().getDate());
            }
            if (event.getDue() != null) {
                exoEvent.setToDateTime((Date)event.getDue().getDate());
            }
            if (event.getLocation() != null) {
                exoEvent.setLocation(event.getLocation().getValue());
            }
            if (event.getPriority() != null) {
                exoEvent.setPriority(CalendarEvent.PRIORITY[Integer.parseInt(event.getPriority().getValue())]);
            }
            if (vFreeBusyData.get(event.getUid().getValue()) != null) {
                exoEvent.setStatus(CalendarEvent.ST_BUSY);
            }
            if (event.getProperty(Utils.X_STATUS) != null) {
                exoEvent.setEventState(event.getProperty(Utils.X_STATUS).getValue());
            }
            if (event.getClassification() != null) {
                exoEvent.setPrivate(Clazz.PRIVATE.getValue().equals(event.getClassification().getValue()));
            }
            if (!(attendees = event.getProperties("ATTENDEE")).isEmpty()) {
                String[] invitation = new String[attendees.size()];
                for (int i = 0; i < attendees.size(); ++i) {
                    invitation[i] = ((Attendee)attendees.get(i)).getValue();
                }
                exoEvent.setInvitation(invitation);
            }
            try {
                PropertyList dataList = event.getProperties("ATTACH");
                ArrayList<Attachment> attachments = new ArrayList<Attachment>();
                for (Object o : dataList) {
                    Attach a = (Attach)o;
                    Attachment att = new Attachment();
                    att.setName(a.getParameter("CN").getValue());
                    att.setMimeType(a.getParameter("FMTTYPE").getValue());
                    ByteArrayInputStream in = new ByteArrayInputStream(a.getBinary());
                    att.setSize(((InputStream)in).available());
                    att.setInputStream(in);
                    attachments.add(att);
                }
                if (!attachments.isEmpty()) {
                    exoEvent.setAttachment(attachments);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            calService.saveUserEvent(username, calendarId, exoEvent, false);
            this.storage_.setRemoteEvent(username, calendarId, exoEvent.getId(), null, etag);
        }
    }
}

