/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens.componentselection;

import com.install4j.runtime.beans.screens.ComponentsScreen;
import com.install4j.runtime.beans.screens.componentselection.ComponentCellHandler;
import com.install4j.runtime.beans.screens.componentselection.ComponentFolderNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentNode;
import com.install4j.runtime.beans.screens.componentselection.ComponentTreeModel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public class ComponentTree
extends JTree {
    private ComponentsScreen componentsScreen;
    private ComponentCellHandler renderer;
    private ComponentCellHandler editor;
    private boolean isInStartEditing = false;

    public ComponentTree(ComponentsScreen componentsScreen) {
        this.componentsScreen = componentsScreen;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public ComponentsScreen getComponentsScreen() {
        return this.componentsScreen;
    }

    private void setupControls() {
        this.renderer = new ComponentCellHandler(this);
        this.editor = new ComponentCellHandler(this);
    }

    private void setupComponent() {
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        ComponentTreeModel componentTreeModel = new ComponentTreeModel(this);
        this.setModel(componentTreeModel);
        this.setCellRenderer(this.renderer);
        this.setCellEditor(this.editor);
        componentTreeModel.checkFolders();
        this.setRowHeight(0);
        this.setInvokesStopCellEditing(true);
        this.setEditable(true);
        this.getSelectionModel().setSelectionMode(1);
    }

    private void setupEventHandlers() {
        this.addMouseListener(new ComponentTreeMouseListener());
        this.addKeyListener(new ComponentTreeKeyListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ComponentTree.this.stopEditing();
                int n = ComponentTree.this.getRowCount();
                for (int i = 0; i < n; ++i) {
                    TreePath treePath = ComponentTree.this.getPathForRow(i);
                    ComponentTree.this.startEditingAtPath(treePath);
                    ComponentTree.this.stopEditing();
                }
            }
        });
        this.editor.addCellEditorListener(new CellEditorListener(){

            public void editingCanceled(ChangeEvent changeEvent) {
                ComponentTree.this.requestFocus();
            }

            public void editingStopped(ChangeEvent changeEvent) {
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Point point;
        if (mouseEvent != null && (point = this.initRenderer(mouseEvent)) != null) {
            return this.renderer.getToolTipText(point);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startEditingAtPath(TreePath treePath) {
        this.isInStartEditing = true;
        try {
            super.startEditingAtPath(treePath);
        }
        finally {
            this.isInStartEditing = false;
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (!this.isInStartEditing && this.getEditingPath() == null) {
            super.scrollRectToVisible(rectangle);
        }
    }

    public void scrollPathToVisible(TreePath treePath) {
        if (!this.isInStartEditing && this.getEditingPath() == null) {
            super.scrollPathToVisible(treePath);
        }
    }

    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        return null;
    }

    public void removeSelectionRow(int n) {
    }

    private Point initRenderer(MouseEvent mouseEvent) {
        TreePath treePath = this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return null;
        }
        int n = this.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        Rectangle rectangle = this.getRowBounds(n);
        Point point = mouseEvent.getPoint();
        point.translate(-rectangle.x, -rectangle.y);
        this.renderer.getTreeCellRendererComponent(this, treePath.getLastPathComponent(), false, false, true, 0, false);
        this.renderer.setSize(this.renderer.getPreferredSize());
        this.renderer.doLayout();
        return point;
    }

    private class ComponentTreeKeyListener
    extends KeyAdapter {
        private ComponentTreeKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            TreePath treePath;
            if (keyEvent.getKeyCode() == 112) {
                TreePath treePath2 = ComponentTree.this.getSelectionPath();
                if (treePath2 != null) {
                    ComponentNode componentNode = (ComponentNode)treePath2.getLastPathComponent();
                    componentNode.toggleDisplayDescription();
                }
            } else if (keyEvent.getKeyCode() == 32 && (treePath = ComponentTree.this.getSelectionPath()) != null) {
                Object object = treePath.getLastPathComponent();
                ComponentNode componentNode = (ComponentNode)object;
                if (componentNode instanceof ComponentFolderNode && componentNode.isSelected() && !((ComponentFolderNode)componentNode).isAllSelected()) {
                    componentNode.setSelected(true);
                } else {
                    componentNode.setSelected(!componentNode.isSelected());
                }
                ((ComponentTreeModel)ComponentTree.this.getModel()).nodeChanged(componentNode);
                keyEvent.consume();
            }
        }
    }

    private class ComponentTreeMouseListener
    extends MouseAdapter {
        private ComponentTreeMouseListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TreePath treePath = ComponentTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                Point point = ComponentTree.this.initRenderer(mouseEvent);
                if (point == null) {
                    return;
                }
                if (ComponentTree.this.renderer.isPointInLabel(point)) {
                    if (ComponentTree.this.isExpanded(treePath)) {
                        ComponentTree.this.collapsePath(treePath);
                    } else {
                        ComponentTree.this.expandPath(treePath);
                    }
                }
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!ComponentTree.this.isEnabled()) {
                return;
            }
            TreePath treePath = ComponentTree.this.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            Point point = ComponentTree.this.initRenderer(mouseEvent);
            if (point == null) {
                return;
            }
            if (ComponentTree.this.renderer.isPointInLabel(point)) {
                ComponentTree.this.stopEditing();
                ComponentTree.this.setSelectionPath(treePath);
            }
        }
    }
}

