/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AgeOutCache<K> {
    private final ScheduledExecutorService timer;
    private long timeout;
    private final ConcurrentMap<K, ScheduledFuture> map = new ConcurrentHashMap<K, ScheduledFuture>();
    private Handler handler = null;

    public AgeOutCache(ScheduledExecutorService timer, long timeout) {
        this.timer = timer;
        this.timeout = timeout;
    }

    public AgeOutCache(ScheduledExecutorService timer, long timeout, Handler handler) {
        this(timer, timeout);
        this.handler = handler;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public void add(final K key) {
        ScheduledFuture<?> future = this.timer.schedule(new Runnable(){

            @Override
            public void run() {
                ScheduledFuture tmp;
                if (AgeOutCache.this.handler != null) {
                    try {
                        AgeOutCache.this.handler.expired(key);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if ((tmp = (ScheduledFuture)AgeOutCache.this.map.remove(key)) != null) {
                    tmp.cancel(true);
                }
            }
        }, this.timeout, TimeUnit.MILLISECONDS);
        ScheduledFuture<?> result = this.map.putIfAbsent(key, future);
        if (result != null) {
            future.cancel(true);
        }
    }

    public boolean contains(K key) {
        return key != null && this.map.containsKey(key);
    }

    public void remove(K key) {
        ScheduledFuture future = (ScheduledFuture)this.map.remove(key);
        if (future != null) {
            future.cancel(true);
        }
    }

    public void removeAll(Collection<K> keys) {
        if (keys != null) {
            for (K key : keys) {
                this.remove(key);
            }
        }
    }

    public void clear() {
        for (ScheduledFuture future : this.map.values()) {
            future.cancel(true);
        }
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.map.entrySet()) {
            long time_to_expire = ((ScheduledFuture)entry.getValue()).getDelay(TimeUnit.MILLISECONDS);
            sb.append(entry.getKey()).append(": ");
            if (time_to_expire > 0L) {
                sb.append(time_to_expire).append(" ms to expire\n");
                continue;
            }
            sb.append("expired");
        }
        return sb.toString();
    }

    public static interface Handler<K> {
        public void expired(K var1);
    }
}

