/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileEventListenerHandler;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserProfileData;
import org.exoplatform.services.organization.impl.UserProfileImpl;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserProfileDAOImpl
extends BaseDAO
implements UserProfileHandler,
UserProfileEventListenerHandler {
    private List<UserProfileEventListener> listeners = new ArrayList<UserProfileEventListener>(3);
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.organization.ldap.UserProfileDAOImpl");

    public UserProfileDAOImpl(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, CacheHandler cacheHandler) throws Exception {
        super(ldapAttrMapping, ldapService, cacheHandler);
    }

    public final UserProfile createUserProfileInstance() {
        return new UserProfileImpl();
    }

    public UserProfile createUserProfileInstance(String userName) {
        return new UserProfileImpl(userName);
    }

    @Deprecated
    public void createUser(UserProfile profile, boolean broadcast) throws Exception {
        String profileDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + profile.getUserName() + "," + this.ldapAttrMapping.profileURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    ctx.createSubcontext(profileDN, this.ldapAttrMapping.profileToAttributes(profile));
                    return;
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveUserProfile(UserProfile profile, boolean broadcast) throws Exception {
        String profileDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + profile.getUserName() + "," + this.ldapAttrMapping.profileURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    ctx.lookup(profileDN);
                }
                catch (NameNotFoundException e) {
                    ctx.createSubcontext(profileDN, this.ldapAttrMapping.profileToAttributes(profile));
                    this.ldapService.release(ctx);
                    return;
                }
                try {
                    UserProfileData upd = new UserProfileData();
                    upd.setUserProfile(profile);
                    ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapAttrMapping.ldapDescriptionAttr, upd.getProfile()))};
                    ctx.modifyAttributes(profileDN, mods);
                }
                catch (NamingException e) {
                    ctx = this.reloadCtx(ctx, err, e);
                }
                ++err;
                continue;
                break;
            }
        }
        catch (InvalidAttributeValueException invalid) {
            LOG.error((Object)invalid.getLocalizedMessage(), (Throwable)invalid);
            return;
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile removeUserProfile(String userName, boolean broadcast) throws Exception {
        String profileDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + userName + "," + this.ldapAttrMapping.profileURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    Attributes attrs = ctx.getAttributes(profileDN);
                    UserProfile profile = this.ldapAttrMapping.attributesToProfile(attrs).getUserProfile();
                    ctx.destroySubcontext(profileDN);
                    UserProfile userProfile = profile;
                    return userProfile;
                }
                catch (NamingException e) {
                    try {
                        ctx = this.reloadCtx(ctx, err, e);
                        ++err;
                        continue;
                    }
                    catch (NameNotFoundException e2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e2.getLocalizedMessage(), (Throwable)e2);
                        }
                        UserProfile userProfile = null;
                        return userProfile;
                    }
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile findUserProfileByName(String userName) throws Exception {
        String profileDN = this.ldapAttrMapping.membershipTypeNameAttr + "=" + userName + "," + this.ldapAttrMapping.profileURL;
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    Attributes attrs = ctx.getAttributes(profileDN);
                    UserProfile userProfile = this.ldapAttrMapping.attributesToProfile(attrs).getUserProfile();
                    return userProfile;
                }
                catch (NamingException e) {
                    try {
                        ctx = this.reloadCtx(ctx, err, e);
                        ++err;
                        continue;
                    }
                    catch (NameNotFoundException e2) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)e2.getLocalizedMessage(), (Throwable)e2);
                        }
                        UserProfile userProfile = null;
                        return userProfile;
                    }
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public Collection findUserProfiles() throws Exception {
        return null;
    }

    public void addUserProfileEventListener(UserProfileEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public void removeUserProfileEventListener(UserProfileEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public List<UserProfileEventListener> getUserProfileListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

