/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.backup.rdbms;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.database.utils.ExceptionManagementHelper;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectWriterImpl;
import org.exoplatform.services.jcr.impl.dataflow.serialization.ObjectZipWriterImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBBackup {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBBackup");
    @Deprecated
    public static final String CONTENT_FILE_SUFFIX = ".dump";
    @Deprecated
    public static final String CONTENT_LEN_FILE_SUFFIX = ".len";
    public static final String CONTENT_ZIP_FILE = "dump.zip";
    public static final String CONTENT_LEN_ZIP_FILE = "dump-len.zip";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void backup(File storageDir, Connection jdbcConn, Map<String, String> scripts) throws BackupException {
        ObjectWriterImpl contentLenWriter;
        ObjectZipWriterImpl contentWriter;
        Throwable throwable;
        block15: {
            throwable = null;
            contentWriter = null;
            contentLenWriter = null;
            try {
                try {
                    contentWriter = new ObjectZipWriterImpl(PrivilegedFileHelper.zipOutputStream((File)new File(storageDir, CONTENT_ZIP_FILE)));
                    contentLenWriter = new ObjectZipWriterImpl(PrivilegedFileHelper.zipOutputStream((File)new File(storageDir, CONTENT_LEN_ZIP_FILE)));
                    for (Map.Entry<String, String> entry : scripts.entrySet()) {
                        DBBackup.dumpTable(jdbcConn, entry.getKey(), entry.getValue(), storageDir, contentWriter, (ObjectZipWriterImpl)contentLenWriter);
                    }
                    Object var9_12 = null;
                    if (jdbcConn == null) break block15;
                }
                catch (IOException e) {
                    IOException iOException = e;
                    throw new BackupException(e);
                }
                catch (SQLException e) {
                    SQLException sQLException = e;
                    throw new BackupException("SQL Exception: " + ExceptionManagementHelper.getFullSQLExceptionMessage((SQLException)e), e);
                }
            }
            catch (Throwable throwable2) {
                Object var9_13 = null;
                if (jdbcConn != null) {
                    try {
                        jdbcConn.close();
                    }
                    catch (SQLException e) {
                        if (throwable == null) throw new BackupException(e);
                        LOG.error((Object)"Can't close connection", (Throwable)e);
                        throw new BackupException(throwable);
                    }
                }
                try {
                    if (contentWriter != null) {
                        contentWriter.close();
                    }
                    if (contentLenWriter == null) throw throwable2;
                    contentLenWriter.close();
                    throw throwable2;
                }
                catch (IOException e) {
                    if (throwable == null) throw new BackupException(e);
                    LOG.error((Object)"Can't close zip", (Throwable)e);
                    throw new BackupException(throwable);
                }
            }
            try {}
            catch (SQLException e) {
                if (throwable == null) throw new BackupException(e);
                LOG.error((Object)"Can't close connection", (Throwable)e);
                throw new BackupException(throwable);
            }
            jdbcConn.close();
        }
        try {}
        catch (IOException e) {
            if (throwable == null) throw new BackupException(e);
            LOG.error((Object)"Can't close zip", (Throwable)e);
            throw new BackupException(throwable);
        }
        if (contentWriter != null) {
            contentWriter.close();
        }
        if (contentLenWriter == null) return;
        contentLenWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpTable(Connection jdbcConn, String tableName, String script, File storageDir, ObjectZipWriterImpl contentWriter, ObjectZipWriterImpl contentLenWriter) throws IOException, SQLException {
        Statement stmt;
        block13: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
            }
            stmt = null;
            ResultSet rs = null;
            try {
                contentWriter.putNextEntry(new ZipEntry(tableName));
                contentLenWriter.putNextEntry(new ZipEntry(tableName));
                stmt = jdbcConn.prepareStatement(script);
                rs = stmt.executeQuery();
                ResultSetMetaData metaData = rs.getMetaData();
                int columnCount = metaData.getColumnCount();
                int[] columnType = new int[columnCount];
                contentWriter.writeInt(columnCount);
                for (int i = 0; i < columnCount; ++i) {
                    columnType[i] = metaData.getColumnType(i + 1);
                    contentWriter.writeInt(columnType[i]);
                    contentWriter.writeString(metaData.getColumnName(i + 1));
                }
                byte[] tmpBuff = new byte[2048];
                while (rs.next()) {
                    for (int i = 0; i < columnCount; ++i) {
                        InputStream value;
                        if (columnType[i] == -3 || columnType[i] == -4 || columnType[i] == 2004 || columnType[i] == -2 || columnType[i] == 1111) {
                            value = rs.getBinaryStream(i + 1);
                        } else {
                            String str = rs.getString(i + 1);
                            InputStream inputStream = value = str == null ? null : new ByteArrayInputStream(str.getBytes("UTF-8"));
                        }
                        if (value == null) {
                            contentLenWriter.writeLong(-1L);
                            continue;
                        }
                        long len = 0L;
                        int read = 0;
                        while ((read = value.read(tmpBuff)) >= 0) {
                            contentWriter.write(tmpBuff, 0, read);
                            len += (long)read;
                        }
                        contentLenWriter.writeLong(len);
                    }
                }
                contentWriter.closeEntry();
                contentLenWriter.closeEntry();
                Object var19_19 = null;
                if (rs == null) break block13;
            }
            catch (Throwable throwable) {
                Object var19_20 = null;
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                throw throwable;
            }
            rs.close();
        }
        if (stmt != null) {
            stmt.close();
        }
    }
}

