/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.checker;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.checker.AbstractInconsistencyRepair;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.PrimaryTypeNotFoundException;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.WorkspaceStorageConnectionFactory;

public class PropertyRemover
extends AbstractInconsistencyRepair {
    private final NodeTypeDataManager nodeTypeManager;

    public PropertyRemover(WorkspaceStorageConnectionFactory connFactory, NodeTypeDataManager nodeTypeManager) {
        super(connFactory);
        this.nodeTypeManager = nodeTypeManager;
    }

    void repairRow(JDBCStorageConnection conn, ResultSet resultSet) throws SQLException {
        try {
            String parentId = this.exctractId(resultSet, "PARENT_ID");
            InternalQName propertyName = InternalQName.parse(resultSet.getString("NAME"));
            boolean multiValued = resultSet.getBoolean("P_MULTIVALUED");
            PropertyDefinitionDatas def = null;
            try {
                NodeData parent = (NodeData)conn.getItemData(parentId);
                def = this.nodeTypeManager.getPropertyDefinitions(propertyName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
            }
            catch (PrimaryTypeNotFoundException e) {
                // empty catch block
            }
            if (def != null && def.getDefinition(multiValued) != null && !def.getDefinition(multiValued).isResidualSet()) {
                throw new SQLException("Propety is required by its parent.");
            }
            String propertyId = this.exctractId(resultSet, "ID");
            QPath path = new QPath(new QPathEntry[]{this.extractName(resultSet)});
            TransientPropertyData data = new TransientPropertyData(path, propertyId, 0, 0, null, false, new ArrayList<ValueData>());
            conn.delete(data);
        }
        catch (IllegalStateException e) {
            throw new SQLException(e);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
        catch (IllegalNameException e) {
            throw new SQLException(e);
        }
    }
}

