/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype.registration;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.ItemType;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeTypeReadException;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractItemDefinitionAccessProvider {
    protected final DataManager dataManager;

    public AbstractItemDefinitionAccessProvider(DataManager dataManager) {
        this.dataManager = dataManager;
    }

    protected List<ValueData> loadPropertyValues(NodeData parentNode, InternalQName propertyName) throws RepositoryException {
        ItemData property = this.dataManager.getItemData(parentNode, new QPathEntry(propertyName, 1), ItemType.PROPERTY);
        if (property != null) {
            if (property.isNode()) {
                throw new RepositoryException("Fail to load property " + (Object)((Object)propertyName) + "not found for " + parentNode.getQPath().getAsString());
            }
            return ((PropertyData)property).getValues();
        }
        return null;
    }

    public Boolean readBoolean(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        List<ValueData> values = this.loadPropertyValues(parentNode, propertyName);
        if (values != null && values.size() == 1) {
            try {
                return ValueDataConvertor.readBoolean(values.get(0));
            }
            catch (UnsupportedEncodingException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (IllegalStateException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (IOException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
        }
        return new Boolean(false);
    }

    public Long readLong(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        List<ValueData> values = this.loadPropertyValues(parentNode, propertyName);
        if (values != null && values.size() == 1) {
            try {
                return ValueDataConvertor.readLong(values.get(0));
            }
            catch (NumberFormatException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (UnsupportedEncodingException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (IllegalStateException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (IOException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
        }
        return null;
    }

    public Boolean readMandatoryBoolean(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        Boolean name = this.readBoolean(parentNode, propertyName);
        if (name == null) {
            throw new RepositoryException("Mandatory item " + (Object)((Object)propertyName) + "not found for " + parentNode.getQPath().getAsString());
        }
        return name;
    }

    public Long readMandatoryLong(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        Long name = this.readLong(parentNode, propertyName);
        if (name == null) {
            throw new RepositoryException("Mandatory item " + (Object)((Object)propertyName) + "not found for " + parentNode.getQPath().getAsString());
        }
        return name;
    }

    public InternalQName readMandatoryName(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        InternalQName name = this.readName(parentNode, propertyName);
        if (name == null) {
            throw new RepositoryException("Mandatory item " + (Object)((Object)propertyName) + "not found for " + parentNode.getQPath().getAsString());
        }
        return name;
    }

    public InternalQName[] readMandatoryNames(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        InternalQName[] names = this.readNames(parentNode, propertyName);
        if (names == null) {
            throw new RepositoryException("Mandatory item " + (Object)((Object)propertyName) + "not found for " + parentNode.getQPath().getAsString());
        }
        return names;
    }

    public String readMandatoryString(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        String name = this.readString(parentNode, propertyName);
        if (name == null) {
            throw new RepositoryException("Mandatory item " + (Object)((Object)propertyName) + "not found for " + parentNode.getQPath().getAsString());
        }
        return name;
    }

    public String[] readMandatoryStrings(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        String[] name = this.readStrings(parentNode, propertyName);
        if (name == null) {
            throw new RepositoryException("Mandatory item " + (Object)((Object)propertyName) + "not found for " + parentNode.getQPath().getAsString());
        }
        return name;
    }

    public InternalQName readName(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        List<ValueData> values = this.loadPropertyValues(parentNode, propertyName);
        if (values != null && values.size() == 1) {
            try {
                return ValueDataConvertor.readQName(values.get(0));
            }
            catch (UnsupportedEncodingException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (IllegalNameException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (IOException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
        }
        return null;
    }

    public InternalQName[] readNames(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        List<ValueData> values = this.loadPropertyValues(parentNode, propertyName);
        if (values != null) {
            InternalQName[] result = new InternalQName[values.size()];
            int i = 0;
            for (ValueData valueData : values) {
                try {
                    result[i++] = ValueDataConvertor.readQName(valueData);
                }
                catch (UnsupportedEncodingException e) {
                    throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
                }
                catch (IllegalNameException e) {
                    throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
                }
                catch (IOException e) {
                    throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
                }
            }
            return result;
        }
        return new InternalQName[0];
    }

    public String readString(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        List<ValueData> values = this.loadPropertyValues(parentNode, propertyName);
        if (values != null && values.size() == 1) {
            try {
                return ValueDataConvertor.readString(values.get(0));
            }
            catch (UnsupportedEncodingException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
            catch (IOException e) {
                throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
            }
        }
        return null;
    }

    public String[] readStrings(NodeData parentNode, InternalQName propertyName) throws RepositoryException, NodeTypeReadException {
        List<ValueData> values = this.loadPropertyValues(parentNode, propertyName);
        if (values != null && values.size() > 0) {
            String[] result = new String[values.size()];
            int i = 0;
            for (ValueData valueData : values) {
                try {
                    result[i++] = ValueDataConvertor.readString(valueData);
                }
                catch (UnsupportedEncodingException e) {
                    throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
                }
                catch (IOException e) {
                    throw new NodeTypeReadException(e.getLocalizedMessage(), e.getCause());
                }
            }
            return result;
        }
        return new String[0];
    }

    protected void writeBoolean(PlainChangesLog changesLog, NodeData parentNode, InternalQName propertyName, boolean value) {
        TransientPropertyData propertyData = TransientPropertyData.createPropertyData(parentNode, propertyName, 6, false, new TransientValueData(value));
        changesLog.add(ItemState.createAddedState(propertyData));
    }

    protected void writeItemDefinition(PlainChangesLog changesLog, NodeData itemDefinition, ItemDefinitionData nodeDefinitionData) {
        if (nodeDefinitionData.getName() != null) {
            this.writeName(changesLog, itemDefinition, Constants.JCR_NAME, nodeDefinitionData.getName());
        }
        this.writeBoolean(changesLog, itemDefinition, Constants.JCR_PROTECTED, nodeDefinitionData.isProtected());
        this.writeBoolean(changesLog, itemDefinition, Constants.JCR_AUTOCREATED, nodeDefinitionData.isAutoCreated());
        this.writeBoolean(changesLog, itemDefinition, Constants.JCR_MANDATORY, nodeDefinitionData.isMandatory());
        this.writeString(changesLog, itemDefinition, Constants.JCR_ONPARENTVERSION, OnParentVersionAction.nameFromValue((int)nodeDefinitionData.getOnParentVersion()));
    }

    protected void writeName(PlainChangesLog changesLog, NodeData parentNode, InternalQName propertyName, InternalQName value) {
        TransientPropertyData propertyData = TransientPropertyData.createPropertyData(parentNode, propertyName, 7, false, new TransientValueData(value));
        changesLog.add(ItemState.createAddedState(propertyData));
    }

    protected void writeNames(PlainChangesLog changesLog, NodeData parentNode, InternalQName propertyName, InternalQName[] value) {
        ArrayList<ValueData> parents = new ArrayList<ValueData>();
        for (InternalQName nt : value) {
            parents.add(new TransientValueData(nt));
        }
        TransientPropertyData propertyData = TransientPropertyData.createPropertyData(parentNode, propertyName, 7, true, parents);
        changesLog.add(ItemState.createAddedState(propertyData));
    }

    protected void writeString(PlainChangesLog changesLog, NodeData parentNode, InternalQName propertyName, String value) {
        TransientPropertyData propertyData = TransientPropertyData.createPropertyData(parentNode, propertyName, 1, false, new TransientValueData(value));
        changesLog.add(ItemState.createAddedState(propertyData));
    }

    protected void writeStrings(PlainChangesLog changesLog, NodeData parentNode, InternalQName propertyName, String[] value) {
        ArrayList<ValueData> valueDatas = new ArrayList<ValueData>();
        for (String vc : value) {
            if (vc == null) continue;
            valueDatas.add(new TransientValueData(vc));
        }
        TransientPropertyData propertyData = TransientPropertyData.createPropertyData(parentNode, propertyName, 1, true, valueDatas);
        changesLog.add(ItemState.createAddedState(propertyData));
    }
}

