/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.query.LocationStepQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NAryQueryNode;
import org.exoplatform.services.jcr.impl.core.query.NodeTypeQueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;

public class PathQueryNode
extends NAryQueryNode {
    private boolean absolute = false;
    private final List validJcrSystemNodeTypeNames;
    private static final LocationStepQueryNode[] EMPTY = new LocationStepQueryNode[0];

    protected PathQueryNode(QueryNode parent, List validJcrSystemNodeTypeNames) {
        super(parent);
        this.validJcrSystemNodeTypeNames = validJcrSystemNodeTypeNames;
    }

    public List getValidJcrSystemNodeTypeNames() {
        return this.validJcrSystemNodeTypeNames;
    }

    public Object accept(QueryNodeVisitor visitor, Object data) throws RepositoryException {
        return visitor.visit(this, data);
    }

    public int getType() {
        return 11;
    }

    public void addPathStep(LocationStepQueryNode step) {
        this.addOperand(step);
    }

    public LocationStepQueryNode[] getPathSteps() {
        if (this.operands == null) {
            return EMPTY;
        }
        return this.operands.toArray(new LocationStepQueryNode[this.operands.size()]);
    }

    public void setAbsolute(boolean absolute) {
        this.absolute = absolute;
    }

    public boolean isAbsolute() {
        return this.absolute;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PathQueryNode) {
            PathQueryNode other = (PathQueryNode)obj;
            return super.equals(obj) && this.absolute == other.absolute;
        }
        return false;
    }

    public boolean needsSystemTree() {
        LocationStepQueryNode[] pathSteps = this.getPathSteps();
        if (pathSteps == null || pathSteps.length == 0) {
            return true;
        }
        InternalQName firstPathStepName = pathSteps[0].getNameTest();
        if (firstPathStepName == null) {
            NodeTypeQueryNode nodeTypeQueryNode;
            QueryNode[] pathStepOperands = pathSteps[0].getOperands();
            return pathStepOperands.length <= 0 || !(pathStepOperands[0] instanceof NodeTypeQueryNode) || this.validJcrSystemNodeTypeNames.contains((Object)(nodeTypeQueryNode = (NodeTypeQueryNode)pathStepOperands[0]).getValue());
        }
        LocationStepQueryNode firstWorkspaceRelativeStep = pathSteps[0];
        if (firstPathStepName.equals((Object)Constants.ROOT_PATH.getName()) && pathSteps.length > 1) {
            firstWorkspaceRelativeStep = pathSteps[1];
        }
        if (firstWorkspaceRelativeStep.getIncludeDescendants()) {
            return true;
        }
        InternalQName firstWorkspaceRelativeName = firstWorkspaceRelativeStep.getNameTest();
        if (firstWorkspaceRelativeName == null || firstWorkspaceRelativeName.equals((Object)Constants.JCR_SYSTEM)) {
            return true;
        }
        return super.needsSystemTree();
    }
}

