/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.Serializable;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractRecoveryFilter;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.rpc.RPCException;
import org.exoplatform.services.rpc.RPCService;
import org.exoplatform.services.rpc.RemoteCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocNumberRecoveryFilter
extends AbstractRecoveryFilter {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.index.DocNumberRecoveryFilter");
    protected RemoteCommand getDocsNumCommand;
    protected RPCService rpcService;

    public DocNumberRecoveryFilter(SearchIndex searchIndex) {
        super(searchIndex);
        this.rpcService = this.context.getRPCService();
        this.getDocsNumCommand = this.rpcService.registerCommand(new RemoteCommand(){

            public String getId() {
                return "org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberRecoveryFilter-getDocNum-" + DocNumberRecoveryFilter.this.searchIndex.getWsId() + "-" + (DocNumberRecoveryFilter.this.searchIndex.getContext().getParentHandler() == null);
            }

            public Serializable execute(Serializable[] args) throws Throwable {
                log.info("Remote command invoked");
                return Integer.valueOf(DocNumberRecoveryFilter.this.searchIndex.getIndex().numDocs());
            }
        });
    }

    public boolean accept() throws RepositoryException {
        try {
            if (!this.rpcService.isCoordinator()) {
                Integer docsNumber = (Integer)this.rpcService.executeCommandOnCoordinator(this.getDocsNumCommand, true, new Serializable[0]);
                log.info("Remote result received: " + docsNumber + " and local is: " + this.searchIndex.getIndex().numDocs());
                return docsNumber.intValue() != this.searchIndex.getIndex().numDocs();
            }
            return false;
        }
        catch (SecurityException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (RPCException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    public void close() {
        this.rpcService.unregisterCommand(this.getDocsNumCommand);
        super.close();
    }
}

