/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.optimisation;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.naming.NamingException;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.GenericConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.IngresSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.OracleDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.PgSQLDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.init.StorageDBInitializer;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DB2ConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.DefaultOracleConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.GenericCQConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.HSQLDBConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MSSQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.MySQLConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.OracleConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.PostgreConnectionFactory;
import org.exoplatform.services.jcr.impl.storage.jdbc.optimisation.db.SybaseConnectionFactory;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerException;
import org.exoplatform.services.jcr.impl.util.jdbc.DBInitializerHelper;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;
import org.exoplatform.services.jdbc.DataSourceProvider;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.picocontainer.Startable;

public class CQJDBCWorkspaceDataContainer
extends JDBCWorkspaceDataContainer
implements Startable {
    public CQJDBCWorkspaceDataContainer(WorkspaceEntry wsConfig, RepositoryEntry repConfig, InitialContextInitializer contextInit, ValueStoragePluginProvider valueStorageProvider, FileCleanerHolder fileCleanerHolder, DataSourceProvider dsProvider) throws RepositoryConfigurationException, NamingException, RepositoryException, IOException {
        super(wsConfig, repConfig, contextInit, valueStorageProvider, fileCleanerHolder, dsProvider);
    }

    protected void initDatabase() throws NamingException, RepositoryException, IOException {
        StorageDBInitializer dbInitializer = null;
        String sqlPath = DBInitializerHelper.scriptPath(this.dbDialect, this.multiDb);
        if (this.dbDialect == DBConstants.DB_DIALECT_ORACLEOCI) {
            LOG.warn((Object)(DBConstants.DB_DIALECT_ORACLEOCI + " dialect is experimental!"));
            this.connFactory = this.dbSourceName != null ? new DefaultOracleConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints) : new OracleConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints);
            dbInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_ORACLE) {
            this.connFactory = this.dbSourceName != null ? new DefaultOracleConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints) : new DefaultOracleConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner, this.useQueryHints);
            dbInitializer = new OracleDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_PGSQL) {
            this.connFactory = this.dbSourceName != null ? new PostgreConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new PostgreConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            dbInitializer = new PgSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL || this.dbDialect == DBConstants.DB_DIALECT_MYSQL_UTF8 || this.dbDialect == DBConstants.DB_DIALECT_MYSQL_MYISAM || this.dbDialect == DBConstants.DB_DIALECT_MYSQL_MYISAM_UTF8) {
            if (this.dbDialect == DBConstants.DB_DIALECT_MYSQL_MYISAM || this.dbDialect == DBConstants.DB_DIALECT_MYSQL_MYISAM_UTF8) {
                LOG.warn((Object)"MyISAM is not supported due to its lack of transaction support and integrity check, so use it only if you don't expect any support and performances in read accesses are more important than the consistency in your use-case. This dialect is only dedicated to the community.");
            }
            this.connFactory = this.dbSourceName != null ? new MySQLConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new MySQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            dbInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_MSSQL) {
            this.connFactory = this.dbSourceName != null ? new MSSQLConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new MSSQLConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            dbInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DERBY) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2) {
            this.connFactory = this.dbSourceName != null ? new DB2ConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new DB2ConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            dbInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_DB2V8) {
            this.connFactory = this.dbSourceName != null ? new DB2ConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new DB2ConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            dbInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_SYBASE) {
            this.connFactory = this.dbSourceName != null ? new SybaseConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new SybaseConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            dbInitializer = this.defaultDBInitializer(sqlPath);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_INGRES) {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = new IngresSQLDBInitializer(this.containerName, this.connFactory.getJdbcConnection(), sqlPath, this.multiDb);
        } else if (this.dbDialect == DBConstants.DB_DIALECT_HSQLDB) {
            this.connFactory = this.dbSourceName != null ? new HSQLDBConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner) : new HSQLDBConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
            dbInitializer = this.defaultDBInitializer(sqlPath);
        } else {
            this.connFactory = this.defaultConnectionFactory();
            dbInitializer = this.defaultDBInitializer(sqlPath);
        }
        try {
            dbInitializer.init();
        }
        catch (DBInitializerException e) {
            LOG.error((Object)("Error of init db " + e), (Throwable)e);
        }
    }

    protected GenericConnectionFactory defaultConnectionFactory() throws NamingException, RepositoryException {
        if (this.dbSourceName != null) {
            return new GenericCQConnectionFactory(this.getDataSource(), this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
        }
        return new GenericCQConnectionFactory(this.dbDriver, this.dbUrl, this.dbUserName, this.dbPassword, this.containerName, this.multiDb, this.valueStorageProvider, this.maxBufferSize, this.swapDirectory, this.swapCleaner);
    }
}

