/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.exoplatform.services.jcr.impl.storage.value.ValueDataResourceHolder;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.jcr.impl.storage.value.fs.TreeFile;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;

public class TreeFileIOChannel
extends FileIOChannel {
    private static final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);

    TreeFileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueDataResourceHolder resources) {
        super(rootDir, cleaner, storageId, resources);
    }

    protected String makeFilePath(String propertyId, int orderNumber) {
        return this.buildPath(propertyId) + File.separator + propertyId + orderNumber;
    }

    protected File getFile(String propertyId, int orderNumber) throws IOException {
        TreeFile tfile = new TreeFile(this.rootDir.getAbsolutePath() + this.makeFilePath(propertyId, orderNumber), this.cleaner, this.rootDir);
        TreeFileIOChannel.mkdirs(tfile.getParentFile());
        return tfile;
    }

    protected File[] getFiles(String propertyId) throws IOException {
        File dir = new File(this.rootDir.getAbsolutePath() + this.buildPath(propertyId));
        String[] fileNames = dir.list();
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new TreeFile(dir.getAbsolutePath() + File.separator + fileNames[i], this.cleaner, this.rootDir);
        }
        return files;
    }

    protected String buildPath(String fileName) {
        return this.buildPathX8(fileName);
    }

    protected String buildPathX(String fileName) {
        char[] chs = fileName.toCharArray();
        StringBuilder path = new StringBuilder();
        for (char ch : chs) {
            path.append(File.separator).append(ch);
        }
        return path.toString();
    }

    protected String buildPathX8(String fileName) {
        int xLength = 8;
        char[] chs = fileName.toCharArray();
        StringBuilder path = new StringBuilder();
        for (int i = 0; i < 8; ++i) {
            path.append(File.separator).append(chs[i]);
        }
        path.append(fileName.substring(8));
        return path.toString();
    }

    protected String buildPathXX2X4(String fileName) {
        int xxLength = 4;
        int xLength = 8;
        boolean xxBlock = true;
        char[] chs = fileName.toCharArray();
        StringBuilder path = new StringBuilder();
        for (int xxi = 0; xxi < 4; ++xxi) {
            char ch = chs[xxi];
            path.append(xxBlock ? File.separator + ch : Character.valueOf(ch));
            xxBlock = !xxBlock;
        }
        for (int xi = 4; xi < 8; ++xi) {
            path.append(File.separator).append(chs[xi]);
        }
        path.append(fileName.substring(8));
        return path.toString();
    }

    protected String buildPathXX(String fileName) {
        char[] chs = fileName.toCharArray();
        StringBuilder path = new StringBuilder();
        boolean block = true;
        for (char ch : chs) {
            path.append(block ? File.separator + ch : Character.valueOf(ch));
            block = !block;
        }
        return path.toString();
    }

    protected String buildPathXX8(String fileName) {
        int xxLength = 16;
        char[] chs = fileName.toCharArray();
        StringBuilder path = new StringBuilder();
        boolean block = true;
        for (int i = 0; i < 16; ++i) {
            char ch = chs[i];
            path.append(block ? File.separator + ch : Character.valueOf(ch));
            block = !block;
        }
        path.append(fileName.substring(16));
        return path.toString();
    }

    private static void mkdirs(File dir) {
        if (dir.exists()) {
            return;
        }
        ArrayList<File> dir2Create = new ArrayList<File>();
        dir2Create.add(dir);
        for (dir = dir.getParentFile(); dir != null && !dir.exists(); dir = dir.getParentFile()) {
            dir2Create.add(0, dir);
        }
        int length = dir2Create.size();
        for (int i = 0; i < length; ++i) {
            TreeFileIOChannel.mkdir((File)dir2Create.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mkdir(File dir) {
        Lock prevLock;
        String path = dir.getAbsolutePath();
        Lock lock = (Lock)locks.get(path);
        if (lock == null && (prevLock = locks.putIfAbsent(path, lock = new ReentrantLock())) != null) {
            lock = prevLock;
        }
        lock.lock();
        try {
            if (!dir.exists()) {
                dir.mkdir();
            }
            Object var5_4 = null;
            lock.unlock();
            locks.remove(path, lock);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            lock.unlock();
            locks.remove(path, lock);
            throw throwable;
        }
    }
}

