/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.model;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.shindig.protocol.model.Enum;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.UrlImpl;
import org.apache.shindig.social.opensocial.model.Account;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.BodyType;
import org.apache.shindig.social.opensocial.model.Drinker;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.LookingFor;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.NetworkPresence;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Smoker;
import org.apache.shindig.social.opensocial.model.Url;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonImpl
implements Person {
    private String aboutMe;
    private List<Account> accounts;
    private List<String> activities;
    private List<Address> addresses;
    private Integer age;
    private Map<String, ?> appData;
    private Date birthday;
    private BodyType bodyType;
    private List<String> books;
    private List<String> cars;
    private String children;
    private Address currentLocation;
    private String displayName;
    private Enum<Drinker> drinker;
    private List<ListField> emails;
    private String ethnicity;
    private String fashion;
    private List<String> food;
    private Person.Gender gender;
    private String happiestWhen;
    private Boolean hasApp;
    private List<String> heroes;
    private String humor;
    private String id;
    private List<ListField> ims;
    private List<String> interests;
    private String jobInterests;
    private List<String> languagesSpoken;
    private String livingArrangement;
    private List<Enum<LookingFor>> lookingFor;
    private List<String> movies;
    private List<String> music;
    private Name name;
    private Enum<NetworkPresence> networkPresence;
    private String nickname;
    private List<Organization> organizations;
    private String pets;
    private List<ListField> phoneNumbers;
    private List<ListField> photos;
    private String politicalViews;
    private String preferredUsername;
    private Url profileSong;
    private Url profileVideo;
    private List<String> quotes;
    private String relationshipStatus;
    private String religion;
    private String romance;
    private String scaredOf;
    private String sexualOrientation;
    private Enum<Smoker> smoker;
    private List<String> sports;
    private String status;
    private List<String> tags;
    private Long utcOffset;
    private List<String> turnOffs;
    private List<String> turnOns;
    private List<String> tvShows;
    private Date updated;
    private List<Url> urls;
    private boolean isOwner = false;
    private boolean isViewer = false;

    public PersonImpl() {
    }

    public PersonImpl(String id, String displayName, Name name) {
        this.id = id;
        this.displayName = displayName;
        this.name = name;
    }

    @Override
    public String getAboutMe() {
        return this.aboutMe;
    }

    @Override
    public void setAboutMe(String aboutMe) {
        this.aboutMe = aboutMe;
    }

    @Override
    public List<Account> getAccounts() {
        return this.accounts;
    }

    @Override
    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    @Override
    public List<String> getActivities() {
        return this.activities;
    }

    @Override
    public void setActivities(List<String> activities) {
        this.activities = activities;
    }

    @Override
    public List<Address> getAddresses() {
        return this.addresses;
    }

    @Override
    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    @Override
    public Integer getAge() {
        return this.age;
    }

    @Override
    public void setAge(Integer age) {
        this.age = age;
    }

    @Override
    public Map<String, ?> getAppData() {
        return this.appData;
    }

    @Override
    public void setAppData(Map<String, ?> appData) {
        this.appData = appData;
    }

    @Override
    public BodyType getBodyType() {
        return this.bodyType;
    }

    @Override
    public void setBodyType(BodyType bodyType) {
        this.bodyType = bodyType;
    }

    @Override
    public List<String> getBooks() {
        return this.books;
    }

    @Override
    public void setBooks(List<String> books) {
        this.books = books;
    }

    @Override
    public List<String> getCars() {
        return this.cars;
    }

    @Override
    public void setCars(List<String> cars) {
        this.cars = cars;
    }

    @Override
    public String getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(String children) {
        this.children = children;
    }

    @Override
    public Address getCurrentLocation() {
        return this.currentLocation;
    }

    @Override
    public void setCurrentLocation(Address currentLocation) {
        this.currentLocation = currentLocation;
    }

    @Override
    public Date getBirthday() {
        if (this.birthday == null) {
            return null;
        }
        return new Date(this.birthday.getTime());
    }

    @Override
    public void setBirthday(Date birthday) {
        this.birthday = birthday == null ? null : new Date(birthday.getTime());
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public Enum<Drinker> getDrinker() {
        return this.drinker;
    }

    @Override
    public void setDrinker(Enum<Drinker> newDrinker) {
        this.drinker = newDrinker;
    }

    @Override
    public List<ListField> getEmails() {
        return this.emails;
    }

    @Override
    public void setEmails(List<ListField> emails) {
        this.emails = emails;
    }

    @Override
    public String getEthnicity() {
        return this.ethnicity;
    }

    @Override
    public void setEthnicity(String ethnicity) {
        this.ethnicity = ethnicity;
    }

    @Override
    public String getFashion() {
        return this.fashion;
    }

    @Override
    public void setFashion(String fashion) {
        this.fashion = fashion;
    }

    @Override
    public List<String> getFood() {
        return this.food;
    }

    @Override
    public void setFood(List<String> food) {
        this.food = food;
    }

    @Override
    public Person.Gender getGender() {
        return this.gender;
    }

    @Override
    public void setGender(Person.Gender newGender) {
        this.gender = newGender;
    }

    @Override
    public String getHappiestWhen() {
        return this.happiestWhen;
    }

    @Override
    public void setHappiestWhen(String happiestWhen) {
        this.happiestWhen = happiestWhen;
    }

    @Override
    public Boolean getHasApp() {
        return this.hasApp;
    }

    @Override
    public void setHasApp(Boolean hasApp) {
        this.hasApp = hasApp;
    }

    @Override
    public List<String> getHeroes() {
        return this.heroes;
    }

    @Override
    public void setHeroes(List<String> heroes) {
        this.heroes = heroes;
    }

    @Override
    public String getHumor() {
        return this.humor;
    }

    @Override
    public void setHumor(String humor) {
        this.humor = humor;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public List<ListField> getIms() {
        return this.ims;
    }

    @Override
    public void setIms(List<ListField> ims) {
        this.ims = ims;
    }

    @Override
    public List<String> getInterests() {
        return this.interests;
    }

    @Override
    public void setInterests(List<String> interests) {
        this.interests = interests;
    }

    @Override
    public String getJobInterests() {
        return this.jobInterests;
    }

    @Override
    public void setJobInterests(String jobInterests) {
        this.jobInterests = jobInterests;
    }

    @Override
    public List<String> getLanguagesSpoken() {
        return this.languagesSpoken;
    }

    @Override
    public void setLanguagesSpoken(List<String> languagesSpoken) {
        this.languagesSpoken = languagesSpoken;
    }

    @Override
    public Date getUpdated() {
        if (this.updated == null) {
            return null;
        }
        return new Date(this.updated.getTime());
    }

    @Override
    public void setUpdated(Date updated) {
        this.updated = updated == null ? null : new Date(updated.getTime());
    }

    @Override
    public String getLivingArrangement() {
        return this.livingArrangement;
    }

    @Override
    public void setLivingArrangement(String livingArrangement) {
        this.livingArrangement = livingArrangement;
    }

    @Override
    public List<Enum<LookingFor>> getLookingFor() {
        return this.lookingFor;
    }

    @Override
    public void setLookingFor(List<Enum<LookingFor>> lookingFor) {
        this.lookingFor = lookingFor;
    }

    @Override
    public List<String> getMovies() {
        return this.movies;
    }

    @Override
    public void setMovies(List<String> movies) {
        this.movies = movies;
    }

    @Override
    public List<String> getMusic() {
        return this.music;
    }

    @Override
    public void setMusic(List<String> music) {
        this.music = music;
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public void setName(Name name) {
        this.name = name;
    }

    @Override
    public Enum<NetworkPresence> getNetworkPresence() {
        return this.networkPresence;
    }

    @Override
    public void setNetworkPresence(Enum<NetworkPresence> networkPresence) {
        this.networkPresence = networkPresence;
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    @Override
    public List<Organization> getOrganizations() {
        return this.organizations;
    }

    @Override
    public void setOrganizations(List<Organization> organizations) {
        this.organizations = organizations;
    }

    @Override
    public String getPets() {
        return this.pets;
    }

    @Override
    public void setPets(String pets) {
        this.pets = pets;
    }

    @Override
    public List<ListField> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @Override
    public void setPhoneNumbers(List<ListField> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    @Override
    public List<ListField> getPhotos() {
        return this.photos;
    }

    @Override
    public void setPhotos(List<ListField> photos) {
        this.photos = photos;
    }

    @Override
    public String getPoliticalViews() {
        return this.politicalViews;
    }

    @Override
    public void setPoliticalViews(String politicalViews) {
        this.politicalViews = politicalViews;
    }

    @Override
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Override
    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    @Override
    public Url getProfileSong() {
        return this.profileSong;
    }

    @Override
    public void setProfileSong(Url profileSong) {
        this.profileSong = profileSong;
    }

    @Override
    public Url getProfileVideo() {
        return this.profileVideo;
    }

    @Override
    public void setProfileVideo(Url profileVideo) {
        this.profileVideo = profileVideo;
    }

    @Override
    public List<String> getQuotes() {
        return this.quotes;
    }

    @Override
    public void setQuotes(List<String> quotes) {
        this.quotes = quotes;
    }

    @Override
    public String getRelationshipStatus() {
        return this.relationshipStatus;
    }

    @Override
    public void setRelationshipStatus(String relationshipStatus) {
        this.relationshipStatus = relationshipStatus;
    }

    @Override
    public String getReligion() {
        return this.religion;
    }

    @Override
    public void setReligion(String religion) {
        this.religion = religion;
    }

    @Override
    public String getRomance() {
        return this.romance;
    }

    @Override
    public void setRomance(String romance) {
        this.romance = romance;
    }

    @Override
    public String getScaredOf() {
        return this.scaredOf;
    }

    @Override
    public void setScaredOf(String scaredOf) {
        this.scaredOf = scaredOf;
    }

    @Override
    public String getSexualOrientation() {
        return this.sexualOrientation;
    }

    @Override
    public void setSexualOrientation(String sexualOrientation) {
        this.sexualOrientation = sexualOrientation;
    }

    @Override
    public Enum<Smoker> getSmoker() {
        return this.smoker;
    }

    @Override
    public void setSmoker(Enum<Smoker> newSmoker) {
        this.smoker = newSmoker;
    }

    @Override
    public List<String> getSports() {
        return this.sports;
    }

    @Override
    public void setSports(List<String> sports) {
        this.sports = sports;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(String status) {
        this.status = status;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Override
    public Long getUtcOffset() {
        return this.utcOffset;
    }

    @Override
    public void setUtcOffset(Long utcOffset) {
        this.utcOffset = utcOffset;
    }

    @Override
    public List<String> getTurnOffs() {
        return this.turnOffs;
    }

    @Override
    public void setTurnOffs(List<String> turnOffs) {
        this.turnOffs = turnOffs;
    }

    @Override
    public List<String> getTurnOns() {
        return this.turnOns;
    }

    @Override
    public void setTurnOns(List<String> turnOns) {
        this.turnOns = turnOns;
    }

    @Override
    public List<String> getTvShows() {
        return this.tvShows;
    }

    @Override
    public void setTvShows(List<String> tvShows) {
        this.tvShows = tvShows;
    }

    @Override
    public List<Url> getUrls() {
        return this.urls;
    }

    @Override
    public void setUrls(List<Url> urls) {
        this.urls = urls;
    }

    @Override
    public boolean getIsOwner() {
        return this.isOwner;
    }

    @Override
    public void setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
    }

    @Override
    public boolean getIsViewer() {
        return this.isViewer;
    }

    @Override
    public void setIsViewer(boolean isViewer) {
        this.isViewer = isViewer;
    }

    @Override
    public String getProfileUrl() {
        Url url = this.getListFieldWithType("profile", this.getUrls());
        return url == null ? null : url.getValue();
    }

    @Override
    public void setProfileUrl(String profileUrl) {
        Url url = this.getListFieldWithType("profile", this.getUrls());
        if (url != null) {
            url.setValue(profileUrl);
        } else if (profileUrl != null) {
            this.setUrls(this.addListField(new UrlImpl(profileUrl, null, "profile"), this.getUrls()));
        }
    }

    @Override
    public String getThumbnailUrl() {
        ListField photo = this.getListFieldWithType("thumbnail", this.getPhotos());
        return photo == null ? null : photo.getValue();
    }

    @Override
    public void setThumbnailUrl(String thumbnailUrl) {
        ListField photo = this.getListFieldWithType("thumbnail", this.getPhotos());
        if (photo != null) {
            photo.setValue(thumbnailUrl);
        } else if (thumbnailUrl != null) {
            this.setPhotos(this.addListField(new ListFieldImpl("thumbnail", thumbnailUrl), this.getPhotos()));
        }
    }

    private <T extends ListField> T getListFieldWithType(String type, List<T> list) {
        if (list != null) {
            for (ListField url : list) {
                if (!type.equalsIgnoreCase(url.getType())) continue;
                return (T)url;
            }
        }
        return null;
    }

    private <T extends ListField> List<T> addListField(T field, List<T> list) {
        if (list == null) {
            list = Lists.newArrayList();
        }
        list.add(field);
        return list;
    }
}

