/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.atom;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import org.apache.shindig.social.core.util.atom.AtomLink;

public class AtomLinkConverter
implements Converter {
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        AtomLink link = (AtomLink)object;
        if (link.getRel() != null) {
            writer.addAttribute("rel", link.getRel());
        }
        if (link.getHref() != null) {
            writer.setValue(link.getHref());
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Preconditions.checkNotNull((Object)reader);
        reader.moveDown();
        AtomLink al = new AtomLink(reader.getAttribute("rel"), reader.getValue());
        reader.moveUp();
        return al;
    }

    public boolean canConvert(Class clazz) {
        return AtomLink.class.equals((Object)clazz);
    }
}

